<?php
if (!isset($_SESSION)) {
	session_start();
}
if (!isset($_SESSION['is_login'])) {
	header("location: login.php");
?>
	<script>
		window.location = "login.php";
	</script>
<?php
}


date_default_timezone_set($_SESSION['system_time_zone']);

if (isset($_POST['type']) || isset($_GET['type'])) {
	require_once "db_connect.php";


	if (isset($_GET['type']) && ($_GET['type'] == "load")) {

		$cond 					= "";
		$system_staff_id_fk  	= $_SESSION['system_staff_id_fk'];
		$by 					= $_SESSION['user_id'];
		$department_id_fk 		= $_SESSION['department_id_fk'];
		$date_cond 				= '';



		$cond = isset($_GET['id']) ? " AND PR.patient_id_fk=" . $_GET['id'] : " ";

		/*
SELECT 
    NULL AS patient_report_id,
    LT.lab_test_id AS lab_test_id,
    NULL AS rad_test_id,
    NULL AS report_reference_number,
    LT.test_number AS lab_test_number,
    NULL AS rad_test_number,
    P.patient_full_name,
    P.patient_phone,
    IFNULL(S.full_name,'') AS site_doctor,
    P.patient_id,
    P.patient_id AS patient_code,
    PR.created_at,
    'Lab Test' AS record_type
FROM patient P
LEFT JOIN patient_report PR ON PR.patient_id_fk = P.patient_id
LEFT JOIN staff S ON PR.staff_id_fk = S.staff_id
LEFT JOIN lab_test LT ON LT.patient_id_fk = P.patient_id AND LT.is_deleted = 0
WHERE P.is_deleted = 0

UNION ALL

-- Radiology test records
SELECT 
    NULL AS patient_report_id,
    NULL AS lab_test_id,
    RT.radiology_test_id AS rad_test_id,
    NULL AS report_reference_number,
    NULL AS lab_test_number,
    RT.test_number AS rad_test_number,
    P.patient_full_name,
    P.patient_phone,
    IFNULL(S.full_name,'') AS site_doctor,
    P.patient_id,
    P.patient_id AS patient_code,
    PR.created_at,
    'Radiology Test' AS record_type
FROM patient P
LEFT JOIN patient_report PR ON PR.patient_id_fk = P.patient_id
LEFT JOIN staff S ON PR.staff_id_fk = S.staff_id
LEFT JOIN radiology_test RT ON RT.patient_id_fk = P.patient_id AND RT.is_deleted = 0
WHERE P.is_deleted = 0

UNION ALL

-- Patient report records
SELECT 
    PR.patient_report_id,
    NULL AS lab_test_id,
    NULL AS rad_test_id,
    PR.report_reference_number,
    NULL AS lab_test_number,
    NULL AS rad_test_number,
    P.patient_full_name,
    P.patient_phone,
    IFNULL(S.full_name,'') AS site_doctor,
    P.patient_id,
    P.patient_id AS patient_code,
    PR.created_at,
    'Patient Report' AS record_type -- Indicating this record is a patient report
FROM patient P
LEFT JOIN patient_report PR ON PR.patient_id_fk = P.patient_id
LEFT JOIN staff S ON PR.staff_id_fk = S.staff_id
WHERE P.is_deleted = 0
*/
		/*
SELECT 
    patient_report_id,
    lab_test_id,
    rad_test_id,
    CASE 
        WHEN report_row_number = 1 THEN report_reference_number
        ELSE NULL
    END as report_reference_number,
    CASE 
        WHEN lab_test_row_number = 1 THEN lab_test_number
        ELSE NULL
    END as lab_test_number,
    CASE 
        WHEN rad_test_row_number = 1 THEN rad_test_number
        ELSE NULL
    END as rad_test_number,
    patient_full_name,
    patient_phone,
    site_doctor,
    patient_id,
    patient_code,
    created_at
FROM (
    SELECT 
        PR.patient_report_id,
        LT.lab_test_id as lab_test_id,
        RT.radiology_test_id as rad_test_id,
        PR.report_reference_number,
        LT.test_number as lab_test_number,
        RT.test_number as rad_test_number,
        P.patient_full_name,
        P.patient_phone,
        IFNULL(S.full_name,'') as site_doctor,
        P.patient_id,
        P.patient_id as patient_code,
        PR.created_at,
        ROW_NUMBER() OVER(PARTITION BY P.patient_id ORDER BY PR.created_at) as report_row_number,
        ROW_NUMBER() OVER(PARTITION BY P.patient_id, LT.lab_test_id ORDER BY LT.created_at) as lab_test_row_number,
        ROW_NUMBER() OVER(PARTITION BY P.patient_id, RT.radiology_test_id ORDER BY RT.created_at) as rad_test_row_number
    FROM patient P
    LEFT JOIN patient_report PR ON PR.patient_id_fk = P.patient_id
    LEFT JOIN staff S ON PR.staff_id_fk = S.staff_id
    LEFT JOIN lab_test LT ON LT.patient_id_fk = P.patient_id AND LT.is_deleted = 0
    LEFT JOIN radiology_test RT ON RT.patient_id_fk = P.patient_id AND RT.is_deleted = 0
    WHERE P.is_deleted = 0



	SELECT 
    patient_report_id,
    LT.lab_test_id as lab_test_id,
    RT.radiology_test_id as rad_test_id,
    report_reference_number,
    LT.test_number as lab_test_number,
	RT.test_number as rad_test_number,
    patient_full_name,
    patient_phone,
    IFNULL(S.full_name,'') as site_doctor,
    patient_id,
    patient_id as patient_code,
    PR.created_at
FROM patient P
LEFT JOIN patient_report PR ON PR.patient_id_fk = P.patient_id
LEFT JOIN staff S ON PR.staff_id_fk = S.staff_id
LEFT JOIN lab_test LT ON LT.patient_id_fk = P.patient_id AND LT.is_deleted = 0
LEFT JOIN radiology_test RT ON RT.patient_id_fk = P.patient_id AND RT.is_deleted = 0
WHERE P.is_deleted = 0
*/

		$table  =  "(
			SELECT * FROM (
    SELECT 
        NULL AS patient_report_id,
        LT.lab_test_id AS lab_test_id,
        NULL AS rad_test_id,
        NULL AS report_reference_number,
        LT.test_number AS lab_test_number,
        NULL AS rad_test_number,
        P.patient_full_name,
        P.patient_phone,
        IFNULL(S.full_name,'') AS site_doctor,
        P.patient_id,
        P.patient_id AS patient_code,
        PR.created_at,
        'Lab Test' AS record_type
    FROM patient P
    LEFT JOIN patient_report PR ON PR.patient_id_fk = P.patient_id
    LEFT JOIN staff S ON PR.staff_id_fk = S.staff_id
    LEFT JOIN lab_test LT ON LT.patient_id_fk = P.patient_id AND LT.is_deleted = 0
    WHERE P.is_deleted = 0
	group by LT.lab_test_id

    UNION ALL

    -- Radiology test records
    SELECT 
        NULL AS patient_report_id,
        NULL AS lab_test_id,
        RT.radiology_test_id AS rad_test_id,
        NULL AS report_reference_number,
        NULL AS lab_test_number,
        RT.test_number AS rad_test_number,
        P.patient_full_name,
        P.patient_phone,
        IFNULL(S.full_name,'') AS site_doctor,
        P.patient_id,
        P.patient_id AS patient_code,
        PR.created_at,
        'Radiology Test' AS record_type
    FROM patient P
    LEFT JOIN patient_report PR ON PR.patient_id_fk = P.patient_id
    LEFT JOIN staff S ON PR.staff_id_fk = S.staff_id
    LEFT JOIN radiology_test RT ON RT.patient_id_fk = P.patient_id AND RT.is_deleted = 0
    WHERE P.is_deleted = 0
	group by RT.radiology_test_id

    UNION ALL

    -- Patient report records
    SELECT 
        PR.patient_report_id,
        NULL AS lab_test_id,
        NULL AS rad_test_id,
        PR.report_reference_number,
        NULL AS lab_test_number,
        NULL AS rad_test_number,
        P.patient_full_name,
        P.patient_phone,
        IFNULL(S.full_name,'') AS site_doctor,
        P.patient_id,
        P.patient_id AS patient_code,
        PR.created_at,
        'Patient Report' AS record_type
    FROM patient P
    LEFT JOIN patient_report PR ON PR.patient_id_fk = P.patient_id
    LEFT JOIN staff S ON PR.staff_id_fk = S.staff_id
    WHERE P.is_deleted = 0
	group by PR.patient_report_id
) AS combined
WHERE NOT (patient_report_id IS NULL AND lab_test_id IS NULL AND rad_test_id IS NULL)

			$cond
						) AS ALLTBL";


		$primaryKey = 'patient_report_id';
		$columns =  array(
			array('db' => 'patient_report_id', 'dt' => 0),
			array('db' => 'lab_test_id', 'dt' => 1),
			array('db' => 'rad_test_id', 'dt' => 2),
			array('db' => 'patient_full_name', 'dt' => 3),
			array('db' => 'patient_phone', 'dt' => 4),
			array('db' => 'patient_code',  'dt' => 5),
			array('db' => 'report_reference_number', 'dt' => 6),
			array('db' => 'lab_test_number', 'dt' => 7),
			array('db' => 'rad_test_number', 'dt' => 8),
			array('db' => 'site_doctor',  'dt' => 9),
			array('db' => 'created_at',  'dt' => 10),



		);

		$ords 		= '';
		$fltr 		= '';
		$limit 		= "";

		// SQL server connection information
		$sql_details = array(
			'user' => $mysql_user,
			'pass' => $mysql_password,
			'db'   => $mysql_db,
			'host' => $mysql_server
		);

		// echo SSP::complex($_GET, $sql_details, $table, $primaryKey, $columns, null, '');
		require('ssp.php');
		echo json_encode(
			// SSP::complex_optimized( $_GET, $sql_details, $table, $primaryKey, $columns ,$fltr, $ords, $limit )
			SSP::complex($_GET, $sql_details, $table, $primaryKey, $columns, null, '')

		);
		exit;
	}


	if ($_POST['type'] == "get") {

		$op  = array('is_success' => false, 'data' => array());

		$id = $_POST['id'];

		$res = $db->query("SELECT 	patient_report_id,
										report_reference_number,
										report_date,
										patient_full_name,
										gender,
										patient_date_of_birth,
										blood_group,
										allergies,
										occupation,
										company_name
								FROM patient P
								LEFT JOIN patient_report PR  ON (PR.patient_id_fk = P.patient_id AND PR.is_deleted = 0)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	

								WHERE P.is_deleted = 0 AND patient_id = $id");
		if ($res) {
			while ($row = $res->fetch_assoc()) {
				$result['patient_report_id'] 		= $row['patient_report_id'];
				$result['report_reference_number'] 	= $row['report_reference_number'];
				$result['report_date']				= $row['report_date'];
				$result['patient_full_name']		= $row['patient_full_name'];
				$result['gender']					= $row['gender'];
				$result['patient_date_of_birth']	= $row['patient_date_of_birth'];
				$result['blood_group']				= $row['blood_group'];
				$result['allergies']				= $row['allergies'];
				$result['occupation']				= $row['occupation'];
				$result['company_name']				= $row['company_name'];
				array_push($op['data'], $result);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] = 'Error Has Occure';
			echo json_encode($op);
			exit;
		}
	}


	if ($_POST['type'] == "get_edit") {

		$id = $_POST['edited_id'];
		$op  = array('is_success' => false, 'data' => array(), 'lab' => array(), 'radiology' => array(), 'treat' => array(), 'consultation' => array(), 'service' => array(), 'tour' => array(), 'invoice' => array());

		$res = $db->query("SELECT
										patient_report_id,
										report_reference_number,
									 	past_medical_history,
									 	past_surgical_history,
									 	present_complaint,
									 	family_history,
									 	social_history,
									 	assessment,
									 	chest,
									 	abdomen,
									 	heart,
									 	cns,
									 	bp,
									 	pr,
									 	rr,
									 	temp,
									 	spo2,
									 	gcs,
									 	provisional_diagnosis,
									 	follow_up,
									 	follow_note,
									 	sick_leave,
									 	sick_leave_from,
									 	sick_leave_to,
									 	sick_leave_note,
									 	referral_to,
									 	reason_of_referral,
									 	report_note,
									 	discharge_summary,
									 	medical_report,
									 	sequence_number,
									 	report_date,
									 	PR.patient_id_fk,
									 	PR.staff_id_fk,
									 	patient_full_name,
										gender,
										patient_date_of_birth,
										blood_group,
										allergies,
										occupation,
										company_name,
										is_refferal,
										patient_refferal_id,
										referred_to,
										refferal_date,
										clinc_site_name,
										chief_complaint,
										reason_for_refferal,
										IFNULL(full_name,'') as site_doctor,
										refferal_note,
										PR.created_by,
										P.insurance,
										P.company_id_fk

								FROM patient_report PR
								LEFT JOIN patient_report_detail PRD ON (PR.patient_report_id = PRD.patient_report_id_fk)	
								LEFT JOIN patient P ON (PR.patient_id_fk = P.patient_id)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	
								LEFT JOIN patient_refferal PRR ON (PR.patient_report_id = PRR.patient_report_id_fk)	
								LEFT JOIN staff S ON (PR.staff_id_fk = S.staff_id)	

								WHERE PR.is_deleted = 0 AND PR.patient_report_id = $id 

								");

		$res2 = $db->query("SELECT
										
										treatment_id,
										patient_report_id_fk,
										IFNULL(product_name,medicine_name) as medicine_name,
										treat_form_id_fk,
										dose,
										treat_route_id_fk,
										treat_frequency_id_fk,
										treat_note,
										form_name,
										frequency_name,
										route_name,
										product_id_fk,
										product_name,
										PT.created_at,
										IFNULL(full_name,'') as added_by,
										PT.created_by


								FROM patient_treatment PT
								LEFT JOIN product PD ON (PT.product_id_fk = PD.product_id)	
								LEFT JOIN treat_form TF ON (PT.treat_form_id_fk = TF.treat_form_id)	
								LEFT JOIN treat_frequency FR ON (PT.treat_frequency_id_fk = FR.treat_frequency_id)	
								LEFT JOIN treat_route TR ON (PT.treat_route_id_fk = TR.treat_route_id)	

								LEFT JOIN staff S ON (PT.created_by = S.staff_id)	

								WHERE PT.is_deleted = 0 AND PT.patient_report_id_fk = $id 

								");


		$res3 = $db->query("SELECT
										lab_test_id,
										lab_test_date,
										result_note,
										result_file,
										result_conclusion,
										lab_test_status,
										test_type,
										PI.patient_id_fk,
										PI.staff_id_fk,
										to_doctor,
										IFNULL(S.full_name,to_doctor) as site_doctor,
										IFNULL(S2.full_name,'') as lab_doctor,
										lab_test_detail_id,
										product_id_fk,
										product_name,
										test_note,
										test_number,
										cost,
										sell,
										test_result,
										test_status,
										patient_full_name,
		                    			patient_phone,
		                    			gender,
		                    			patient_date_of_birth,
		                    			blood_group,
		                    			allergies,
		                    			company_name,
		                    			occupation,
		                    			reference_value,
		                    			test_unit,
		                    			attach_file,
		                    			PI.patient_report_id_fk,
		                    			PID.created_at,
										IFNULL(S3.full_name,'') as added_by,
										PID.created_by

								FROM lab_test PI 
								
								LEFT JOIN patient P ON (PI.patient_id_fk = P.patient_id)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	
								LEFT JOIN lab_test_detail PID ON (PI.lab_test_id = PID.lab_test_id_fk)	
								LEFT JOIN product PD ON (PID.product_id_fk = PD.product_id)	
								
								LEFT JOIN staff S ON (PI.staff_id_fk = S.staff_id)	
								LEFT JOIN staff S2 ON (PI.created_by = S2.staff_id)	
								LEFT JOIN staff S3 ON (PID.created_by = S3.staff_id)	

								WHERE PI.is_deleted = 0 AND PID.is_deleted=0 AND PI.patient_report_id_fk = $id 

								");

		$res4 = $db->query("SELECT
										radiology_test_id,
										radiology_test_date,
										result_note,
										result_file,
										result_conclusion,
										radiology_test_status,
										test_type,
										PI.patient_id_fk,
										PI.staff_id_fk,
										to_doctor,
										IFNULL(S.full_name,to_doctor) as site_doctor,
										IFNULL(S2.full_name,'') as lab_doctor,
										radiology_test_detail_id,
										product_id_fk,
										product_name,
										test_note,
										test_number,
										cost,
										sell,
										test_result,
										test_status,
										patient_full_name,
		                    			patient_phone,
		                    			gender,
		                    			patient_date_of_birth,
		                    			blood_group,
		                    			allergies,
		                    			company_name,
		                    			occupation,
		                    			reference_value,
		                    			test_unit,
		                    			attach_file,
		                    			PI.patient_report_id_fk,
		                    			PID.created_at,
										IFNULL(S3.full_name,'') as added_by,
										PID.created_by

								FROM radiology_test PI 
								
								LEFT JOIN patient P ON (PI.patient_id_fk = P.patient_id)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	
								LEFT JOIN radiology_test_detail PID ON (PI.radiology_test_id = PID.radiology_test_id_fk)	
								LEFT JOIN product PD ON (PID.product_id_fk = PD.product_id)	
								
								LEFT JOIN staff S ON (PI.staff_id_fk = S.staff_id)	
								LEFT JOIN staff S2 ON (PI.created_by = S2.staff_id)	
								LEFT JOIN staff S3 ON (PID.created_by = S3.staff_id)	

								WHERE PI.is_deleted = 0 AND PID.is_deleted=0 AND PI.patient_report_id_fk = $id 

								");

		$res5 = $db->query("SELECT
										
										sell_detail_id,
										product_id_fk,
										sell_quantity,
										SD.sell_price,
										cost_price,
										discount,
										sell_detail_date,
										SD.product_unit_id_fk,
										unit_scale,
										sell_detail_note,
										origin_from,
										origin_from_id_fk,
										consultant_name,
										stock_id_fk,
										SD.product_type_id_fk,
										sell_id_fk,
										patient_report_id_fk,
										patient_id_fk,
										product_name,
										SD.created_at,
										IFNULL(S.full_name,'') as added_by,
										SD.created_by

								FROM sell_detail SD
								LEFT JOIN product PD ON (SD.product_id_fk = PD.product_id)	
								LEFT JOIN staff S ON (SD.created_by = S.staff_id)	

								WHERE SD.is_deleted = 0 AND origin_from='consultation' AND SD.patient_report_id_fk = $id 

								");

		$res6 = $db->query("SELECT
										
										sell_detail_id,
										product_id_fk,
										sell_quantity,
										SD.sell_price,
										cost_price,
										discount,
										sell_detail_date,
										SD.product_unit_id_fk,
										unit_scale,
										sell_detail_note,
										origin_from,
										origin_from_id_fk,
										consultant_name,
										stock_id_fk,
										SD.product_type_id_fk,
										sell_id_fk,
										patient_report_id_fk,
										patient_id_fk,
										product_name,
										SD.created_at,
										IFNULL(S.full_name,'') as added_by,
										SD.created_by

								FROM sell_detail SD
								LEFT JOIN product PD ON (SD.product_id_fk = PD.product_id)	
								LEFT JOIN staff S ON (SD.created_by = S.staff_id)	

								WHERE SD.is_deleted = 0 AND origin_from='procedure' AND SD.patient_report_id_fk = $id 

								");

		$res7 = $db->query("SELECT
										
										note_id,
										report_note_tour,
										noter_name,
										note_date,
										note_type,
										patient_report_id_fk,
										patient_id_fk,
										staff_id_fk,
										note_file,
										PRN.created_at,
										IFNULL(S.full_name,'') as added_by,
										PRN.created_by

								FROM patient_report_note PRN
								LEFT JOIN staff S ON (PRN.created_by = S.staff_id)	

								WHERE PRN.is_deleted = 0 AND PRN.patient_report_id_fk = $id 

								");

		$res8 = $db->query("SELECT
										
		                    			sell_detail_id,
		                    			sell_id_fk,
		                    			origin_from,
		                    			product_id_fk

									FROM sell_detail SD 	

								
									WHERE SD.is_deleted = 0  AND SD.patient_report_id_fk = $id 

								");

		if ($res) {


			while ($row = $res->fetch_assoc()) {

				$result['patient_report_id']  		= $row['patient_report_id'];
				$result['report_reference_number'] 	= $row['report_reference_number'];
				$result['present_complaint'] 		= $row['present_complaint'];
				$result['past_medical_history'] 	= $row['past_medical_history'];
				$result['past_surgical_history'] 	= $row['past_surgical_history'];
				$result['family_history']  			= $row['family_history'];
				$result['social_history']  			= $row['social_history'];
				$result['assessment']  				= $row['assessment'];
				$result['chest']  					= $row['chest'];
				$result['abdomen'] 					= $row['abdomen'];
				$result['heart'] 					= $row['heart'];
				$result['cns']  					= $row['cns'];
				$result['bp'] 						= $row['bp'];
				$result['pr']  						= $row['pr'];
				$result['rr']  						= $row['rr'];
				$result['temp']  					= $row['temp'];
				$result['spo2']  					= $row['spo2'];
				$result['gcs']  					= $row['gcs'];
				$result['provisional_diagnosis']  	= $row['provisional_diagnosis'];
				$result['follow_up']  				= $row['follow_up'];
				$result['follow_note']  			= $row['follow_note'];
				$result['sick_leave']  				= $row['sick_leave'];
				$result['sick_leave_from']  		= $row['sick_leave_from'];
				$result['sick_leave_to']  			= $row['sick_leave_to'];
				$result['sick_leave_note']  		= $row['sick_leave_note'];
				$result['referral_to']  			= $row['referral_to'];
				$result['reason_of_referral']  		= $row['reason_of_referral'];
				$result['report_note']  			= $row['report_note'];
				$result['discharge_summary']  		= $row['discharge_summary'];
				$result['medical_report']  			= $row['medical_report'];
				$result['report_date']  			= $row['report_date'];
				$result['patient_id_fk']  			= $row['patient_id_fk'];
				$result['patient_full_name']  		= $row['patient_full_name'];
				$result['gender']  					= $row['gender'];
				$result['patient_date_of_birth']  	= $row['patient_date_of_birth'];
				$result['blood_group']  			= $row['blood_group'];
				$result['allergies']  				= $row['allergies'];
				$result['occupation']  				= $row['occupation'];
				$result['company_name']  			= $row['company_name'];
				$result['is_refferal']  			= $row['is_refferal'];
				$result['patient_refferal_id']  	= $row['patient_refferal_id'];
				$result['referred_to']  			= $row['referred_to'];
				$result['refferal_date']  			= $row['refferal_date'];
				$result['clinc_site_name']  		= $row['clinc_site_name'];
				$result['chief_complaint']  		= $row['chief_complaint'];
				$result['reason_for_refferal']  	= $row['reason_for_refferal'];
				$result['refferal_note']  			= $row['refferal_note'];
				$result['site_doctor']  			= $row['site_doctor'];
				$result['created_by']  				= $row['created_by'];
				$result['insurance']  				= $row['insurance'];
				$result['company_id_fk']  			= $row['company_id_fk'];

				array_push($op['data'], $result);
			}
			while ($row = $res2->fetch_assoc()) {


				$result2['treatment_id']  			= $row['treatment_id'];
				$result2['medicine_name']  			= $row['medicine_name'];
				$result2['product_id_fk']  			= $row['product_id_fk'];
				$result2['product_name']  			= $row['product_name'];
				$result2['treat_form_id_fk']  		= $row['treat_form_id_fk'];
				$result2['dose']  					= $row['dose'];
				$result2['treat_route_id_fk']  		= $row['treat_route_id_fk'];
				$result2['treat_frequency_id_fk']  	= $row['treat_frequency_id_fk'];
				$result2['treat_note']  			= $row['treat_note'];
				$result2['form_name']  				= $row['form_name'];
				$result2['frequency_name']  		= $row['frequency_name'];
				$result2['route_name']  			= $row['route_name'];
				$result2['patient_report_id_fk'] 	= $row['patient_report_id_fk'];
				$result2['created_at'] 				= $row['created_at'];
				$result2['added_by'] 				= $row['added_by'];
				$result2['created_by'] 				= $row['created_by'];

				array_push($op['treat'], $result2);
			}
			while ($row = $res3->fetch_assoc()) {


				$result3['lab_test_id'] = $row['lab_test_id'];
				$result3['lab_test_date']  	= $row['lab_test_date'];
				$result3['result_note']  			= $row['result_note'];
				$result3['result_file']  			= $row['result_file'];
				$result3['result_conclusion']  		= $row['result_conclusion'];
				$result3['lab_test_status']  	= $row['lab_test_status'];
				$result3['test_type']  	= $row['test_type'];
				$result3['patient_id_fk']			= $row['patient_id_fk'];
				$result3['staff_id_fk']				= $row['staff_id_fk'];
				$result3['to_doctor']				= $row['to_doctor'];
				$result3['patient_full_name']		= $row['patient_full_name'];
				$result3['patient_phone']			= $row['patient_phone'];
				$result3['lab_test_detail_id'] = $row['lab_test_detail_id'];
				$result3['product_id_fk']  			= $row['product_id_fk'];
				$result3['product_name']  			= $row['product_name'];
				$result3['test_unit']  				= $row['test_unit'];
				$result3['reference_value']  		= $row['reference_value'];
				$result3['test_note']  	= $row['test_note'];
				$result3['cost']  					= $row['cost'];
				$result3['sell']  					= $row['sell'];
				$result3['test_result']  			= $row['test_result'];
				$result3['test_status']  			= $row['test_status'];
				$result3['patient_report_id_fk']  	= $row['patient_report_id_fk'];
				$result3['site_doctor']  			= $row['site_doctor'];
				$result3['test_number']  	= $row['test_number'];
				$result3['lab_doctor']  			= $row['lab_doctor'];
				$result3['gender']  				= $row['gender'];
				$result3['patient_date_of_birth']  	= $row['patient_date_of_birth'];
				$result3['blood_group']  			= $row['blood_group'];
				$result3['allergies']  				= $row['allergies'];
				$result3['company_name']  			= $row['company_name'];
				$result3['occupation']  			= $row['occupation'];
				$result3['attach_file']  			= $row['attach_file'];
				$result3['created_at'] 				= $row['created_at'];
				$result3['added_by'] 				= $row['added_by'];
				$result3['created_by'] 				= $row['created_by'];

				array_push($op['lab'], $result3);
			}

			while ($row = $res4->fetch_assoc()) {


				$result4['radiology_test_id'] = $row['radiology_test_id'];
				$result4['radiology_test_date']  	= $row['radiology_test_date'];
				$result4['result_note']  			= $row['result_note'];
				$result4['result_file']  			= $row['result_file'];
				$result4['result_conclusion']  		= $row['result_conclusion'];
				$result4['radiology_test_status']  	= $row['radiology_test_status'];
				$result4['test_type']  	= $row['test_type'];
				$result4['patient_id_fk']			= $row['patient_id_fk'];
				$result4['staff_id_fk']				= $row['staff_id_fk'];
				$result4['to_doctor']				= $row['to_doctor'];
				$result4['patient_full_name']		= $row['patient_full_name'];
				$result4['patient_phone']			= $row['patient_phone'];
				$result4['radiology_test_detail_id'] = $row['radiology_test_detail_id'];
				$result4['product_id_fk']  			= $row['product_id_fk'];
				$result4['product_name']  			= $row['product_name'];
				$result4['test_unit']  				= $row['test_unit'];
				$result4['reference_value']  		= $row['reference_value'];
				$result4['test_note']  	= $row['test_note'];
				$result4['cost']  					= $row['cost'];
				$result4['sell']  					= $row['sell'];
				$result4['test_result']  			= $row['test_result'];
				$result4['test_status']  			= $row['test_status'];
				$result4['patient_report_id_fk']  	= $row['patient_report_id_fk'];
				$result4['site_doctor']  			= $row['site_doctor'];
				$result4['test_number']  	= $row['test_number'];
				$result4['lab_doctor']  			= $row['lab_doctor'];
				$result4['gender']  				= $row['gender'];
				$result4['patient_date_of_birth']  	= $row['patient_date_of_birth'];
				$result4['blood_group']  			= $row['blood_group'];
				$result4['allergies']  				= $row['allergies'];
				$result4['company_name']  			= $row['company_name'];
				$result4['occupation']  			= $row['occupation'];
				$result4['attach_file']  			= $row['attach_file'];
				$result4['created_at'] 				= $row['created_at'];
				$result4['added_by'] 				= $row['added_by'];
				$result4['created_by'] 				= $row['created_by'];

				array_push($op['radiology'], $result4);
			}

			while ($row = $res5->fetch_assoc()) {


				$result5['sell_detail_id']		= $row['sell_detail_id'];
				$result5['product_id_fk']  		= $row['product_id_fk'];
				$result5['sell_quantity']  		= $row['sell_quantity'];
				$result5['sell_price']  		= $row['sell_price'];
				$result5['cost_price']  		= $row['cost_price'];
				$result5['discount']  			= $row['discount'];
				$result5['sell_detail_date']	= $row['sell_detail_date'];
				$result5['product_unit_id_fk']	= $row['product_unit_id_fk'];
				$result5['unit_scale']			= $row['unit_scale'];
				$result5['sell_detail_note']	= $row['sell_detail_note'];
				$result5['origin_from']			= $row['origin_from'];
				$result5['origin_from_id_fk'] 	= $row['origin_from_id_fk'];
				$result5['consultant_name']  	= $row['consultant_name'];
				$result5['product_name']  		= $row['product_name'];
				$result5['stock_id_fk']  		= $row['stock_id_fk'];
				$result5['product_type_id_fk']  = $row['product_type_id_fk'];
				$result5['sell_id_fk']  		= $row['sell_id_fk'];
				$result5['patient_report_id_fk'] = $row['patient_report_id_fk'];
				$result5['patient_id_fk']  		= $row['patient_id_fk'];
				$result5['created_at'] 				= $row['created_at'];
				$result5['added_by'] 				= $row['added_by'];
				$result5['created_by'] 				= $row['created_by'];

				array_push($op['consultation'], $result5);
			}

			while ($row = $res6->fetch_assoc()) {


				$result6['sell_detail_id']		= $row['sell_detail_id'];
				$result6['product_id_fk']  		= $row['product_id_fk'];
				$result6['sell_quantity']  		= $row['sell_quantity'];
				$result6['sell_price']  		= $row['sell_price'];
				$result6['cost_price']  		= $row['cost_price'];
				$result6['discount']  			= $row['discount'];
				$result6['sell_detail_date']	= $row['sell_detail_date'];
				$result6['product_unit_id_fk']	= $row['product_unit_id_fk'];
				$result6['unit_scale']			= $row['unit_scale'];
				$result6['sell_detail_note']	= $row['sell_detail_note'];
				$result6['origin_from']			= $row['origin_from'];
				$result6['origin_from_id_fk'] 	= $row['origin_from_id_fk'];
				$result6['consultant_name']  	= $row['consultant_name'];
				$result6['product_name']  		= $row['product_name'];
				$result6['stock_id_fk']  		= $row['stock_id_fk'];
				$result6['product_type_id_fk']  = $row['product_type_id_fk'];
				$result6['sell_id_fk']  		= $row['sell_id_fk'];
				$result6['patient_report_id_fk'] = $row['patient_report_id_fk'];
				$result6['patient_id_fk']  		= $row['patient_id_fk'];
				$result6['created_at'] 			= $row['created_at'];
				$result6['added_by'] 			= $row['added_by'];
				$result6['created_by'] 			= $row['created_by'];

				array_push($op['service'], $result6);
			}

			while ($row = $res7->fetch_assoc()) {


				$result7['note_id']					= $row['note_id'];
				$result7['report_note_tour']  		= $row['report_note_tour'];
				$result7['noter_name']  			= $row['noter_name'];
				$result7['note_date']  				= $row['note_date'];
				$result7['note_type']  				= $row['note_type'];
				$result7['patient_report_id_fk']  	= $row['patient_report_id_fk'];
				$result7['patient_id_fk']			= $row['patient_id_fk'];
				$result7['staff_id_fk']				= $row['staff_id_fk'];
				$result7['created_at'] 				= $row['created_at'];
				$result7['added_by'] 				= $row['added_by'];
				$result7['created_by'] 				= $row['created_by'];
				$result7['note_file'] 				= $row['note_file'];

				array_push($op['tour'], $result7);
			}

			while ($row = $res8->fetch_assoc()) {


				$result8['sell_detail_id']			= $row['sell_detail_id'];
				$result8['sell_id_fk']  			= $row['sell_id_fk'];
				$result8['origin_from']  			= $row['origin_from'];
				$result8['product_id_fk']  			= $row['product_id_fk'];
				$result8['is_found']  				= 0;

				array_push($op['invoice'], $result8);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			echo json_encode($op);

			exit;
		}
	}

	if ($_POST['type'] == "autocomplete") {

		$key = $_POST['q'];

		$res = $db->query("SELECT 	DISTINCT
									
									IFNULL(product_name,medicine_name) as medicine_name

								FROM patient_treatment AN
								LEFT JOIN product P ON (P.is_deleted=0)
								WHERE AN.is_deleted = 0 AND (medicine_name LIKE '%$key%' OR product_name LIKE '%$key%')
								LIMIT 5");
		if ($res) {
			$op  = array();
			while ($row = $res->fetch_assoc()) {

				$result['medicine_name'] 			= $row['medicine_name'];
				array_push($op, $result);
			}
			echo json_encode($op);
			exit;
		} else {
			echo 0;
			exit;
		}
	}




	if ($_POST['type'] == "update") {

		$id 				 	= $_POST['edited_id'];
		$patient_id_fk 	 		= $_POST["edit_patient_id_fk"];
		$report_date			= $_POST["edit_report_date"];
		$past_medical_history	= addslashes($_POST["edit_past_medical_history"]);
		$past_surgical_history	= addslashes($_POST["edit_past_surgical_history"]);
		$present_complaint		= addslashes($_POST["edit_present_complaint"]);
		$family_history		 	= addslashes($_POST["edit_family_history"]);
		$social_history		 	= addslashes($_POST["edit_social_history"]);
		$assessment		 		= addslashes($_POST["edit_assessment"]);
		$chest					= addslashes($_POST["edit_chest"]);
		$bp						= addslashes($_POST["edit_bp"]);
		$abdomen		 		= addslashes($_POST["edit_abdomen"]);
		$pr						= addslashes($_POST["edit_pr"]);
		$heart 					= addslashes($_POST["edit_heart"]);
		$rr 					= addslashes($_POST["edit_rr"]);
		$cns 					= addslashes($_POST["edit_cns"]);
		$temp 					= addslashes($_POST["edit_temp"]);
		$spo2 					= addslashes($_POST["edit_spo2"]);
		$gcs 					= addslashes($_POST["edit_gcs"]);
		// $investigation 			= $_POST["edit_investigation"];
		$provisional_diagnosis 	= addslashes($_POST["edit_provisional_diagnosis"]);
		// $treatment 				= $_POST["edit_treatment"];
		$follow_up 				= addslashes($_POST["edit_follow_up"]);
		$follow_note 			= addslashes($_POST["edit_follow_note"]);
		$sick_leave 			= addslashes($_POST["edit_sick_leave"]);
		$sick_leave_from 		= addslashes($_POST["edit_sick_leave_from"]);
		$sick_leave_to 			= addslashes($_POST["edit_sick_leave_to"]);
		$sick_leave_note 		= addslashes($_POST["edit_sick_leave_note"]);

		$referral_to 			= addslashes($_POST["edit_referral_to"]);
		$reason_of_referral 	= addslashes($_POST["edit_reason_of_referral"]);
		$report_note 			= addslashes($_POST["edit_report_note"]);
		$discharge_summary 		= addslashes($_POST["edit_discharge_summary"]);
		$medical_report 		= addslashes($_POST["edit_medical_report"]);
		$is_refferal 			= addslashes($_POST["edit_is_refferal"]);
		$patient_refferal_id 	= addslashes($_POST["patient_refferal_id"]);

		$referred_to 			= addslashes($_POST["edit_referred_to"]);
		$clinc_site_name 		= addslashes($_POST["edit_clinc_site_name"]);
		$chief_complaint 		= addslashes($_POST["edit_chief_complaint"]);
		$reason_for_refferal 	= addslashes($_POST["edit_reason_for_refferal"]);
		$refferal_note 			= addslashes($_POST["edit_refferal_note"]);


		$op  = array('is_success' => false, 'data' => '');



		$reg_date 		= date("Y-m-d H:i:s", time());
		$invoice_year 	= date("Y", time());

		$res = $db->query("SELECT * FROM patient_report WHERE patient_report_id=$id");

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$lastaction = "Update patient_report information";
		$by 		= $_SESSION['user_id'];

		$update_qry = "UPDATE patient_report SET 
								present_complaint		='$present_complaint',
								past_medical_history	='$past_medical_history',
								past_surgical_history	='$past_surgical_history',
								family_history			='$family_history',
								social_history			='$social_history',
								provisional_diagnosis	='$provisional_diagnosis',
								referral_to				='$referral_to',
								reason_of_referral		='$reason_of_referral',
								report_note				='$report_note',
								discharge_summary		='$discharge_summary',
								report_date				='$report_date',
								patient_id_fk			='$patient_id_fk',
								is_refferal				='$is_refferal',
								
								last_action 			='$lastaction',
								updated_at				='$reg_date',
								last_action_by			='$by' 
							WHERE patient_report_id 	= $id";


		$res = $db->query($update_qry);
		if ($res) {

			$update_qry = "UPDATE patient_report_detail SET 
								assessment				='$assessment',
								chest					='$chest',
								abdomen					='$abdomen',
								heart					='$heart',
								cns						='$cns',
								bp						='$bp',
								pr						='$pr',
								rr						='$rr',
								temp					='$temp',
								spo2					='$spo2',
								gcs						='$gcs',
								follow_up				='$follow_up',
								follow_note				='$follow_note',
								sick_leave				='$sick_leave',
								sick_leave_from			='$sick_leave_from',
								sick_leave_to			='$sick_leave_to',
								sick_leave_note			='$sick_leave_note',
								medical_report			='$medical_report',
								patient_id_fk			='$patient_id_fk',
								
								last_action 			='$lastaction',
								updated_at				='$reg_date',
								last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id";


			$res = $db->query($update_qry);


			$index_num 	=	0;

			$update_qry = "UPDATE lab_test SET 
											is_deleted				=1,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id";


			$res = $db->query($update_qry);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}

			$update_qry = "UPDATE lab_test_detail SET 
											is_deleted				=1,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id";


			$res = $db->query($update_qry);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}


			$update_qry = "UPDATE sell SET 
											is_deleted				=1,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id AND patient_report_id_fk>0";


			$res = $db->query($update_qry);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}


			$update_qry = "UPDATE sell_detail SET 
											is_deleted				=1,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id AND patient_report_id_fk>0";


			$res = $db->query($update_qry);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}

			$update_qry = "UPDATE product_stock SET 
											is_deleted				=1,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id AND patient_report_id_fk>0";


			$res = $db->query($update_qry);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}


			$update_qry = "UPDATE patient_report_note SET 
											is_deleted				=1,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id AND patient_report_id_fk>0";


			$res = $db->query($update_qry);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}

			$prev_type 				= '';
			$invoice_total_price 	= 0;
			$inv_id 				= 0;

			if (isset($_POST["edit_product_id_fk"])) {

				$lab_test_id 		= $_POST["edit_lab_test_id"][0];

				foreach ($_POST["edit_product_id_fk"] as $product_id_fk) {

					$lab_test_detail_id	= $_POST["edit_lab_test_detail_id"][$index_num];
					$test_type 			= $_POST["edit_test_type"][$index_num];
					$test_note 			= addslashes($_POST["edit_test_note"][$index_num]);
					$cost 				= $_POST["edit_cost"][$index_num];
					$sell 				= $_POST["edit_sell"][$index_num];
					$sell_id 			= $_POST["edit_lab_sell_id"][$index_num];
					$sell_detail_id 	= $_POST["edit_lab_sell_detail_id"][$index_num];


					$index_num++;

					if ($product_id_fk == '') {
						$product_id_fk = 0;
					}
					if ($lab_test_id == '') {
						$lab_test_id = 0;
					}

					if ($lab_test_detail_id == '') {
						$lab_test_detail_id = 0;
					}

					if ($cost == '') {
						$cost = 0;
					}
					if ($sell == '') {
						$sell = 0;
					}



					if ($product_id_fk > 0) {

						$update_qry = "UPDATE lab_test SET 
											is_deleted				=0,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id AND lab_test_id= $lab_test_id";



						$res = $db->query($update_qry);

						if (!$res) {
							loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
							$op['is_success'] = false;
							$op['data'] 	  = $db->error;
							$db->rollback();
							echo json_encode($op);
							exit;
						}




						// for Invoice
						if ($prev_type != $test_type) {
							$res = $db->query("SELECT * FROM sell WHERE patient_report_id_fk=$id AND patient_report_id_fk>0 LIMIT 1");

							if (mysqli_num_rows($res) > 0) {
								$row = $res->fetch_assoc();
								$inv_id 				= $row['sell_id'];
								$invoice_total_discount = $row['invoice_total_discount'];

								$v = 0;
								foreach ($_POST["edit_product_id_fk"] as $p) {
									$invoice_total_price = $invoice_total_price + $_POST["edit_sell"][$v];
									$v++;
								}


								$update_qry = "UPDATE sell SET 
											is_deleted				=0,
											invoice_total_price 	='$invoice_total_price',
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
									WHERE patient_report_id_fk 	= $id AND sell_id= $inv_id";


								$res = $db->query($update_qry);

								if (!$res) {
									loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
									$op['is_success'] = false;
									$op['data'] 	  = $db->error;
									$db->rollback();
									echo json_encode($op);
									exit;
								}
							} else {
								$v = 0;
								foreach ($_POST["edit_product_id_fk"] as $p) {
									$invoice_total_price = $invoice_total_price + $_POST["edit_sell"][$v];
									$v++;
								}

								$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='sell' ");

								if (mysqli_num_rows($res) > 0) {
									$row 				= $res->fetch_assoc();
									$sequence_number 	= $row['sequence_number'] + 1;
									$prefix 			= $row['prefix'];
									$bill_id 			= $row['bill_id'];

									$res = $db->query("UPDATE bill_setting SET

															sequence_number ='$sequence_number',
															last_action 	='$lastaction',
															updated_at		='$reg_date',
															last_action_by	='$by'

															WHERE bill_id=$bill_id  ");
								} else {
									$sequence_number 	= 1;
									$prefix 			= '';
								}

								$invoice_number = $prefix . $sequence_number;

								$sql = "INSERT INTO sell (	
																 	invoice_number,
																 	invoice_year,
																 	invoice_date,
																 	invoice_type,
																 	pay_status,
																 	invoice_total_price,
																 	invoice_total_discount,
																 	sell_note,
																 	person_name,
																 	patient_id_fk,
																 	patient_report_id_fk,
																 	staff_id_fk,
																 	sequence_number,
														 			origin_table_name,
																 	
																	created_by,
																	created_at,
																    updated_at,
																	last_action,
																	last_action_by)
															VALUES( 
																	'$invoice_number',
																	'$invoice_year',
																	'$report_date',
																	'invoice',
																	'0',
																	'$invoice_total_price',
																	'0',
																	'Added From Patient Report',
																	'',
																	'$patient_id_fk',
																	'$id',
																	'$by',
																	'$sequence_number',
																	'patient_report',
																	
																	'$by',
																	'$reg_date',
																	'$reg_date',
																	'$lastaction',
																	'$by')";
								$res = $db->query($sql);

								if ($res) {
									$inv_id 		= 	$db->insert_id;
								} else {

									loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
									$db->rollback();
									$op['is_success'] = false;
									$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
									echo json_encode($op);
									exit;
								}
							}
						}

						$cost_price 			= $cost;
						$product_unit_id_fk 	= 0;
						$unit_scale 			= 0;
						$product_type_id_fk 	= 0;
						$sell_quantity 			= 1;
						$sell_price 			= $sell;
						$discount 				= 0;
						$sell_detail_note 		= $test_note;
						$stock_id_fk 			= $_SESSION["default_stock_id_fk"];


						if ($product_id_fk > 0) {

							if ($sell_detail_id > 0 && $sell_id > 0) {

								$sql = "UPDATE sell_detail SET 
													product_id_fk			='$product_id_fk',
													sell_quantity			='$sell_quantity',
													sell_price				='$sell_price',
													cost_price				='$cost_price',
													sell_detail_date		='$report_date',
													product_unit_id_fk		='$product_unit_id_fk',
													sell_detail_note		='$sell_detail_note',
													origin_from				='lab_test',
													stock_id_fk				='$stock_id_fk',
													sell_id_fk				='$inv_id',
													patient_id_fk			='$patient_id_fk',
													patient_report_id_fk	='$id',
													is_deleted				=0,
													
													last_action 			='$lastaction',
													updated_at				='$reg_date',
													last_action_by			='$by' 
												WHERE sell_detail_id 	= $sell_detail_id";

								$res = $db->query($sql);
								$id_sub 		= 	$sell_detail_id;
							} else {

								$sql = "INSERT INTO 
				    						sell_detail 
				    						(	
											 	product_id_fk,
											 	sell_quantity,
											 	sell_price,
											 	cost_price,
											 	discount,
											 	sell_detail_date,
											 	product_unit_id_fk,
											 	unit_scale,
											 	sell_detail_note,
											 	origin_from,
											 	stock_id_fk,
											 	product_type_id_fk,
											 	sell_id_fk,
											 	patient_report_id_fk,
											 	patient_id_fk,
											 	
												created_by,
												created_at,
											    updated_at,
												last_action,
												last_action_by
											)
										VALUES
											( 
												'$product_id_fk',
												'$sell_quantity',
												'$sell_price',
												'$cost_price',
												'$discount',
												'$report_date',
												'$product_unit_id_fk',
												'$unit_scale',
												'$sell_detail_note',
												'lab_test',
												'$stock_id_fk',
												'$product_type_id_fk',
												'$inv_id',
												'$id',
												'$patient_id_fk',
												
												'$by',
												'$reg_date',
												'$reg_date',
												'$lastaction',
												'$by'
											)";

								$res = $db->query($sql);
								$id_sub 		= 	$db->insert_id;
							}

							if ($res) {



								loglog('Add', "sell", $id, "Added Successfully(sell-detail:$id_sub:$product_id_fk)", 'patient_report.php');

								$stock_transaction 	= 'Sell';

								$primary_table = 'sell';
								$detail_table  = 'sell_detail';
								$secondary_table  = 'lab_test';


								$sql = "INSERT INTO product_stock (	
														 	recieved_quantity,
														 	stock_transaction,
														 	stock_transaction_type,
														 	transaction_date,
														 	sell_price,
														 	buy_price,
														 	primary_id_fk,
														 	primary_table,
														 	secondary_table,
														 	detail_id_fk,
														 	detail_table,
														 	product_id_fk,
														 	stock_id_fk,
														 	patient_report_id_fk,
														 	patient_id_fk,
										 	
										 	
															created_by,
															created_at,
														    updated_at,
															last_action,
															last_action_by)
													VALUES( 
															'$sell_quantity',
															'$stock_transaction',
															'2',
															'$report_date',
															'$sell_price',
															'$cost_price',
															'$inv_id',
															'$primary_table',
															'$secondary_table',
															'$id_sub',
															'$detail_table',
															'$product_id_fk',
															'$stock_id_fk',
															'$id',
															'$patient_id_fk',
															
															
															'$by',
															'$reg_date',
															'$reg_date',
															'$lastaction',
															'$by')";

								$res = $db->query($sql);



								if (!$res) {
									loglog('Fail Add', "product_stock", $inv_id, "$db->error", 'patient_report.php');

									$db->rollback();
									$op['is_success'] = false;
									$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
									echo json_encode($op);
									exit;
								}
							} else {
								loglog('Fail Add', "sell", $inv_id, "$db->error", 'patient_report.php');
								$db->rollback();
								$op['is_success'] = false;
								$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
								echo json_encode($op);
								exit;
							}
						}
						// End invoice



						if ($lab_test_detail_id > 0) {
							$update_qry = "UPDATE lab_test_detail SET 
												product_id_fk			='$product_id_fk',
												test_note				='$test_note',
												cost					='$cost',
												sell					='$sell',
												patient_id_fk			='$patient_id_fk',
												is_deleted				=0,
												
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
								WHERE lab_test_detail_id 	= $lab_test_detail_id";


							$res = $db->query($update_qry);
							if (!$res) {
								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}
						} else {

							if ($lab_test_id == 0) {


								if ($prev_type != $test_type) {


									$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='$test_type' ");

									if (mysqli_num_rows($res) > 0) {
										$row = $res->fetch_assoc();
										$sequence_number 	= $row['sequence_number'] + 1;
										$prefix 			= $row['prefix'];
										$bill_id 			= $row['bill_id'];

										$res = $db->query("UPDATE bill_setting SET

																sequence_number 	='$sequence_number',
																last_action 		='$lastaction',
																updated_at			='$reg_date',
																last_action_by		='$by'

															WHERE bill_id=$bill_id  ");
									} else {
										$sequence_number 	= 1;
										$prefix 			= '';
									}

									$test_number = $prefix . $sequence_number;

									$sql = "INSERT INTO lab_test (	
																	 	lab_test_date,
																	 	test_type,
																	 	patient_report_id_fk,
																	 	patient_id_fk,
																	 	staff_id_fk,
																	 	sequence_number,
																	 	test_number,
																	 	
																		created_by,
																		created_at,
																	    updated_at,
																		last_action,
																		last_action_by)
																VALUES( 
																		'$report_date',
																		'$test_type',
																		'$id',
																		'$patient_id_fk',
																		'$by',
																		'$sequence_number',
																		'$test_number',
																		
																		'$by',
																		'$reg_date',
																		'$reg_date',
																		'$lastaction',
																		'$by')";
									$res = $db->query($sql);

									if ($res) {

										$lab_test_id 		= 	$db->insert_id;
									} else {

										loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
										$db->rollback();
										$op['is_success'] = false;
										$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
										echo json_encode($op);
										exit;
									}
								}
							}

							$sql = "INSERT INTO 
				    						lab_test_detail 
				    						(	
											 	product_id_fk,
											 	test_note,
											 	cost,
											 	sell,
											 	patient_report_id_fk,
											 	patient_id_fk,
											 	lab_test_id_fk,
											 	
												created_by,
												created_at,
											    updated_at,
												last_action,
												last_action_by
											)
										VALUES
											( 
												'$product_id_fk',
												'$test_note',
												'$cost',
												'$sell',
												'$id',
												'$patient_id_fk',
												'$lab_test_id',
												
												'$by',
												'$reg_date',
												'$reg_date',
												'$lastaction',
												'$by'
											)";

							$res = $db->query($sql);

							$in_id 		= 	$db->insert_id;


							loglog('Add', "patient_report", $id, "Added Successfully(test_type:$test_type:$in_id:$product_id_fk)", 'patient_report.php');

							if (!$res) {

								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$db->rollback();
								$op['is_success'] = false;
								$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
								echo json_encode($op);
								exit;
							}
						}
					}

					$prev_type = $test_type;
				}

				$error = ImageUploader('edit_lab_result_file', 'lab-file', 'lab_test', 'result_file', $lab_test_id, 'lab_test_id', '');
			}



			// For Radiology
			$index_num 	=	0;


			$update_qry = "UPDATE radiology_test SET 
											is_deleted				=1,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id";


			$res = $db->query($update_qry);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}

			$update_qry = "UPDATE radiology_test_detail SET 
											is_deleted				=1,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id";


			$res = $db->query($update_qry);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}

			$prev_type = '';

			if (isset($_POST["edit_rad_product_id_fk"])) {

				$radiology_test_id 		 	= $_POST["edit_radiology_test_id"][0];


				foreach ($_POST["edit_rad_product_id_fk"] as $product_id_fk) {

					$radiology_test_detail_id	= $_POST["edit_radiology_test_detail_id"][$index_num];
					$test_type 					= $_POST["edit_rad_test_type"][$index_num];
					$test_note 					= addslashes($_POST["edit_rad_test_note"][$index_num]);
					$cost 						= $_POST["edit_rad_cost"][$index_num];
					$sell 						= $_POST["edit_rad_sell"][$index_num];
					$sell_id 					= $_POST["edit_rad_sell_id"][$index_num];
					$sell_detail_id 			= $_POST["edit_rad_sell_detail_id"][$index_num];


					$index_num++;

					if ($product_id_fk > 0) {

						$update_qry = "UPDATE radiology_test SET 
											is_deleted				=0,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id AND radiology_test_id= $radiology_test_id";


						$res = $db->query($update_qry);

						if (!$res) {
							loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
							$op['is_success'] = false;
							$op['data'] 	  = $db->error;
							$db->rollback();
							echo json_encode($op);
							exit;
						}

						if ($radiology_test_detail_id > 0) {
							$update_qry = "UPDATE radiology_test_detail SET 
												product_id_fk			='$product_id_fk',
												test_note				='$test_note',
												cost					='$cost',
												sell					='$sell',
												patient_id_fk			='$patient_id_fk',
												is_deleted				=0,
												
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
								WHERE radiology_test_detail_id 	= $radiology_test_detail_id";


							$res = $db->query($update_qry);
							if (!$res) {
								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}
						} else {

							if ($radiology_test_id == 0) {

								if ($prev_type != $test_type) {


									$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='$test_type' ");

									if (mysqli_num_rows($res) > 0) {
										$row = $res->fetch_assoc();
										$sequence_number 	= $row['sequence_number'] + 1;
										$prefix 			= $row['prefix'];
										$bill_id 			= $row['bill_id'];

										$res = $db->query("UPDATE bill_setting SET

																sequence_number 	='$sequence_number',
																last_action 		='$lastaction',
																updated_at			='$reg_date',
																last_action_by		='$by'

															WHERE bill_id=$bill_id  ");
									} else {
										$sequence_number 	= 1;
										$prefix 			= '';
									}

									$test_number = $prefix . $sequence_number;

									$sql = "INSERT INTO radiology_test (	
																	 	radiology_test_date,
																	 	test_type,
																	 	patient_report_id_fk,
																	 	patient_id_fk,
																	 	staff_id_fk,
																	 	sequence_number,
																	 	test_number,
																	 	
																		created_by,
																		created_at,
																	    updated_at,
																		last_action,
																		last_action_by)
																VALUES( 
																		'$report_date',
																		'$test_type',
																		'$id',
																		'$patient_id_fk',
																		'$by',
																		'$sequence_number',
																		'$test_number',
																		
																		'$by',
																		'$reg_date',
																		'$reg_date',
																		'$lastaction',
																		'$by')";
									$res = $db->query($sql);

									if ($res) {

										$radiology_test_id 		= 	$db->insert_id;
									} else {

										loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
										$db->rollback();
										$op['is_success'] = false;
										$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
										echo json_encode($op);
										exit;
									}
								}
							}

							$sql = "INSERT INTO 
				    						radiology_test_detail 
				    						(	
											 	product_id_fk,
											 	test_note,
											 	cost,
											 	sell,
											 	patient_report_id_fk,
											 	patient_id_fk,
											 	radiology_test_id_fk,
											 	
												created_by,
												created_at,
											    updated_at,
												last_action,
												last_action_by
											)
										VALUES
											( 
												'$product_id_fk',
												'$test_note',
												'$cost',
												'$sell',
												'$id',
												'$patient_id_fk',
												'$radiology_test_id',
												
												'$by',
												'$reg_date',
												'$reg_date',
												'$lastaction',
												'$by'
											)";

							$res = $db->query($sql);

							$in_id 		= 	$db->insert_id;


							loglog('Add', "patient_report", $id, "Added Successfully(test_type:$test_type:$in_id:$product_id_fk)", 'patient_report.php');

							if (!$res) {
								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$db->rollback();
								$op['is_success'] = false;
								$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
								echo json_encode($op);
								exit;
							}
						}

						// for Invoice

						if ($inv_id == 0) {

							if ($prev_type != $test_type) {
								$res = $db->query("SELECT * FROM sell WHERE patient_report_id_fk=$id ");

								if (mysqli_num_rows($res) > 0) {
									$row = $res->fetch_assoc();
									$inv_id 	= $row['sell_id'];

									$v = 0;
									foreach ($_POST["edit_rad_product_id_fk"] as $p) {
										$invoice_total_price = $invoice_total_price + $_POST["edit_rad_sell"][$v];
										$v++;
									}

									$update_qry = "UPDATE sell SET 
												is_deleted				=0,
												invoice_total_price 	='$invoice_total_price',
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
										WHERE patient_report_id_fk 	= $id AND sell_id= $inv_id";


									$res = $db->query($update_qry);

									if (!$res) {
										loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
										$op['is_success'] = false;
										$op['data'] 	  = $db->error;
										$db->rollback();
										echo json_encode($op);
										exit;
									}
								} else {
									$v = 0;
									foreach ($_POST["edit_rad_product_id_fk"] as $p) {
										$invoice_total_price = $invoice_total_price + $_POST["edit_rad_sell"][$v];
										$v++;
									}

									$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='sell' ");

									if (mysqli_num_rows($res) > 0) {
										$row = $res->fetch_assoc();
										$sequence_number 	= $row['sequence_number'] + 1;
										$prefix 			= $row['prefix'];
										$bill_id 			= $row['bill_id'];

										$res = $db->query("UPDATE bill_setting SET

																		sequence_number 	='$sequence_number',
																		last_action 		='$lastaction',
																		updated_at			='$reg_date',
																		last_action_by		='$by'

																WHERE bill_id=$bill_id  ");
									} else {
										$sequence_number 	= 1;
										$prefix 			= '';
									}

									$invoice_number = $prefix . $sequence_number;

									$sql = "INSERT INTO sell (	
																	 	invoice_number,
																	 	invoice_year,
																	 	invoice_date,
																	 	invoice_type,
																	 	pay_status,
																	 	invoice_total_price,
																	 	invoice_total_discount,
																	 	sell_note,
																	 	person_name,
																	 	patient_id_fk,
																	 	patient_report_id_fk,
																	 	staff_id_fk,
																	 	sequence_number,
																	 	origin_table_name,

																		created_by,
																		created_at,
																	    updated_at,
																		last_action,
																		last_action_by)
																VALUES( 
																		'$invoice_number',
																		'$invoice_year',
																		'$report_date',
																		'invoice',
																		'0',
																		'$invoice_total_price',
																		'0',
																		'Added From Patient Report',
																		'',
																		'$patient_id_fk',
																		'$id',
																		'$by',
																		'$sequence_number',
																		'patient_report',
																		
																		'$by',
																		'$reg_date',
																		'$reg_date',
																		'$lastaction',
																		'$by')";
									$res = $db->query($sql);

									if ($res) {
										$inv_id 		= 	$db->insert_id;
									} else {

										loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
										$op['is_success'] = false;
										$op['data'] 	  = $db->error;
										$db->rollback();
										echo json_encode($op);
										exit;
									}
								}
							}
						} else {

							if ($prev_type != $test_type) {
								$v = 0;
								foreach ($_POST["edit_rad_product_id_fk"] as $p) {
									$invoice_total_price = $invoice_total_price + $_POST["edit_rad_sell"][$v];
									$v++;
								}

								$update_qry = "UPDATE sell SET 
											is_deleted				=0,
											invoice_total_price 	='$invoice_total_price',
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
									WHERE patient_report_id_fk 	= $id AND sell_id= $inv_id";


								$res = $db->query($update_qry);

								if (!$res) {
									loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
									$op['is_success'] = false;
									$op['data'] 	  = $db->error;
									$db->rollback();
									echo json_encode($op);
									exit;
								}
							}
						}

						$cost_price 			= $cost;
						$product_unit_id_fk 	= 0;
						$unit_scale 			= 0;
						$product_type_id_fk 	= 0;
						$sell_quantity 			= 1;
						$sell_price 			= $sell;
						$discount 				= 0;
						$sell_detail_note 		= $test_note;
						$stock_id_fk 			= $_SESSION["default_stock_id_fk"];


						if ($product_id_fk > 0) {

							if ($sell_detail_id > 0 && $sell_id > 0) {

								$sql = "UPDATE sell_detail SET 
													product_id_fk			='$product_id_fk',
													sell_quantity			='$sell_quantity',
													sell_price				='$sell_price',
													cost_price				='$cost_price',
													sell_detail_date		='$report_date',
													product_unit_id_fk		='$product_unit_id_fk',
													sell_detail_note		='$sell_detail_note',
													origin_from				='radiology_test',
													stock_id_fk				='$stock_id_fk',
													sell_id_fk				='$inv_id',
													patient_id_fk			='$patient_id_fk',
													patient_report_id_fk	='$id',
													is_deleted				=0,
													
													last_action 			='$lastaction',
													updated_at				='$reg_date',
													last_action_by			='$by' 
												WHERE sell_detail_id 	= $sell_detail_id";

								$res = $db->query($sql);
								$id_sub 		= 	$sell_detail_id;
							} else {

								$sql = "INSERT INTO 
				    						sell_detail 
				    						(	
											 	product_id_fk,
											 	sell_quantity,
											 	sell_price,
											 	cost_price,
											 	discount,
											 	sell_detail_date,
											 	product_unit_id_fk,
											 	unit_scale,
											 	sell_detail_note,
											 	origin_from,
											 	stock_id_fk,
											 	product_type_id_fk,
											 	sell_id_fk,
											 	patient_report_id_fk,
											 	patient_id_fk,
											 	
												created_by,
												created_at,
											    updated_at,
												last_action,
												last_action_by
											)
										VALUES
											( 
												'$product_id_fk',
												'$sell_quantity',
												'$sell_price',
												'$cost_price',
												'$discount',
												'$report_date',
												'$product_unit_id_fk',
												'$unit_scale',
												'$sell_detail_note',
												'radiology_test',
												'$stock_id_fk',
												'$product_type_id_fk',
												'$inv_id',
												'$id',
												'$patient_id_fk',
												
												'$by',
												'$reg_date',
												'$reg_date',
												'$lastaction',
												'$by'
											)";

								$res = $db->query($sql);
								$id_sub 		= 	$db->insert_id;
							}


							if ($res) {



								loglog('Add', "sell", $id, "Added Successfully(sell-detail:$id_sub:$product_id_fk)", 'patient_report.php');

								$stock_transaction 	= 'Sell';

								$primary_table = 'sell';
								$detail_table  = 'sell_detail';
								$secondary_table  = 'radiology_test';


								$sql = "INSERT INTO product_stock (	
														 	recieved_quantity,
														 	stock_transaction,
														 	stock_transaction_type,
														 	transaction_date,
														 	sell_price,
														 	buy_price,
														 	primary_id_fk,
														 	primary_table,
														 	secondary_table,
														 	detail_id_fk,
														 	detail_table,
														 	product_id_fk,
														 	stock_id_fk,
														 	patient_report_id_fk,
														 	patient_id_fk,
										 	
										 	
															created_by,
															created_at,
														    updated_at,
															last_action,
															last_action_by)
													VALUES( 
															'$sell_quantity',
															'$stock_transaction',
															'2',
															'$report_date',
															'$sell_price',
															'$cost_price',
															'$inv_id',
															'$primary_table',
															'$secondary_table',
															'$id_sub',
															'$detail_table',
															'$product_id_fk',
															'$stock_id_fk',
															'$id',
															'$patient_id_fk',
															
															
															'$by',
															'$reg_date',
															'$reg_date',
															'$lastaction',
															'$by')";

								$res = $db->query($sql);

								if (!$res) {
									loglog('Fail Add', "product_stock", $inv_id, "$db->error", 'patient_report.php');

									$op['is_success'] = false;
									$op['data'] 	  = $db->error;
									$db->rollback();
									echo json_encode($op);
									exit;
								}
							} else {
								loglog('Fail Add', "sell", $inv_id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}
						}
						// End invoice
					}

					$prev_type = $test_type;
				}

				$error = ImageUploader('edit_rad_result_file', 'rad-file', 'radiology_test', 'result_file', $radiology_test_id, 'radiology_test_id', '');
			}


			// For Consultation
			$index_num 	=	0;



			$prev_type = '';

			if (isset($_POST["edit_consul_product_id_fk"])) {

				foreach ($_POST["edit_consul_product_id_fk"] as $product_id_fk) {

					$sell_detail_id 	= $_POST["edit_sell_detail_id"][$index_num];
					$sell_detail_note	= addslashes($_POST["edit_consul_note"][$index_num]);
					$test_type 			= $_POST["edit_consul_test_type"][$index_num];
					$cost 				= $_POST["edit_consul_cost"][$index_num];
					$sell 				= $_POST["edit_consul_sell"][$index_num];
					$consultant_name 	= addslashes($_POST["edit_consultant_name"][$index_num]);
					$sell_detail_date	= $_POST["edit_consul_date"][$index_num];

					$sell_id 					= $_POST["edit_consul_sell_id"][$index_num];
					// $sell_detail_id 			=$_POST["edit_consul_sell_detail_id"][$index_num];


					if ($sell_detail_date == '') {
						$sell_detail_date = $reg_date;
					}

					$index_num++;

					if ($product_id_fk > 0) {

						// for Invoice

						if ($inv_id == 0) {

							if ($prev_type != $test_type) {
								$res = $db->query("SELECT * FROM sell WHERE patient_report_id_fk=$id AND patient_report_id_fk>0 ");

								if (mysqli_num_rows($res) > 0) {
									$row = $res->fetch_assoc();
									$inv_id 	= $row['sell_id'];

									$v = 0;
									foreach ($_POST["edit_consul_product_id_fk"] as $p) {
										$invoice_total_price = $invoice_total_price + $_POST["edit_consul_sell"][$v];
										$v++;
									}

									$update_qry = "UPDATE sell SET 
												is_deleted				=0,
												invoice_total_price 	='$invoice_total_price',
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
										WHERE patient_report_id_fk 	= $id AND sell_id= $inv_id";


									$res = $db->query($update_qry);

									if (!$res) {
										loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
										$op['is_success'] = false;
										$op['data'] 	  = $db->error;
										$db->rollback();
										echo json_encode($op);
										exit;
									}
								} else {
									$v = 0;
									foreach ($_POST["edit_consul_product_id_fk"] as $p) {
										$invoice_total_price = $invoice_total_price + $_POST["edit_consul_sell"][$v];
										$v++;
									}

									$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='sell' ");

									if (mysqli_num_rows($res) > 0) {
										$row = $res->fetch_assoc();
										$sequence_number 	= $row['sequence_number'] + 1;
										$prefix 			= $row['prefix'];
										$bill_id 			= $row['bill_id'];

										$res = $db->query("UPDATE bill_setting SET

																		sequence_number 	='$sequence_number',
																		last_action 		='$lastaction',
																		updated_at			='$reg_date',
																		last_action_by		='$by'

																WHERE bill_id=$bill_id  ");
									} else {
										$sequence_number 	= 1;
										$prefix 			= '';
									}

									$invoice_number = $prefix . $sequence_number;

									$sql = "INSERT INTO sell (	
																	 	invoice_number,
																	 	invoice_year,
																	 	invoice_date,
																	 	invoice_type,
																	 	pay_status,
																	 	invoice_total_price,
																	 	invoice_total_discount,
																	 	sell_note,
																	 	person_name,
																	 	patient_id_fk,
																	 	patient_report_id_fk,
																	 	staff_id_fk,
																	 	sequence_number,
																	 	origin_table_name,

																		created_by,
																		created_at,
																	    updated_at,
																		last_action,
																		last_action_by)
																VALUES( 
																		'$invoice_number',
																		'$invoice_year',
																		'$report_date',
																		'invoice',
																		'0',
																		'$invoice_total_price',
																		'0',
																		'Added From Patient Report',
																		'',
																		'$patient_id_fk',
																		'$id',
																		'$by',
																		'$sequence_number',
																		'patient_report',
																		
																		'$by',
																		'$reg_date',
																		'$reg_date',
																		'$lastaction',
																		'$by')";
									$res = $db->query($sql);

									if ($res) {
										$inv_id 		= 	$db->insert_id;
									} else {

										loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
										$op['is_success'] = false;
										$op['data'] 	  = $db->error;
										$db->rollback();
										echo json_encode($op);
										exit;
									}
								}
							}
						} else {

							if ($prev_type != $test_type) {
								$v = 0;
								foreach ($_POST["edit_consul_product_id_fk"] as $p) {
									$invoice_total_price = $invoice_total_price + $_POST["edit_consul_sell"][$v];
									$v++;
								}

								$update_qry = "UPDATE sell SET 
											is_deleted				=0,
											invoice_total_price 	='$invoice_total_price',
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
									WHERE patient_report_id_fk 	= $id AND sell_id= $inv_id";


								$res = $db->query($update_qry);

								if (!$res) {
									loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
									$op['is_success'] = false;
									$op['data'] 	  = $db->error;
									$db->rollback();
									echo json_encode($op);
									exit;
								}
							}
						}

						$cost_price 			= $cost;
						$product_unit_id_fk 	= 0;
						$unit_scale 			= 0;
						$product_type_id_fk 	= 0;
						$sell_quantity 			= 1;
						$sell_price 			= $sell;
						$discount 				= 0;
						// $sell_detail_note 		=$test_note;
						$stock_id_fk 			= $_SESSION["default_stock_id_fk"];


						if ($sell_detail_id > 0) {

							$update_qry = "UPDATE sell_detail SET 
												product_id_fk			='$product_id_fk',
												sell_quantity			='$sell_quantity',
												sell_price				='$sell_price',
												cost_price				='$cost_price',
												sell_detail_date		='$sell_detail_date',
												product_unit_id_fk		='$product_unit_id_fk',
												unit_scale				='$unit_scale',
												sell_detail_note		='$sell_detail_note',
												origin_from				='consultation',
												stock_id_fk				='$stock_id_fk',
												product_type_id_fk		='$product_type_id_fk',
												patient_id_fk			='$patient_id_fk',
												consultant_name			='$consultant_name',
												is_deleted				=0,
												
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
								WHERE sell_detail_id = $sell_detail_id";


							$res = $db->query($update_qry);
							if (!$res) {
								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}


							$update_qry = "UPDATE product_stock SET 
												product_id_fk			='$product_id_fk',
												recieved_quantity		='$sell_quantity',
												sell_price				='$sell_price',
												buy_price				='$cost_price',
												secondary_table			='consultation',
												stock_id_fk				='$stock_id_fk',
												patient_id_fk			='$patient_id_fk',
												is_deleted				=0,
												
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
								WHERE patient_report_id_fk =$id AND patient_report_id_fk >0 AND detail_table='sell_detail' AND detail_id_fk	= $sell_detail_id";


							$res = $db->query($update_qry);
							if (!$res) {
								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}
						} else {

							$sql = "INSERT INTO 
			    						sell_detail 
			    						(	
										 	product_id_fk,
										 	sell_quantity,
										 	sell_price,
										 	cost_price,
										 	discount,
										 	sell_detail_date,
										 	product_unit_id_fk,
										 	unit_scale,
										 	sell_detail_note,
										 	origin_from,
										 	stock_id_fk,
										 	product_type_id_fk,
										 	sell_id_fk,
										 	patient_report_id_fk,
										 	patient_id_fk,
										 	consultant_name,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by
										)
									VALUES
										( 
											'$product_id_fk',
											'$sell_quantity',
											'$sell_price',
											'$cost_price',
											'$discount',
											'$report_date',
											'$product_unit_id_fk',
											'$unit_scale',
											'$sell_detail_note',
											'consultation',
											'$stock_id_fk',
											'$product_type_id_fk',
											'$inv_id',
											'$id',
											'$patient_id_fk',
											'$consultant_name',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by'
										)";

							$res = $db->query($sql);



							if ($res) {

								$id_sub 		= 	$db->insert_id;


								loglog('Add', "sell", $id, "Added Successfully(sell-detail:$id_sub:$product_id_fk)", 'patient_report.php');

								$stock_transaction 	= 'Sell';

								$primary_table 		= 'sell';
								$detail_table  		= 'sell_detail';
								$secondary_table  	= 'consultation';


								$sql = "INSERT INTO product_stock (	
														 	recieved_quantity,
														 	stock_transaction,
														 	stock_transaction_type,
														 	transaction_date,
														 	sell_price,
														 	buy_price,
														 	primary_id_fk,
														 	primary_table,
														 	secondary_table,
														 	detail_id_fk,
														 	detail_table,
														 	product_id_fk,
														 	stock_id_fk,
														 	patient_report_id_fk,
														 	patient_id_fk,
										 	
										 	
															created_by,
															created_at,
														    updated_at,
															last_action,
															last_action_by)
													VALUES( 
															'$sell_quantity',
															'$stock_transaction',
															'2',
															'$sell_detail_date',
															'$sell_price',
															'$cost_price',
															'$inv_id',
															'$primary_table',
															'$secondary_table',
															'$id_sub',
															'$detail_table',
															'$product_id_fk',
															'$stock_id_fk',
															'$id',
															'$patient_id_fk',
															
															
															'$by',
															'$reg_date',
															'$reg_date',
															'$lastaction',
															'$by')";

								$res = $db->query($sql);

								if (!$res) {
									loglog('Fail Add', "product_stock", $inv_id, "$db->error", 'patient_report.php');

									$op['is_success'] = false;
									$op['data'] 	  = $db->error;
									$db->rollback();
									echo json_encode($op);
									exit;
								}
							} else {
								loglog('Fail Add', "sell", $inv_id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}
						}
						// End invoice
					}

					$prev_type = $test_type;
				}
			}


			// For Service & Procedures
			$index_num 	=	0;



			$prev_type = '';

			if (isset($_POST["edit_serv_product_id_fk"])) {

				foreach ($_POST["edit_serv_product_id_fk"] as $product_id_fk) {

					$sell_detail_id 	= $_POST["edit_serv_sell_detail_id"][$index_num];
					$sell_detail_note	= addslashes($_POST["edit_serv_note"][$index_num]);
					$test_type 			= $_POST["edit_serv_test_type"][$index_num];
					$cost 				= $_POST["edit_serv_cost"][$index_num];
					$sell 				= $_POST["edit_serv_sell"][$index_num];
					$consultant_name 	= addslashes($_POST["edit_serv_consultant_name"][$index_num]);
					$sell_detail_date	= $_POST["edit_serv_date"][$index_num];
					$sell_quantity		= $_POST["edit_serv_sell_quantity"][$index_num];

					if ($sell_detail_date == '') {
						$sell_detail_date = $reg_date;
					}

					$index_num++;

					if ($product_id_fk > 0) {

						// for Invoice

						if ($inv_id == 0) {

							if ($prev_type != $test_type) {
								$res = $db->query("SELECT * FROM sell WHERE patient_report_id_fk=$id AND patient_report_id_fk>0 ");

								if (mysqli_num_rows($res) > 0) {
									$row = $res->fetch_assoc();
									$inv_id 	= $row['sell_id'];

									$v = 0;
									foreach ($_POST["edit_serv_product_id_fk"] as $p) {
										$invoice_total_price = $invoice_total_price + ($_POST["edit_serv_sell"][$v] * $_POST["edit_serv_sell_quantity"][$v]);
										$v++;
									}

									$update_qry = "UPDATE sell SET 
												is_deleted				=0,
												invoice_total_price 	='$invoice_total_price',
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
										WHERE patient_report_id_fk 	= $id AND sell_id= $inv_id";


									$res = $db->query($update_qry);

									if (!$res) {
										loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
										$op['is_success'] = false;
										$op['data'] 	  = $db->error;
										$db->rollback();
										echo json_encode($op);
										exit;
									}
								} else {
									$v = 0;
									foreach ($_POST["edit_serv_product_id_fk"] as $p) {
										$invoice_total_price = $invoice_total_price + ($_POST["edit_serv_sell"][$v] * $_POST["edit_serv_sell_quantity"][$v]);
										$v++;
									}

									$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='sell' ");

									if (mysqli_num_rows($res) > 0) {
										$row = $res->fetch_assoc();
										$sequence_number 	= $row['sequence_number'] + 1;
										$prefix 			= $row['prefix'];
										$bill_id 			= $row['bill_id'];

										$res = $db->query("UPDATE bill_setting SET

																		sequence_number 	='$sequence_number',
																		last_action 		='$lastaction',
																		updated_at			='$reg_date',
																		last_action_by		='$by'

																WHERE bill_id=$bill_id  ");
									} else {
										$sequence_number 	= 1;
										$prefix 			= '';
									}

									$invoice_number = $prefix . $sequence_number;

									$sql = "INSERT INTO sell (	
																	 	invoice_number,
																	 	invoice_year,
																	 	invoice_date,
																	 	invoice_type,
																	 	pay_status,
																	 	invoice_total_price,
																	 	invoice_total_discount,
																	 	sell_note,
																	 	person_name,
																	 	patient_id_fk,
																	 	patient_report_id_fk,
																	 	staff_id_fk,
																	 	sequence_number,
																	 	origin_table_name,

																		created_by,
																		created_at,
																	    updated_at,
																		last_action,
																		last_action_by)
																VALUES( 
																		'$invoice_number',
																		'$invoice_year',
																		'$report_date',
																		'invoice',
																		'0',
																		'$invoice_total_price',
																		'0',
																		'Added From Patient Report',
																		'',
																		'$patient_id_fk',
																		'$id',
																		'$by',
																		'$sequence_number',
																		'patient_report',
																		
																		'$by',
																		'$reg_date',
																		'$reg_date',
																		'$lastaction',
																		'$by')";
									$res = $db->query($sql);

									if ($res) {
										$inv_id 		= 	$db->insert_id;
									} else {

										loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
										$op['is_success'] = false;
										$op['data'] 	  = $db->error;
										$db->rollback();
										echo json_encode($op);
										exit;
									}
								}
							}
						} else {

							if ($prev_type != $test_type) {
								$v = 0;
								foreach ($_POST["edit_serv_product_id_fk"] as $p) {
									$invoice_total_price = $invoice_total_price + ($_POST["edit_serv_sell"][$v] * $_POST["edit_serv_sell_quantity"][$v]);
									$v++;
								}

								$update_qry = "UPDATE sell SET 
											is_deleted				=0,
											invoice_total_price 	='$invoice_total_price',
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
									WHERE patient_report_id_fk 	= $id AND sell_id= $inv_id";


								$res = $db->query($update_qry);

								if (!$res) {
									loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
									$op['is_success'] = false;
									$op['data'] 	  = $db->error;
									$db->rollback();
									echo json_encode($op);
									exit;
								}
							}
						}

						$cost_price 			= $cost;
						$product_unit_id_fk 	= 0;
						$unit_scale 			= 0;
						$product_type_id_fk 	= 0;
						// $sell_quantity 			=1;
						$sell_price 			= $sell;
						$discount 				= 0;
						// $sell_detail_note 		=$test_note;
						$stock_id_fk 			= $_SESSION["default_stock_id_fk"];


						if ($sell_detail_id > 0) {

							$update_qry = "UPDATE sell_detail SET 
												product_id_fk			='$product_id_fk',
												sell_quantity			='$sell_quantity',
												sell_price				='$sell_price',
												cost_price				='$cost_price',
												sell_detail_date		='$sell_detail_date',
												product_unit_id_fk		='$product_unit_id_fk',
												unit_scale				='$unit_scale',
												sell_detail_note		='$sell_detail_note',
												origin_from				='procedure',
												stock_id_fk				='$stock_id_fk',
												product_type_id_fk		='$product_type_id_fk',
												patient_id_fk			='$patient_id_fk',
												consultant_name			='$consultant_name',
												is_deleted				=0,
												
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
								WHERE sell_detail_id = $sell_detail_id";


							$res = $db->query($update_qry);
							if (!$res) {
								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}


							$update_qry = "UPDATE product_stock SET 
												product_id_fk			='$product_id_fk',
												recieved_quantity		='$sell_quantity',
												sell_price				='$sell_price',
												buy_price				='$cost_price',
												secondary_table			='procedure',
												stock_id_fk				='$stock_id_fk',
												patient_id_fk			='$patient_id_fk',
												is_deleted				=0,
												
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
								WHERE patient_report_id_fk =$id AND patient_report_id_fk >0 AND detail_table='sell_detail' AND detail_id_fk	= $sell_detail_id";


							$res = $db->query($update_qry);
							if (!$res) {
								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}
						} else {

							$sql = "INSERT INTO 
			    						sell_detail 
			    						(	
										 	product_id_fk,
										 	sell_quantity,
										 	sell_price,
										 	cost_price,
										 	discount,
										 	sell_detail_date,
										 	product_unit_id_fk,
										 	unit_scale,
										 	sell_detail_note,
										 	origin_from,
										 	stock_id_fk,
										 	product_type_id_fk,
										 	sell_id_fk,
										 	patient_report_id_fk,
										 	patient_id_fk,
										 	consultant_name,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by
										)
									VALUES
										( 
											'$product_id_fk',
											'$sell_quantity',
											'$sell_price',
											'$cost_price',
											'$discount',
											'$report_date',
											'$product_unit_id_fk',
											'$unit_scale',
											'$sell_detail_note',
											'procedure',
											'$stock_id_fk',
											'$product_type_id_fk',
											'$inv_id',
											'$id',
											'$patient_id_fk',
											'$consultant_name',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by'
										)";

							$res = $db->query($sql);



							if ($res) {

								$id_sub 		= 	$db->insert_id;


								loglog('Add', "sell", $id, "Added Successfully(sell-detail:$id_sub:$product_id_fk)", 'patient_report.php');

								$stock_transaction 	= 'Sell';

								$primary_table 		= 'sell';
								$detail_table  		= 'sell_detail';
								$secondary_table  	= 'procedure';


								$sql = "INSERT INTO product_stock (	
														 	recieved_quantity,
														 	stock_transaction,
														 	stock_transaction_type,
														 	transaction_date,
														 	sell_price,
														 	buy_price,
														 	primary_id_fk,
														 	primary_table,
														 	secondary_table,
														 	detail_id_fk,
														 	detail_table,
														 	product_id_fk,
														 	stock_id_fk,
														 	patient_report_id_fk,
														 	patient_id_fk,
										 	
										 	
															created_by,
															created_at,
														    updated_at,
															last_action,
															last_action_by)
													VALUES( 
															'$sell_quantity',
															'$stock_transaction',
															'2',
															'$sell_detail_date',
															'$sell_price',
															'$cost_price',
															'$inv_id',
															'$primary_table',
															'$secondary_table',
															'$id_sub',
															'$detail_table',
															'$product_id_fk',
															'$stock_id_fk',
															'$id',
															'$patient_id_fk',
															
															
															'$by',
															'$reg_date',
															'$reg_date',
															'$lastaction',
															'$by')";

								$res = $db->query($sql);

								if (!$res) {
									loglog('Fail Add', "product_stock", $inv_id, "$db->error", 'patient_report.php');

									$op['is_success'] = false;
									$op['data'] 	  = $db->error;
									$db->rollback();
									echo json_encode($op);
									exit;
								}
							} else {
								loglog('Fail Add', "sell", $inv_id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}
						}
						// End invoice
					}

					$prev_type = $test_type;
				}
			}


			// For Treatments

			$index_num 	=	0;

			$update_qry = "UPDATE patient_treatment SET 
											is_deleted				=1,
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
							WHERE patient_report_id_fk 	= $id";


			$res = $db->query($update_qry);

			if (isset($_POST["edit_medicine_name"])) {

				// foreach ($_POST["edit_treat_product_id_fk"] as $product_id_fk) {
				foreach ($_POST["edit_medicine_name"] as $medicine_name1) {

					$treatment_id 			= $_POST["edit_treatment_id"][$index_num];
					$treat_form_id_fk 		= isset($_POST["edit_treat_form_id_fk"][$index_num]) ? $_POST["edit_treat_form_id_fk"][$index_num] : 0;

					$dose 					= addslashes($_POST["edit_dose"][$index_num]);
					$treat_route_id_fk 		= isset($_POST["edit_treat_route_id_fk"][$index_num]) ? $_POST["edit_treat_route_id_fk"][$index_num] : 0;
					$treat_frequency_id_fk 	= isset($_POST["edit_treat_frequency_id_fk"][$index_num]) ? $_POST["edit_treat_frequency_id_fk"][$index_num] : 0;
					$treat_note 			= addslashes($_POST["edit_treat_note"][$index_num]);
					$medicine_name 			= addslashes($_POST["edit_medicine_name"][$index_num]);

					$index_num++;

					if ($medicine_name != "") {

						if ($treatment_id > 0) {
							$update_qry = "UPDATE patient_treatment SET 
												treatment_date			='$report_date',
												medicine_name			='$medicine_name',
												treat_form_id_fk		='$treat_form_id_fk',
												dose					='$dose',
												treat_route_id_fk		='$treat_route_id_fk',
												treat_frequency_id_fk	='$treat_frequency_id_fk',
												treat_note				='$treat_note',
												patient_id_fk			='$patient_id_fk',
												is_deleted				=0,
												
												last_action 			='$lastaction',
												updated_at				='$reg_date',
												last_action_by			='$by' 
								WHERE treatment_id 	= $treatment_id";


							$res = $db->query($update_qry);
						} else {

							$sql = "INSERT INTO 
			    						patient_treatment 
			    						(	
										 	treatment_date,
										 	medicine_name,
										 	treat_form_id_fk,
										 	dose,
										 	treat_route_id_fk,
										 	treat_frequency_id_fk,
										 	treat_note,
										 	patient_report_id_fk,
										 	patient_id_fk,
										 	staff_id_fk,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by
										)
									VALUES
										( 
											'$report_date',
											'$medicine_name',
											'$treat_form_id_fk',
											'$dose',
											'$treat_route_id_fk',
											'$treat_frequency_id_fk',
											'$treat_note',
											'$id',
											'$patient_id_fk',
											'$by',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by'
										)";

							$res = $db->query($sql);

							$in_id 		= 	$db->insert_id;


							loglog('Add', "patient_treatment", $id, "Added Successfully(patient_treatment:$in_id:$product_id_fk)", 'patient_report.php');

							if (!$res) {
								loglog('Fail Add', "patient_treatment", $id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}
						}
					}
				}
			}


			// For Tour Note

			$index_num 	=	0;



			if (isset($_POST["edit_report_note_tour"])) {

				foreach ($_POST["edit_report_note_tour"] as $report_note_tour1) {

					$note_id 	= $_POST["edit_note_id"][$index_num];
					$noter_name = addslashes($_POST["edit_noter_name"][$index_num]);
					$note_date 	= $_POST["edit_note_date"][$index_num];
					$note_type 	= isset($_POST["edit_note_type"][$index_num]) ? addslashes($_POST["edit_note_type"][$index_num]) : 0;

					$report_note_tour = addslashes($_POST["edit_report_note_tour"][$index_num]);

					if ($report_note_tour != '') {

						if ($note_id > 0) {
							$update_qry = "UPDATE patient_report_note SET 
												report_note_tour	='$report_note_tour',
												noter_name			='$noter_name',
												note_date			='$note_date',
												note_type			='$note_type',
												patient_id_fk		='$patient_id_fk',
												is_deleted			=0,
												
												last_action 		='$lastaction',
												updated_at			='$reg_date',
												last_action_by		='$by' 
								WHERE note_id 	= $note_id";


							$res = $db->query($update_qry);

							$error = ImageUploaderSingleArray('edit_note_file', 'note-file', 'patient_report_note', 'note_file', $id, 'note_id', '', $index_num, $note_id);
						} else {

							$sql = "INSERT INTO 
			    						patient_report_note 
			    						(	
										 	report_note_tour,
										 	noter_name,
										 	note_date,
										 	note_type,
										 	patient_report_id_fk,
										 	patient_id_fk,
										 	staff_id_fk,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by
										)
									VALUES
										( 
											'$report_note_tour',
											'$noter_name',
											'$note_date',
											'$note_type',
											'$id',
											'$patient_id_fk',
											'$by',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by'
										)";

							$res = $db->query($sql);

							$in_id 		= 	$db->insert_id;

							$error = ImageUploaderSingleArray('edit_note_file', 'note-file', 'patient_report_note', 'note_file', $id, 'note_id', '', $index_num, $in_id);



							loglog('Add', "patient_report", $id, "Added Successfully(patient_tour:$in_id:$report_note_tour)", 'patient_report.php');

							if (!$res) {
								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$op['is_success'] = false;
								$op['data'] 	  = $db->error;
								$db->rollback();
								echo json_encode($op);
								exit;
							}
						}
					}

					$index_num++;
				}
			}

			$res = $db->query("SELECT * FROM patient_report WHERE patient_report_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			loglog('Update', "patient_report", $id, "Record Successfully Updated", 'patient_report.php', $updated_columns_before, $updated_columns);

			if ($is_refferal == 1) {

				if ($patient_refferal_id > 0) {

					$sql = "UPDATE patient_refferal SET	
							 	referred_to			='$referred_to',
								clinc_site_name		='$clinc_site_name',
								chief_complaint		='$chief_complaint',
								reason_for_refferal ='$reason_for_refferal',
								refferal_note 		='$refferal_note',
								refferal_date		='$report_date',
								patient_id_fk		='$patient_id_fk',
								last_action 		='$lastaction',
								updated_at			='$reg_date',
								last_action_by		='$by' 
							WHERE patient_refferal_id 	= $patient_refferal_id";
				} else {

					$sql = "INSERT INTO patient_refferal (	
										 	referred_to,
										 	clinc_site_name,
										 	chief_complaint,
										 	reason_for_refferal,
										 	refferal_note,
										 	patient_report_id_fk,
										 	
										 	refferal_date,
										 	patient_id_fk,
										 	staff_id_fk,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by)
									VALUES( 
											'$referred_to',
											'$clinc_site_name',
											'$chief_complaint',
											'$reason_for_refferal',
											'$refferal_note',
											'$id',
											
											'$report_date',
											'$patient_id_fk',
											'$by',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by')";
				}



				$res = $db->query($sql);
				if (!$res) {
					loglog('Fail Update', 'patient_refferal', 0, "Failed Update Patient Refferal ($report_reference_number) Error:($db->error)", 'patient_report.php');

					$op['is_success'] = false;
					$op['data'] 	  = $db->error;
					$db->rollback();
					echo json_encode($op);
					exit;
				}
			}

			$res = $db->query("SELECT * FROM sell WHERE patient_report_id_fk=$id AND patient_report_id_fk>0 AND is_deleted=0 LIMIT 1");

			if (mysqli_num_rows($res) > 0) {
				$row = $res->fetch_assoc();
				$inv_id 				= $row['sell_id'];
				$invoice_total_discount = $row['invoice_total_discount'];
				$invoice_total_price 	= $row['invoice_total_price'];
			}

			$invoice_total_price = $invoice_total_price - $invoice_total_discount;

			$update_qry = "UPDATE sell SET 
											is_deleted				=0,
											invoice_total_price 	='$invoice_total_price',
											last_action 			='$lastaction',
											updated_at				='$reg_date',
											last_action_by			='$by' 
									WHERE patient_report_id_fk 	= $id AND sell_id= $inv_id";


			$res = $db->query($update_qry);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	 	  = "Record Successfully Updated";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Update', "patient_report", $id, "$db->error", 'patient_report.php');

			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			$db->rollback();
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "set_status") {

		$id 				 	= $_POST['status_id'];
		$appointment_status 	= $_POST["appointment_status"];

		$op  = array('is_success' => false, 'data' => '');

		$reg_date 	= date("Y-m-d H:i:s", time());

		$res = $db->query("SELECT * FROM appointment WHERE appointment_id=$id");

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$lastaction = "Update appointment status";
		$by 		= $_SESSION['user_id'];

		$update_qry = "UPDATE appointment SET 
								appointment_status	='$appointment_status',
								
								last_action 		='$lastaction',
								updated_at			='$reg_date',
								last_action_by		='$by' 
							WHERE appointment_id = $id";


		$res = $db->query($update_qry);
		if ($res) {


			$res = $db->query("SELECT * FROM appointment WHERE appointment_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			loglog('Update', "patient_report", $id, "Status Successfully Updated", 'patient_report.php', $updated_columns_before, $updated_columns);

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	 	  = "Status Successfully Updated";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Update', "patient_report", $id, "$db->error", 'patient_report.php');

			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  	= "Error: Update Failed";
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "discharge") {

		$id 				 	= $_POST['discharge_id'];
		$discharge_summary 		= $_POST["discharge_discharge_summary"];

		$op  = array('is_success' => false, 'data' => '');

		$reg_date 	= date("Y-m-d H:i:s", time());

		$res = $db->query("SELECT * FROM patient_report WHERE patient_report_id=$id");

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$lastaction = "Update appointment status";
		$by 		= $_SESSION['user_id'];

		$update_qry = "UPDATE patient_report SET 
								discharge_summary	='$discharge_summary',
								
								last_action 		='$lastaction',
								updated_at			='$reg_date',
								last_action_by		='$by' 
							WHERE patient_report_id = $id";


		$res = $db->query($update_qry);
		if ($res) {


			$res = $db->query("SELECT * FROM patient_report WHERE patient_report_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			loglog('Update', "patient_report", $id, "Status Successfully Updated", 'patient_report.php', $updated_columns_before, $updated_columns);

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	 	  = "Status Successfully Updated";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Update', "patient_report", $id, "$db->error", 'patient_report.php');

			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  	= "Error: Update Failed";
			echo json_encode($op);
			exit;
		}
	}


	if ($_POST['type'] == "delete") {

		$id 		= ($_POST["obj_id"]);
		$reg_date 	= date("Y-m-d H:i:s", time());
		$lastaction = "Delete Patient Report";

		$op  = array('is_success' => false, 'data' => '');

		$by = $_SESSION['user_id'];
		$db->autocommit(FALSE); // to rollback insertion if update fail

		$res = $db->query("SELECT * FROM sell WHERE is_deleted=0 AND patient_report_id_fk=$id AND pay_status > 0 ");

		if (mysqli_num_rows($res) > 0) {
			loglog('Fail Delete', 'lab', $id, "Can Not Delete this Patient Report there is an invoice connected with it", 'patient_report.php');

			$op['is_success'] = false;
			$op['data'] 	  = "Can Not Delete this test there is an invoice and payment connected with it";
			echo json_encode($op);
			exit;
		}

		$res = $db->query("UPDATE patient_report SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id =$id");
		if ($res) {

			$res = $db->query("UPDATE patient_report_detail SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");

			$res = $db->query("UPDATE lab_test SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");

			$res = $db->query("UPDATE lab_test_detail SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");

			$res = $db->query("UPDATE sell SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");

			$res = $db->query("UPDATE sell_detail SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");


			$res = $db->query("UPDATE product_stock SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");


			$res = $db->query("UPDATE radiology_test SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");

			$res = $db->query("UPDATE radiology_test_detail SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");

			$res = $db->query("UPDATE patient_treatment SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");

			$res = $db->query("UPDATE patient_refferal SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE patient_report_id_fk =$id");



			loglog('Delete', 'patient_report', $id, "Record were Successfuly Deleted", 'patient_report.php');

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	  = "Record were Successfuly Deleted";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Delete', 'patient_report', $id, "$db-error", 'patient_report.php');
			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  = "Error: Delete Failed";
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "create") {


		$patient_id_fk 	 		= $_POST["patient_id_fk"];
		$report_date			= $_POST["report_date"];
		$present_complaint		= addslashes($_POST["present_complaint"]);
		$past_medical_history	= addslashes($_POST["past_medical_history"]);
		$past_surgical_history	= addslashes($_POST["past_surgical_history"]);
		$family_history		 	= addslashes($_POST["family_history"]);
		$social_history		 	= addslashes($_POST["social_history"]);
		$assessment		 		= addslashes($_POST["assessment"]);
		$chest					= addslashes($_POST["chest"]);
		$bp						= addslashes($_POST["bp"]);
		$abdomen		 		= addslashes($_POST["abdomen"]);
		$pr						= addslashes($_POST["pr"]);
		$heart 					= addslashes($_POST["heart"]);
		$rr 					= addslashes($_POST["rr"]);
		$cns 					= addslashes($_POST["cns"]);
		$temp 					= addslashes($_POST["temp"]);
		$spo2 					= addslashes($_POST["spo2"]);
		$gcs 					= addslashes($_POST["gcs"]);
		// $investigation 			= $_POST["investigation"];
		$provisional_diagnosis 	= addslashes($_POST["provisional_diagnosis"]);
		// $treatment 				= $_POST["treatment"];
		$follow_up 				= addslashes($_POST["follow_up"]);
		$follow_note 			= addslashes($_POST["follow_note"]);
		$sick_leave 			= addslashes($_POST["sick_leave"]);
		$sick_leave_from 		= addslashes($_POST["sick_leave_from"]);
		$sick_leave_to 			= addslashes($_POST["sick_leave_to"]);
		$sick_leave_note 		= addslashes($_POST["sick_leave_note"]);
		$referral_to 			= addslashes($_POST["referral_to"]);
		$reason_of_referral 	= addslashes($_POST["reason_of_referral"]);
		$report_note 			= addslashes($_POST["report_note"]);
		$discharge_summary 		= addslashes($_POST["discharge_summary"]);
		$medical_report 		= addslashes($_POST["medical_report"]);
		$is_refferal 			= addslashes($_POST["is_refferal"]);
		$referred_to 			= addslashes($_POST["referred_to"]);
		$clinc_site_name 		= addslashes($_POST["clinc_site_name"]);
		$chief_complaint 		= addslashes($_POST["chief_complaint"]);
		$reason_for_refferal 	= addslashes($_POST["reason_for_refferal"]);
		$refferal_note 			= addslashes($_POST["refferal_note"]);





		$delete 	= 0;
		$reg_date 	= date("Y-m-d H:i:s", time());
		$invoice_year 	= date("Y", time());
		$lastaction = "Add New Report";
		$by 		= $_SESSION['user_id'];

		$db->autocommit(FALSE);

		$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='patient_report' ");

		if (mysqli_num_rows($res) > 0) {
			$row = $res->fetch_assoc();
			$sequence_number 	= $row['sequence_number'] + 1;
			$prefix 			= $row['prefix'];
			$bill_id 			= $row['bill_id'];

			$res = $db->query("UPDATE bill_setting SET

											sequence_number 	='$sequence_number',
											last_action 		='$lastaction',
											updated_at			='$reg_date',
											last_action_by		='$by'

									WHERE bill_id=$bill_id  ");
		} else {
			$sequence_number 	= 1;
			$prefix 			= '';
		}

		$report_reference_number = $prefix . $sequence_number;

		$sql = "INSERT INTO patient_report (	
										 	report_reference_number,
										 	present_complaint,
										 	past_medical_history,
										 	past_surgical_history,
										 	family_history,
										 	social_history,
										 	provisional_diagnosis,
										 	referral_to,
										 	reason_of_referral,
										 	report_note,
										 	discharge_summary,
										 	sequence_number,
										 	report_date,
										 	patient_id_fk,
										 	staff_id_fk,
										 	is_refferal,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by)
									VALUES( 
											'$report_reference_number',
											'$present_complaint',
											'$past_medical_history',
											'$past_surgical_history',
											'$family_history',
											'$social_history',
											'$provisional_diagnosis',
											'$referral_to',
											'$reason_of_referral',
											'$report_note',
											'$discharge_summary',
											'$sequence_number',
											'$report_date',
											'$patient_id_fk',
											'$by',
											'$is_refferal',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by')";
		$res = $db->query($sql);
		if ($res) {

			$id 		= 	$db->insert_id;

			$sql = "INSERT INTO patient_report_detail (	
										 	assessment,
										 	chest,
										 	abdomen,
										 	heart,
										 	cns,
										 	bp,
										 	pr,
										 	rr,
										 	temp,
										 	spo2,
										 	gcs,
										 	follow_up,
										 	follow_note,
										 	sick_leave,
										 	sick_leave_from,
										 	sick_leave_to,
										 	sick_leave_note,
										 	medical_report,
										 	patient_report_id_fk,
										 	patient_id_fk,
										 	staff_id_fk,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by)
									VALUES( 
											'$assessment',
											'$chest',
											'$abdomen',
											'$heart',
											'$cns',
											'$bp',
											'$pr',
											'$rr',
											'$temp',
											'$spo2',
											'$gcs',
											'$follow_up',
											'$follow_note',
											'$sick_leave',
											'$sick_leave_from',
											'$sick_leave_to',
											'$sick_leave_note',
											'$medical_report',
											'$id',
											'$patient_id_fk',
											'$by',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by')";

			$res = $db->query($sql);

			if (!$res) {
				loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
				$db->rollback();
				$op['is_success'] = false;
				$op['data'] 	  = "Error has been occur, Please check the input fields or reload the page and try again";
				echo json_encode($op);
				exit;
			}

			// Insert Invsetigation

			$index_num 				=	0;
			$inv_id 				=	0;
			$prev_type  			= 	'';
			$invoice_total_price 	=	0;

			if (isset($_POST['product_id_fk'])) {


				foreach ($_POST["product_id_fk"] as $product_id_fk) {

					$test_note 		= addslashes($_POST["test_note"][$index_num]);
					$test_type 		= $_POST["test_type"][$index_num];
					$cost 			= $_POST["cost"][$index_num];
					$sell 			= $_POST["sell"][$index_num];

					$index_num++;

					if ($product_id_fk > 0) {

						if ($prev_type != $test_type) {


							$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='$test_type' ");

							if (mysqli_num_rows($res) > 0) {
								$row = $res->fetch_assoc();
								$sequence_number 	= $row['sequence_number'] + 1;
								$prefix 			= $row['prefix'];
								$bill_id 			= $row['bill_id'];

								$res = $db->query("UPDATE bill_setting SET

														sequence_number 	='$sequence_number',
														last_action 		='$lastaction',
														updated_at			='$reg_date',
														last_action_by		='$by'

													WHERE bill_id=$bill_id  ");
							} else {
								$sequence_number 	= 1;
								$prefix 			= '';
							}

							$test_number = $prefix . $sequence_number;

							$sql = "INSERT INTO lab_test (	
															 	lab_test_date,
															 	test_type,
															 	patient_report_id_fk,
															 	patient_id_fk,
															 	staff_id_fk,
															 	sequence_number,
															 	test_number,
															 	
																created_by,
																created_at,
															    updated_at,
																last_action,
																last_action_by)
														VALUES( 
																'$report_date',
																'$test_type',
																'$id',
																'$patient_id_fk',
																'$by',
																'$sequence_number',
																'$test_number',
																
																'$by',
																'$reg_date',
																'$reg_date',
																'$lastaction',
																'$by')";
							$res = $db->query($sql);

							if ($res) {

								$idiv 		= 	$db->insert_id;
								$error = ImageUploader('lab_result_file', 'lab-file', 'lab_test', 'result_file', $idiv, 'lab_test_id', '');
							} else {

								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$op['data'] 	  = $db->error;
								$db->rollback();
								$op['is_success'] = false;
								echo json_encode($op);
								exit;
							}
						}

						$sql = "INSERT INTO 
		    						lab_test_detail 
		    						(	
									 	product_id_fk,
									 	test_note,
									 	cost,
									 	sell,
									 	lab_test_id_fk,
									 	patient_id_fk,
									 	patient_report_id_fk,
									 	
										created_by,
										created_at,
									    updated_at,
										last_action,
										last_action_by
									)
								VALUES
									( 
										'$product_id_fk',
										'$test_note',
										'$cost',
										'$sell',
										'$idiv',
										'$patient_id_fk',
										'$id',
										
										'$by',
										'$reg_date',
										'$reg_date',
										'$lastaction',
										'$by'
									)";

						$res = $db->query($sql);

						$in_id 		= 	$db->insert_id;


						loglog('Add', "patient_report", $id, "Added Successfully(lab-detail:$in_id:$product_id_fk)", 'patient_report.php');

						if (!$res) {
							loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
							$op['data'] 	  = $db->error;
							$db->rollback();
							$op['is_success'] = false;
							echo json_encode($op);
							exit;
						}

						// Add Invoice For Patient

						if ($prev_type != $test_type) {

							$v = 0;
							foreach ($_POST["product_id_fk"] as $p) {
								$invoice_total_price = $invoice_total_price + $_POST["sell"][$v];
								$v++;
							}

							$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='sell' ");

							if (mysqli_num_rows($res) > 0) {
								$row = $res->fetch_assoc();
								$sequence_number 	= $row['sequence_number'] + 1;
								$prefix 			= $row['prefix'];
								$bill_id 			= $row['bill_id'];

								$res = $db->query("UPDATE bill_setting SET

																sequence_number 	='$sequence_number',
																last_action 		='$lastaction',
																updated_at			='$reg_date',
																last_action_by		='$by'

														WHERE bill_id=$bill_id  ");
							} else {
								$sequence_number 	= 1;
								$prefix 			= '';
							}

							$invoice_number = $prefix . $sequence_number;

							$sql = "INSERT INTO sell (	
															 	invoice_number,
															 	invoice_year,
															 	invoice_date,
															 	invoice_type,
															 	pay_status,
															 	invoice_total_price,
															 	invoice_total_discount,
															 	sell_note,
															 	person_name,
															 	patient_id_fk,
															 	patient_report_id_fk,
															 	staff_id_fk,
															 	sequence_number,
															 	origin_table_name,

																created_by,
																created_at,
															    updated_at,
																last_action,
																last_action_by)
														VALUES( 
																'$invoice_number',
																'$invoice_year',
																'$report_date',
																'invoice',
																'0',
																'$invoice_total_price',
																'0',
																'Added From Patient Report',
																'',
																'$patient_id_fk',
																'$id',
																'$by',
																'$sequence_number',
																'patient_report',
																
																'$by',
																'$reg_date',
																'$reg_date',
																'$lastaction',
																'$by')";
							$res = $db->query($sql);

							if ($res) {
								$inv_id 		= 	$db->insert_id;
							} else {

								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$op['data'] 	  = $db->error;
								$db->rollback();
								$op['is_success'] = false;
								echo json_encode($op);
								exit;
							}
						}


						$cost_price 			= $cost;
						$product_unit_id_fk 	= 0;
						$unit_scale 			= 0;
						$product_type_id_fk 	= 0;
						$sell_quantity 			= 1;
						$sell_price 			= $sell;
						$discount 				= 0;
						$sell_detail_note 		= $test_note;
						$stock_id_fk 			= $_SESSION["default_stock_id_fk"];


						if ($product_id_fk > 0) {

							$sql = "INSERT INTO 
			    						sell_detail 
			    						(	
										 	product_id_fk,
										 	sell_quantity,
										 	sell_price,
										 	cost_price,
										 	discount,
										 	sell_detail_date,
										 	product_unit_id_fk,
										 	unit_scale,
										 	sell_detail_note,
										 	origin_from,
										 	stock_id_fk,
										 	product_type_id_fk,
										 	sell_id_fk,
										 	patient_report_id_fk,
										 	patient_id_fk,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by
										)
									VALUES
										( 
											'$product_id_fk',
											'$sell_quantity',
											'$sell_price',
											'$cost_price',
											'$discount',
											'$report_date',
											'$product_unit_id_fk',
											'$unit_scale',
											'$sell_detail_note',
											'lab_test',
											'$stock_id_fk',
											'$product_type_id_fk',
											'$inv_id',
											'$id',
											'$patient_id_fk',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by'
										)";

							$res = $db->query($sql);



							if ($res) {

								$id_sub 		= 	$db->insert_id;


								loglog('Add', "sell", $id, "Added Successfully(sell-detail:$id_sub:$product_id_fk)", 'patient_report.php');

								$stock_transaction 	= 'Sell';

								$primary_table 		= 'sell';
								$detail_table  		= 'sell_detail';
								$secondary_table  	= 'lab_test';


								$sql = "INSERT INTO product_stock (	
														 	recieved_quantity,
														 	stock_transaction,
														 	stock_transaction_type,
														 	transaction_date,
														 	sell_price,
														 	buy_price,
														 	primary_id_fk,
														 	primary_table,
														 	secondary_table,
														 	detail_id_fk,
														 	detail_table,
														 	product_id_fk,
														 	stock_id_fk,
														 	patient_report_id_fk,
														 	patient_id_fk,
										 	
										 	
															created_by,
															created_at,
														    updated_at,
															last_action,
															last_action_by)
													VALUES( 
															'$sell_quantity',
															'$stock_transaction',
															'2',
															'$report_date',
															'$sell_price',
															'$cost_price',
															'$inv_id',
															'$primary_table',
															'$secondary_table',
															'$id_sub',
															'$detail_table',
															'$product_id_fk',
															'$stock_id_fk',
															'$id',
															'$patient_id_fk',
															
															
															'$by',
															'$reg_date',
															'$reg_date',
															'$lastaction',
															'$by')";

								$res = $db->query($sql);

								if (!$res) {
									loglog('Fail Add', "product_stock", $inv_id, "$db->error", 'patient_report.php');

									$op['data'] 	  = $db->error;
									$db->rollback();
									$op['is_success'] = false;
									echo json_encode($op);
									exit;
								}
							} else {
								loglog('Fail Add', "sell", $inv_id, "$db->error", 'patient_report.php');
								$op['data'] 	  = $db->error;
								$db->rollback();
								$op['is_success'] = false;
								echo json_encode($op);
								exit;
							}
						}



						// End Invoice Adding
					}

					$prev_type  = $test_type;
				}
			}

			$index_num 	=	0;
			$prev_type  = '';

			if (isset($_POST['rad_product_id_fk'])) {

				foreach ($_POST["rad_product_id_fk"] as $product_id_fk) {

					$test_note 	= addslashes($_POST["rad_test_note"][$index_num]);
					$test_type 	= $_POST["rad_test_type"][$index_num];
					$cost 		= $_POST["rad_cost"][$index_num];
					$sell 		= $_POST["rad_sell"][$index_num];

					$index_num++;

					if ($product_id_fk > 0) {

						if ($prev_type != $test_type) {


							$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='$test_type' ");

							if (mysqli_num_rows($res) > 0) {
								$row = $res->fetch_assoc();
								$sequence_number 	= $row['sequence_number'] + 1;
								$prefix 			= $row['prefix'];
								$bill_id 			= $row['bill_id'];

								$res = $db->query("UPDATE bill_setting SET

														sequence_number 	='$sequence_number',
														last_action 		='$lastaction',
														updated_at			='$reg_date',
														last_action_by		='$by'

													WHERE bill_id=$bill_id  ");
							} else {
								$sequence_number 	= 1;
								$prefix 			= '';
							}

							$test_number = $prefix . $sequence_number;

							$sql = "INSERT INTO radiology_test (	
															 	radiology_test_date,
															 	test_type,
															 	patient_report_id_fk,
															 	patient_id_fk,
															 	staff_id_fk,
															 	sequence_number,
															 	test_number,
															 	
																created_by,
																created_at,
															    updated_at,
																last_action,
																last_action_by)
														VALUES( 
																'$report_date',
																'$test_type',
																'$id',
																'$patient_id_fk',
																'$by',
																'$sequence_number',
																'$test_number',
																
																'$by',
																'$reg_date',
																'$reg_date',
																'$lastaction',
																'$by')";
							$res = $db->query($sql);

							if ($res) {

								$idiv 		= 	$db->insert_id;
								$error = ImageUploader('rad_result_file', 'rad-file', 'radiology_test', 'result_file', $idiv, 'radiology_test_id', '');
							} else {

								loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
								$db->rollback();
								$op['is_success'] = false;
								$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
								echo json_encode($op);
								exit;
							}
						}

						$sql = "INSERT INTO 
		    						radiology_test_detail 
		    						(	
									 	product_id_fk,
									 	test_note,
									 	cost,
									 	sell,
									 	radiology_test_id_fk,
									 	patient_id_fk,
									 	patient_report_id_fk,
									 	
										created_by,
										created_at,
									    updated_at,
										last_action,
										last_action_by
									)
								VALUES
									( 
										'$product_id_fk',
										'$test_note',
										'$cost',
										'$sell',
										'$idiv',
										'$patient_id_fk',
										'$id',
										
										'$by',
										'$reg_date',
										'$reg_date',
										'$lastaction',
										'$by'
									)";

						$res = $db->query($sql);

						$in_id 		= 	$db->insert_id;


						loglog('Add', "patient_report", $id, "Added Successfully(lab-detail:$in_id:$product_id_fk)", 'patient_report.php');

						if (!$res) {
							loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
							$db->rollback();
							$op['is_success'] = false;
							$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
							echo json_encode($op);
							exit;
						}


						// Add Invoice For Patient
						if ($inv_id == 0) {

							if ($prev_type != $test_type) {

								$invoice_total_price = 0;
								$v = 0;
								foreach ($_POST["rad_product_id_fk"] as $rr) {
									$invoice_total_price = $invoice_total_price + $_POST["rad_sell"][$v];
									$v++;
								}

								$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='sell' ");

								if (mysqli_num_rows($res) > 0) {
									$row = $res->fetch_assoc();
									$sequence_number 	= $row['sequence_number'] + 1;
									$prefix 			= $row['prefix'];
									$bill_id 			= $row['bill_id'];

									$res = $db->query("UPDATE bill_setting SET

																	sequence_number 	='$sequence_number',
																	last_action 		='$lastaction',
																	updated_at			='$reg_date',
																	last_action_by		='$by'

															WHERE bill_id=$bill_id  ");
								} else {
									$sequence_number 	= 1;
									$prefix 			= '';
								}

								$invoice_number = $prefix . $sequence_number;

								$sql = "INSERT INTO sell (	
																 	invoice_number,
																 	invoice_year,
																 	invoice_date,
																 	invoice_type,
																 	pay_status,
																 	invoice_total_price,
																 	invoice_total_discount,
																 	sell_note,
																 	person_name,
																 	patient_id_fk,
																 	patient_report_id_fk,
																 	staff_id_fk,
																 	sequence_number,
																 	origin_table_name,

																	created_by,
																	created_at,
																    updated_at,
																	last_action,
																	last_action_by)
															VALUES( 
																	'$invoice_number',
																	'$invoice_year',
																	'$report_date',
																	'invoice',
																	'0',
																	'$invoice_total_price',
																	'0',
																	'Added From Patient Report',
																	'',
																	'$patient_id_fk',
																	'$id',
																	'$by',
																	'$sequence_number',
																	'patient_report',
																	
																	'$by',
																	'$reg_date',
																	'$reg_date',
																	'$lastaction',
																	'$by')";
								$res = $db->query($sql);

								if ($res) {
									$inv_id 		= 	$db->insert_id;
								} else {

									loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
									$db->rollback();
									$op['is_success'] = false;
									$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
									echo json_encode($op);
									exit;
								}
							}
						} else {

							if ($prev_type != $test_type) {
								$v = 0;
								foreach ($_POST["rad_product_id_fk"] as $rr) {
									$invoice_total_price = $invoice_total_price + $_POST["rad_sell"][$v];
									$v++;
								}

								$res = $db->query("UPDATE sell SET 		
				      						invoice_total_price 	= $invoice_total_price,
				      						last_action				= '$lastaction',
				      						updated_at				= '$reg_date',
				      						last_action_by			= '$by' 
			      						WHERE sell_id 				=$inv_id");
							}
						}

						$cost_price 			= $cost;
						$product_unit_id_fk 	= 0;
						$unit_scale 			= 0;
						$product_type_id_fk 	= 0;
						$sell_quantity 			= 1;
						$sell_price 			= $sell;
						$discount 				= 0;
						$sell_detail_note 		= $test_note;
						$stock_id_fk 			= $_SESSION["default_stock_id_fk"];


						if ($product_id_fk > 0) {

							$sql = "INSERT INTO 
			    						sell_detail 
			    						(	
										 	product_id_fk,
										 	sell_quantity,
										 	sell_price,
										 	cost_price,
										 	discount,
										 	sell_detail_date,
										 	product_unit_id_fk,
										 	unit_scale,
										 	sell_detail_note,
										 	origin_from,
										 	stock_id_fk,
										 	product_type_id_fk,
										 	sell_id_fk,
										 	patient_report_id_fk,
										 	patient_id_fk,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by
										)
									VALUES
										( 
											'$product_id_fk',
											'$sell_quantity',
											'$sell_price',
											'$cost_price',
											'$discount',
											'$report_date',
											'$product_unit_id_fk',
											'$unit_scale',
											'$sell_detail_note',
											'radiology_test',
											'$stock_id_fk',
											'$product_type_id_fk',
											'$inv_id',
											'$id',
											'$patient_id_fk',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by'
										)";

							$res = $db->query($sql);



							if ($res) {

								$id_sub 		= 	$db->insert_id;


								loglog('Add', "sell", $id, "Added Successfully(sell-detail:$id_sub:$product_id_fk)", 'patient_report.php');

								$stock_transaction 	= 'Sell';

								$primary_table 		= 'sell';
								$detail_table  		= 'sell_detail';
								$secondary_table  	= 'radiology_test';


								$sql = "INSERT INTO product_stock (	
														 	recieved_quantity,
														 	stock_transaction,
														 	stock_transaction_type,
														 	transaction_date,
														 	sell_price,
														 	buy_price,
														 	primary_id_fk,
														 	primary_table,
														 	secondary_table,
														 	detail_id_fk,
														 	detail_table,
														 	product_id_fk,
														 	stock_id_fk,
														 	patient_report_id_fk,
														 	patient_id_fk,
										 	
										 	
															created_by,
															created_at,
														    updated_at,
															last_action,
															last_action_by)
													VALUES( 
															'$sell_quantity',
															'$stock_transaction',
															'2',
															'$report_date',
															'$sell_price',
															'$cost_price',
															'$inv_id',
															'$primary_table',
															'$secondary_table',
															'$id_sub',
															'$detail_table',
															'$product_id_fk',
															'$stock_id_fk',
															'$id',
															'$patient_id_fk',
															
															
															'$by',
															'$reg_date',
															'$reg_date',
															'$lastaction',
															'$by')";

								$res = $db->query($sql);

								if (!$res) {
									loglog('Fail Add', "product_stock", $inv_id, "$db->error", 'patient_report.php');

									$db->rollback();
									$op['is_success'] = false;
									$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
									echo json_encode($op);
									exit;
								}
							} else {
								loglog('Fail Add', "sell", $inv_id, "$db->error", 'patient_report.php');
								$db->rollback();
								$op['is_success'] = false;
								$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
								echo json_encode($op);
								exit;
							}
						}



						// End Invoice Adding
					}

					$prev_type  = $test_type;
				}
			}


			$index_num 	=	0;
			$prev_type  = '';

			if (isset($_POST['consul_product_id_fk'])) {

				foreach ($_POST["consul_product_id_fk"] as $product_id_fk) {

					$sell_detail_note	= addslashes($_POST["consul_note"][$index_num]);
					$test_type 			= $_POST["consul_test_type"][$index_num];
					$cost 				= $_POST["consul_cost"][$index_num];
					$sell 				= $_POST["consul_sell"][$index_num];
					$consultant_name 	= addslashes($_POST["consultant_name"][$index_num]);
					$sell_detail_date	= $_POST["consul_date"][$index_num];

					$index_num++;

					if ($product_id_fk > 0) {

						// Add Invoice For Patient
						if ($inv_id == 0) {

							if ($prev_type != $test_type) {

								$invoice_total_price = 0;
								$v = 0;
								foreach ($_POST["consul_product_id_fk"] as $rr) {
									$invoice_total_price = $invoice_total_price + $_POST["consul_sell"][$v];
									$v++;
								}

								$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='sell' ");

								if (mysqli_num_rows($res) > 0) {
									$row = $res->fetch_assoc();
									$sequence_number 	= $row['sequence_number'] + 1;
									$prefix 			= $row['prefix'];
									$bill_id 			= $row['bill_id'];

									$res = $db->query("UPDATE bill_setting SET

																	sequence_number 	='$sequence_number',
																	last_action 		='$lastaction',
																	updated_at			='$reg_date',
																	last_action_by		='$by'

															WHERE bill_id=$bill_id  ");
								} else {
									$sequence_number 	= 1;
									$prefix 			= '';
								}

								$invoice_number = $prefix . $sequence_number;

								$sql = "INSERT INTO sell (	
																 	invoice_number,
																 	invoice_year,
																 	invoice_date,
																 	invoice_type,
																 	pay_status,
																 	invoice_total_price,
																 	invoice_total_discount,
																 	sell_note,
																 	person_name,
																 	patient_id_fk,
																 	patient_report_id_fk,
																 	staff_id_fk,
																 	sequence_number,
																 	origin_table_name,

																	created_by,
																	created_at,
																    updated_at,
																	last_action,
																	last_action_by)
															VALUES( 
																	'$invoice_number',
																	'$invoice_year',
																	'$report_date',
																	'invoice',
																	'0',
																	'$invoice_total_price',
																	'0',
																	'Added From Patient Report',
																	'',
																	'$patient_id_fk',
																	'$id',
																	'$by',
																	'$sequence_number',
																	'patient_report',
																	
																	'$by',
																	'$reg_date',
																	'$reg_date',
																	'$lastaction',
																	'$by')";
								$res = $db->query($sql);

								if ($res) {
									$inv_id 		= 	$db->insert_id;
								} else {

									loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
									$db->rollback();
									$op['is_success'] = false;
									$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
									echo json_encode($op);
									exit;
								}
							}
						} else {

							if ($prev_type != $test_type) {
								$v = 0;
								foreach ($_POST["consul_product_id_fk"] as $rr) {
									$invoice_total_price = $invoice_total_price + $_POST["consul_sell"][$v];
									$v++;
								}

								$res = $db->query("UPDATE sell SET 		
				      						invoice_total_price 	= $invoice_total_price,
				      						last_action				= '$lastaction',
				      						updated_at				= '$reg_date',
				      						last_action_by			= '$by' 
			      						WHERE sell_id 				=$inv_id");
							}
						}

						$cost_price 			= $cost;
						$product_unit_id_fk 	= 0;
						$unit_scale 			= 0;
						$product_type_id_fk 	= 0;
						$sell_quantity 			= 1;
						$sell_price 			= $sell;
						$discount 				= 0;
						$stock_id_fk 			= $_SESSION["default_stock_id_fk"];


						if ($product_id_fk > 0) {

							$sql = "INSERT INTO 
			    						sell_detail 
			    						(	
										 	product_id_fk,
										 	sell_quantity,
										 	sell_price,
										 	cost_price,
										 	discount,
										 	sell_detail_date,
										 	product_unit_id_fk,
										 	unit_scale,
										 	sell_detail_note,
										 	origin_from,
										 	stock_id_fk,
										 	product_type_id_fk,
										 	sell_id_fk,
										 	patient_report_id_fk,
										 	patient_id_fk,
										 	consultant_name,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by
										)
									VALUES
										( 
											'$product_id_fk',
											'$sell_quantity',
											'$sell_price',
											'$cost_price',
											'$discount',
											'$sell_detail_date',
											'$product_unit_id_fk',
											'$unit_scale',
											'$sell_detail_note',
											'consultation',
											'$stock_id_fk',
											'$product_type_id_fk',
											'$inv_id',
											'$id',
											'$patient_id_fk',
											'$consultant_name',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by'
										)";

							$res = $db->query($sql);



							if ($res) {

								$id_sub 		= 	$db->insert_id;


								loglog('Add', "sell", $id, "Added Successfully(sell-detail:$id_sub:$product_id_fk)", 'patient_report.php');

								$stock_transaction 	= 'Sell';

								$primary_table 		= 'sell';
								$detail_table  		= 'sell_detail';
								$secondary_table  	= 'consultation';


								$sql = "INSERT INTO product_stock (	
														 	recieved_quantity,
														 	stock_transaction,
														 	stock_transaction_type,
														 	transaction_date,
														 	sell_price,
														 	buy_price,
														 	primary_id_fk,
														 	primary_table,
														 	secondary_table,
														 	detail_id_fk,
														 	detail_table,
														 	product_id_fk,
														 	stock_id_fk,
														 	patient_report_id_fk,
														 	patient_id_fk,
										 	
										 	
															created_by,
															created_at,
														    updated_at,
															last_action,
															last_action_by)
													VALUES( 
															'$sell_quantity',
															'$stock_transaction',
															'2',
															'$report_date',
															'$sell_price',
															'$cost_price',
															'$inv_id',
															'$primary_table',
															'$secondary_table',
															'$id_sub',
															'$detail_table',
															'$product_id_fk',
															'$stock_id_fk',
															'$id',
															'$patient_id_fk',
															
															
															'$by',
															'$reg_date',
															'$reg_date',
															'$lastaction',
															'$by')";

								$res = $db->query($sql);

								if (!$res) {
									loglog('Fail Add', "product_stock", $inv_id, "$db->error", 'patient_report.php');

									$db->rollback();
									$op['is_success'] = false;
									$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
									echo json_encode($op);
									exit;
								}
							} else {
								loglog('Fail Add', "sell", $inv_id, "$db->error", 'patient_report.php');
								$db->rollback();
								$op['is_success'] = false;
								$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
								echo json_encode($op);
								exit;
							}
						}



						// End Invoice Adding
					}

					$prev_type  = $test_type;
				}
			}


			$index_num 	=	0;
			$prev_type  = '';

			if (isset($_POST['serv_product_id_fk'])) {

				foreach ($_POST["serv_product_id_fk"] as $product_id_fk) {

					$sell_detail_note	= addslashes($_POST["serv_note"][$index_num]);
					$test_type 			= $_POST["serv_test_type"][$index_num];
					$cost 				= $_POST["serv_cost"][$index_num];
					$sell 				= $_POST["serv_sell"][$index_num];
					$consultant_name 	= addslashes($_POST["serv_consultant_name"][$index_num]);
					$sell_detail_date	= $_POST["serv_date"][$index_num];

					$sell_quantity      = $_POST["serv_sell_quantity"][$index_num];

					$index_num++;

					if ($product_id_fk > 0) {

						// Add Invoice For Patient
						if ($inv_id == 0) {

							if ($prev_type != $test_type) {

								$invoice_total_price = 0;
								$v = 0;
								foreach ($_POST["serv_product_id_fk"] as $rr) {
									$invoice_total_price = $invoice_total_price + ($_POST["serv_sell"][$v] * $_POST["serv_sell_quantity"][$v]);
									$v++;
								}

								$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='sell' ");

								if (mysqli_num_rows($res) > 0) {
									$row = $res->fetch_assoc();
									$sequence_number 	= $row['sequence_number'] + 1;
									$prefix 			= $row['prefix'];
									$bill_id 			= $row['bill_id'];

									$res = $db->query("UPDATE bill_setting SET

																	sequence_number 	='$sequence_number',
																	last_action 		='$lastaction',
																	updated_at			='$reg_date',
																	last_action_by		='$by'

															WHERE bill_id=$bill_id  ");
								} else {
									$sequence_number 	= 1;
									$prefix 			= '';
								}

								$invoice_number = $prefix . $sequence_number;

								$sql = "INSERT INTO sell (	
																 	invoice_number,
																 	invoice_year,
																 	invoice_date,
																 	invoice_type,
																 	pay_status,
																 	invoice_total_price,
																 	invoice_total_discount,
																 	sell_note,
																 	person_name,
																 	patient_id_fk,
																 	patient_report_id_fk,
																 	staff_id_fk,
																 	sequence_number,
																 	origin_table_name,

																	created_by,
																	created_at,
																    updated_at,
																	last_action,
																	last_action_by)
															VALUES( 
																	'$invoice_number',
																	'$invoice_year',
																	'$report_date',
																	'invoice',
																	'0',
																	'$invoice_total_price',
																	'0',
																	'Added From Patient Report',
																	'',
																	'$patient_id_fk',
																	'$id',
																	'$by',
																	'$sequence_number',
																	'patient_report',
																	
																	'$by',
																	'$reg_date',
																	'$reg_date',
																	'$lastaction',
																	'$by')";
								$res = $db->query($sql);

								if ($res) {
									$inv_id 		= 	$db->insert_id;
								} else {

									loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
									$db->rollback();
									$op['is_success'] = false;
									$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
									echo json_encode($op);
									exit;
								}
							}
						} else {

							if ($prev_type != $test_type) {
								$v = 0;
								foreach ($_POST["serv_product_id_fk"] as $rr) {
									$invoice_total_price = $invoice_total_price + ($_POST["serv_sell"][$v] * $_POST["serv_sell_quantity"][$v]);
									$v++;
								}

								$res = $db->query("UPDATE sell SET 		
				      						invoice_total_price 	= $invoice_total_price,
				      						last_action				= '$lastaction',
				      						updated_at				= '$reg_date',
				      						last_action_by			= '$by' 
			      						WHERE sell_id 				=$inv_id");
							}
						}

						$cost_price 			= $cost;
						$product_unit_id_fk 	= 0;
						$unit_scale 			= 0;
						$product_type_id_fk 	= 0;
						// $sell_quantity 			=1;
						$sell_price 			= $sell;
						$discount 				= 0;
						$stock_id_fk 			= $_SESSION["default_stock_id_fk"];


						if ($product_id_fk > 0) {

							$sql = "INSERT INTO 
			    						sell_detail 
			    						(	
										 	product_id_fk,
										 	sell_quantity,
										 	sell_price,
										 	cost_price,
										 	discount,
										 	sell_detail_date,
										 	product_unit_id_fk,
										 	unit_scale,
										 	sell_detail_note,
										 	origin_from,
										 	stock_id_fk,
										 	product_type_id_fk,
										 	sell_id_fk,
										 	patient_report_id_fk,
										 	patient_id_fk,
										 	consultant_name,

											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by
										)
									VALUES
										( 
											'$product_id_fk',
											'$sell_quantity',
											'$sell_price',
											'$cost_price',
											'$discount',
											'$sell_detail_date',
											'$product_unit_id_fk',
											'$unit_scale',
											'$sell_detail_note',
											'procedure',
											'$stock_id_fk',
											'$product_type_id_fk',
											'$inv_id',
											'$id',
											'$patient_id_fk',
											'$consultant_name',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by'
										)";

							$res = $db->query($sql);



							if ($res) {

								$id_sub 		= 	$db->insert_id;


								loglog('Add', "sell", $id, "Added Successfully(sell-detail:$id_sub:$product_id_fk)", 'patient_report.php');

								$stock_transaction 	= 'Sell';

								$primary_table 		= 'sell';
								$detail_table  		= 'sell_detail';
								$secondary_table  	= 'procedure';


								$sql = "INSERT INTO product_stock (	
														 	recieved_quantity,
														 	stock_transaction,
														 	stock_transaction_type,
														 	transaction_date,
														 	sell_price,
														 	buy_price,
														 	primary_id_fk,
														 	primary_table,
														 	secondary_table,
														 	detail_id_fk,
														 	detail_table,
														 	product_id_fk,
														 	stock_id_fk,
														 	patient_report_id_fk,
														 	patient_id_fk,
										 	
										 	
															created_by,
															created_at,
														    updated_at,
															last_action,
															last_action_by)
													VALUES( 
															'$sell_quantity',
															'$stock_transaction',
															'2',
															'$report_date',
															'$sell_price',
															'$cost_price',
															'$inv_id',
															'$primary_table',
															'$secondary_table',
															'$id_sub',
															'$detail_table',
															'$product_id_fk',
															'$stock_id_fk',
															'$id',
															'$patient_id_fk',
															
															
															'$by',
															'$reg_date',
															'$reg_date',
															'$lastaction',
															'$by')";

								$res = $db->query($sql);

								if (!$res) {
									loglog('Fail Add', "product_stock", $inv_id, "$db->error", 'patient_report.php');

									$db->rollback();
									$op['is_success'] = false;
									$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
									echo json_encode($op);
									exit;
								}
							} else {
								loglog('Fail Add', "sell", $inv_id, "$db->error", 'patient_report.php');
								$db->rollback();
								$op['is_success'] = false;
								$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
								echo json_encode($op);
								exit;
							}
						}



						// End Invoice Adding
					}

					$prev_type  = $test_type;
				}
			}




			$index_num 	=	0;

			if (isset($_POST['medicine_name'])) {

				// foreach ($_POST["treat_product_id_fk"] as $product_id_fk) {
				foreach ($_POST["medicine_name"] as $medicine_name1) {

					$treat_form_id_fk 			= isset($_POST["treat_form_id_fk"][$index_num]) ? $_POST["treat_form_id_fk"][$index_num] : 0;
					$dose 						= isset($_POST["dose"][$index_num]) ? addslashes($_POST["dose"][$index_num]) : '';
					$treat_route_id_fk 			= isset($_POST["treat_route_id_fk"][$index_num]) ? $_POST["treat_route_id_fk"][$index_num] : 0;
					$treat_frequency_id_fk 		= isset($_POST["treat_frequency_id_fk"][$index_num]) ? $_POST["treat_frequency_id_fk"][$index_num] : 0;
					$treat_note 				= isset($_POST["treat_note"][$index_num]) ? addslashes($_POST["treat_note"][$index_num]) : '';



					$index_num++;

					if ($medicine_name1 != "") {

						$medicine_name 				= addslashes($medicine_name1);

						$sql = "INSERT INTO 
		    						patient_treatment 
		    						(	
									 	treatment_date,
									 	medicine_name,
									 	treat_form_id_fk,
									 	dose,
									 	treat_route_id_fk,
									 	treat_frequency_id_fk,
									 	treat_note,
									 	patient_report_id_fk,
									 	patient_id_fk,
									 	staff_id_fk,
									 	
										created_by,
										created_at,
									    updated_at,
										last_action,
										last_action_by
									)
								VALUES
									( 
										'$report_date',
										'$medicine_name',
										'$treat_form_id_fk',
										'$dose',
										'$treat_route_id_fk',
										'$treat_frequency_id_fk',
										'$treat_note',
										'$id',
										'$patient_id_fk',
										'$by',
										
										'$by',
										'$reg_date',
										'$reg_date',
										'$lastaction',
										'$by'
									)";

						$res = $db->query($sql);

						$in_id 		= 	$db->insert_id;

						$product_id_fk = isset($product_id_fk) ? $product_id_fk : null;
						loglog('Add', "patient_treatment", $id, "Added Successfully(patient_treatment:$in_id:$product_id_fk)", 'patient_report.php');

						if (!$res) {
							loglog('Fail Add', "patient_treatment", $id, "$db->error", 'patient_report.php');
							$db->rollback();
							$op['is_success'] = false;
							$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
							echo json_encode($op);
							exit;
						}
					}
				}
			}

			$index_num 	=	0;

			if (isset($_POST['report_note_tour'])) {

				foreach ($_POST["report_note_tour"] as $report_note_tour1) {

					$noter_name = isset($_POST["noter_name"][$index_num]) ? addslashes($_POST["noter_name"][$index_num]) : '';
					$note_date 	= isset($_POST["note_date"][$index_num]) ? $_POST["note_date"][$index_num] : $reg_date;
					$note_type 	= isset($_POST["note_type"][$index_num]) ? $_POST["note_type"][$index_num] : 0;



					if ($report_note_tour1 != '') {
						$report_note_tour 				= addslashes($report_note_tour1);

						$sql = "INSERT INTO 
		    						patient_report_note 
		    						(	
									 	report_note_tour,
									 	noter_name,
									 	note_date,
									 	note_type,
									 	patient_report_id_fk,
									 	patient_id_fk,
									 	staff_id_fk,
									 	
										created_by,
										created_at,
									    updated_at,
										last_action,
										last_action_by
									)
								VALUES
									( 
										'$report_note_tour',
										'$noter_name',
										'$note_date',
										'$note_type',
										'$id',
										'$patient_id_fk',
										'$by',
										
										'$by',
										'$reg_date',
										'$reg_date',
										'$lastaction',
										'$by'
									)";

						$res = $db->query($sql);

						$in_id 		= 	$db->insert_id;

						$error = ImageUploaderSingleArray('note_file', 'note-file', 'patient_report_note', 'note_file', $in_id, 'note_id', '', $index_num, $in_id);


						loglog('Add', "patient_report", $id, "Added Successfully(patient_Note:$in_id:$report_note)", 'patient_report.php');

						if (!$res) {
							loglog('Fail Add', "patient_report", $id, "$db->error", 'patient_report.php');
							$db->rollback();
							$op['is_success'] = false;
							$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
							echo json_encode($op);
							exit;
						}
					}
					$index_num++;
				}
			}

			loglog('Add', 'patient_report', $id, "Added Successfully ($report_reference_number)", 'patient_report.php');

			if ($is_refferal == 1) {
				$sql = "INSERT INTO patient_refferal (	
										 	referred_to,
										 	clinc_site_name,
										 	chief_complaint,
										 	reason_for_refferal,
										 	refferal_note,
										 	patient_report_id_fk,
										 	
										 	refferal_date,
										 	patient_id_fk,
										 	staff_id_fk,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by)
									VALUES( 
											'$referred_to',
											'$clinc_site_name',
											'$chief_complaint',
											'$reason_for_refferal',
											'$refferal_note',
											'$id',
											
											'$report_date',
											'$patient_id_fk',
											'$by',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by')";
				$res = $db->query($sql);
				if (!$res) {
					loglog('Fail Add', 'patient_refferal', 0, "Failed Add Patient Refferal ($report_reference_number) Error:($db->error)", 'patient_report.php');

					$db->rollback();
					$op['is_success'] = false;
					$op['data'] 	  = $db->error;
					echo json_encode($op);
					exit;
				}
			}

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	  = "Added Successfully";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Add', 'patient_report', 0, "Failed Add Patient Report ($report_reference_number) Error:($db->error)", 'patient_report.php');

			$op['data'] 	  = "Error has been occure, Please check the input fields or reload the page and try again";
			$db->rollback();
			$op['is_success'] = false;
			echo json_encode($op);
			exit;
		}
	}
} else {
	header("Location:../");
	exit;
}
?>