<?php
if (!isset($_SESSION)) {
    session_start();
}
if (!isset($_SESSION['is_login'])) {
    header("location: login.php");
?>
    <script>
        window.location = "login.php";
    </script>
<?php
}


date_default_timezone_set($_SESSION['system_time_zone']);
require_once __DIR__ . '/vendor/autoload.php';
use Mpdf\Mpdf;
    // print_r($_GET);

if (isset($_POST['type']) || isset($_GET['type'])) {
    require_once "db_connect.php";

    function fixLineBreaks($content) {
    	return preg_replace('/(\r\n|\n|\r)/', '<br/>', $content);
	}
    

    if ($_GET['type'] == "pdf_lab") {

        $id = $_GET['edited_id'];
        $checkupid = $_GET['checkup_id'];
        $columnID = $checkupid > 0 ? 'patient_checkup_id_fk' : 'patient_report_id_fk';
        $op  = array('is_success' => false, 'data' => array(), 'detail' => array(), 'sell_detail' => array(), 'normal' => array());





        $res = $db->query("SELECT
                                        lab_test_id,
                                        lab_test_date,
                                        sell_id,
                                        sample_recieved_on,
                                        sample_reported_on,
                                        result_note,
                                        result_conclusion,
                                        lab_test_status,
                                        PI.patient_id_fk,
                                        PI.staff_id_fk,
                                        to_doctor,
                                        IFNULL(S.full_name,to_doctor) as site_doctor,
                                        IFNULL(S2.full_name,'') as lab_doctor,
                                        lab_test_detail_id,
                                        PID.product_id_fk,
                                        product_name,
                                        test_note,
                                        test_number,
                                        cost,
                                        sell,
                                        test_result,
                                        test_status,
                                        patient_full_name,
                                        patient_phone,
                                        gender,
                                        patient_date_of_birth,
                                        (
											year(curdate())
											-
										 	year(patient_date_of_birth) 
										) AS age,
                                        blood_group,
                                        allergies,
                                        IFNULL(company_name,'') as company_name,
                                        occupation,
                                        reference_value,
                                        test_unit,
                                        attach_file,
                                        PI.patient_report_id_fk,
                                        PI.patient_checkup_id_fk,
                                        PID.created_by,
                                        P.insurance,
                                        P.company_id_fk,
                                        insurance_company_name


                                FROM lab_test PI 
                                
                                LEFT JOIN patient P ON (PI.patient_id_fk = P.patient_id)    
                                LEFT JOIN company C ON (P.company_id_fk = C.company_id) 
                                LEFT JOIN insurance_company IC ON (P.insurance_company_id_fk = IC.insurance_company_id )
                                LEFT JOIN lab_test_detail PID ON (PI.lab_test_id = PID.lab_test_id_fk)  
                                LEFT JOIN product PD ON (PID.product_id_fk = PD.product_id) 
                                LEFT JOIN sell SL ON ((SL.sell_id = PI.sell_id_fk AND PI.sell_id_fk >0) OR (PI.$columnID = SL.$columnID AND PI.$columnID>0) OR (origin_table_name='lab_test' AND origin_id_fk =$id))
                                LEFT JOIN staff S ON (PI.staff_id_fk = S.staff_id)  
                                LEFT JOIN staff S2 ON (PI.created_by = S2.staff_id) 

                                WHERE PI.is_deleted = 0 AND PID.is_deleted=0 AND PI.lab_test_id = $id 

                                ");

        if ($res) {

            while ($row = $res->fetch_assoc()) {


                $result['lab_test_id']              = $row['lab_test_id'];
                $result['lab_test_date']            = $row['lab_test_date'];
                $result['sample_recieved_on']       = $row['sample_recieved_on'];
                $result['sample_reported_on']       = $row['sample_reported_on'];
                $result['result_note']              = $row['result_note'];
                $result['result_conclusion']        = $row['result_conclusion'];
                $result['lab_test_status']          = $row['lab_test_status'];
                $result['patient_id_fk']            = $row['patient_id_fk'];
                $result['staff_id_fk']              = $row['staff_id_fk'];
                $result['to_doctor']                = $row['to_doctor'];
                $result['patient_full_name']        = $row['patient_full_name'];
                $result['patient_phone']            = $row['patient_phone'];
                $result['lab_test_detail_id']       = $row['lab_test_detail_id'];
                $result['product_id_fk']            = $row['product_id_fk'];
                $result['product_name']             = $row['product_name'];
                $result['test_unit']                = $row['test_unit'];
                $result['reference_value']          = htmlspecialchars($row['reference_value']);
                $result['test_note']                = $row['test_note'];
                $result['cost']                     = $row['cost'];
                $result['sell']                     = $row['sell'];
                $result['test_result']              = $row['test_result'];
                $result['test_status']              = $row['test_status'];
                $result['patient_report_id_fk']     = $row['patient_report_id_fk'];
                $result['patient_checkup_id_fk']    = $row['patient_checkup_id_fk'];
                $result['site_doctor']              = $row['site_doctor'];
                $result['test_number']              = $row['test_number'];
                $result['lab_doctor']               = $row['lab_doctor'];
                $result['gender']                   = $row['gender'];
                $result['patient_date_of_birth']    = $row['patient_date_of_birth'];
                $result['blood_group']              = $row['blood_group'];
                $result['allergies']                = $row['allergies'];
                $result['company_name']             = $row['company_name'];
                $result['occupation']               = $row['occupation'];
                $result['attach_file']              = $row['attach_file'];
                $result['created_by']               = $row['created_by'];
                $result['sell_id']                  = $row['sell_id'];
                $result['insurance']                = $row['insurance'];
                $result['company_id_fk']            = $row['company_id_fk'];
                $result['insurance_company_name']   = $row['insurance_company_name'];
                $result['age']   					= $row['age'];
                $sell_id                            = $row['sell_id'];

                $result['lab_test_date_only'] = !empty($row['sample_recieved_on']) ? date("Y-m-d", strtotime($row['sample_recieved_on'])) : null;
                $result['lab_test_date_time'] = !empty($row['sample_recieved_on']) ? date("h:i A", strtotime($row['sample_recieved_on'])) : null;

                $result['lab_test_date_report_only'] = !empty($row['sample_reported_on']) ? date("Y-m-d", strtotime($row['sample_reported_on'])) : null;
                $result['lab_test_date_report_time'] = !empty($row['sample_reported_on']) ? date("h:i A", strtotime($row['sample_reported_on'])) : null;

                array_push($op['data'], $result);
            }

            $res = $db->query("SELECT
                                        
                                        lab_test_detail_item_id,
                                        LTDI.item_test_note,
                                        LTDI.item_test_result,
                                        product_detail_id_fk,
                                        lab_test_detail_id_fk,
                                        product_detail_id,
                                        product_detail_name,
                                        detail_test_unit,
                                        detail_reference_value

                                    FROM lab_test_detail_item LTDI  

                                    LEFT JOIN product_detail PD ON (PD.product_detail_id = LTDI.product_detail_id_fk AND PD.is_deleted=0)   
                                
                                    WHERE LTDI.is_deleted = 0  AND LTDI.lab_test_id_fk = $id 

                                ");

            while ($row = $res->fetch_assoc()) {



                $result2['lab_test_detail_item_id'] = $row['lab_test_detail_item_id'];
                $result2['item_test_note']          = $row['item_test_note'];
                $result2['item_test_result']        = $row['item_test_result'];
                $result2['product_detail_id_fk']    = $row['product_detail_id_fk'];
                $result2['product_detail_id']       = $row['product_detail_id'];
                $result2['product_detail_name']     = $row['product_detail_name'];
                $result2['detail_test_unit']        = $row['detail_test_unit'];
                $result2['detail_reference_value']  = $row['detail_reference_value'];
                $result2['lab_test_detail_id_fk']   = $row['lab_test_detail_id_fk'];

                array_push($op['detail'], $result2);
            }

            $res = $db->query("SELECT
                                        
                                        sell_detail_id,
                                        sell_id_fk,
                                        product_id_fk

                                    FROM sell_detail SD     

                                
                                    WHERE SD.is_deleted = 0  AND SD.sell_id_fk = $sell_id AND origin_from='lab_test'; 

                                ");

            while ($row = $res->fetch_assoc()) {



                $result4['sell_detail_id']      = $row['sell_detail_id'];
                $result4['sell_id_fk']          = $row['sell_id_fk'];
                $result4['product_id_fk']       = $row['product_id_fk'];

                array_push($op['sell_detail'], $result4);
            }

            // In case of Detail where not inserted we will display this
            $res = $db->query("SELECT
                                        
                                        lab_test_detail_id,
                                        product_detail_id,
                                        product_detail_name,
                                        detail_test_unit,
                                        detail_reference_value,
                                        LTD.product_id_fk

                                    FROM lab_test_detail LTD    

                                    LEFT JOIN product_detail PD ON (PD.product_id_fk = LTD.product_id_fk )  
                                
                                    WHERE LTD.is_deleted = 0 AND PD.is_deleted=0 AND LTD.lab_test_id_fk = $id 

                                ");

            while ($row = $res->fetch_assoc()) {

                $result3['lab_test_detail_id']      = $row['lab_test_detail_id'];
                $result3['product_id_fk']           = $row['product_id_fk'];
                $result3['product_detail_id_fk']    = $row['product_detail_id'];
                $result3['product_detail_name']     = $row['product_detail_name'];
                $result3['detail_test_unit']        = $row['detail_test_unit'];
                $result3['detail_reference_value']  = $row['detail_reference_value'];

                array_push($op['normal'], $result3);
            }



            $mpdf = new Mpdf([
                'margin_top' => 70,
                'margin_bottom' => 30,
                'default_font' => 'Kanit', // Arabic-supporting font
                'format' => 'A4',
                'mode' => 'utf-8',
                'orientation' => 'P',      // 'P' for Portrait, 'L' for Landscape
                'autoScriptToLang' => true,
				'autoLangToFont' => true,
            ]);



            // Header/Footer Setup
            $mpdf->SetHTMLHeader('
                <div style="text-align:center; padding:1px; border-bottom:2px solid #000;">
                    <table border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    <tr >
                                        <td width=20%>
                                        	<img style="width:120px;" src="../'.$_GET['company_logo'].'">
                                        </td>
                                        <td width="55%" style="text-align:center; color:#0E59A5;">
                                            <span style="text-align:center;font-size:28px; font-weight:700; ">ALLIANCE LABORATORY</span>
                                            <br>
                                            <img style="width:120px;" src="../assets/images/lab_result.png">

                                        </td>
                                        <td width=25%  style="text-align:center;"><img style="width:120px;" src="../assets/images/qr.jpg"></td>
                                    </tr>
                                    
                                </tbody>
                    </table>
                </div>
                <div style="text-align:center; padding:1px; border-bottom:1px solid #ccc;">      
                    <table class="table1" border=0 cellpadding=0 cellspacing=0 style="width:100%; text-align:left; font-size:16px;" >
                        <tbody>

                            <tr >
                                <td width=60%  class="f16 fw">
                                    Name: 
                                
                                    '.$op['data'][0]['patient_full_name'].'                                            
                                </td>

                                <td  class="f16">
                                    Gender:
                                </td>
                                <td  class="f16">
                                	'.$op['data'][0]['gender'].'
                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    D.O.B: 
                                
                                	'.$op['data'][0]['patient_date_of_birth'].'
                                                                             
                                </td>
                                <td  class="f16">
                                    Referred by:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['site_doctor'].'
                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    Age: 
                                
                                    '.$op['data'][0]['age'].' Y
                                </td>
                                <td class="f16">
                                    Lab ID:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['test_number'].'
                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    Sample Received on: 
                                

                                    '.$op['data'][0]['lab_test_date_only'] .' ' .$op['data'][0]['lab_test_date_time'].'                                             
                                </td>

                                <td class="f16">
                                    Patient ID:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['patient_id_fk'].'
                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    Sample Reported on: 
                                
                                    '.$op['data'][0]['lab_test_date_report_only'] .' ' .$op['data'][0]['lab_test_date_report_time'].'                                     
                                </td>

                                <td class="f16">
                                    Company Name:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['company_name'].'

                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    Insurance Status: 
                                
                                    '.$op['data'][0]['insurance'].'
                                </td>

                                <td class="f16">
                                    Insurance Company:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['insurance_company_name'].'

                                </td>
                            </tr>

                            
                        </tbody>
                    </table>
                </div>
            ');

            $mpdf->SetHTMLFooter('
                <div style="text-align:center; padding:5px; border-top:1px solid #ccc;">
                    

                    <table class="table1 " border=0 cellpadding=0 cellspacing=0 style="width:99%; margin-top:15px;">
                        <tbody>
                            <tr class="top-cell">

                            	<td class="top-cell" width="15%" style="border:0px; font-size:11px;">
	                                Page {PAGENO} of {nbpg}
                                </td>

                                <td class="top-cell"  style="text-align:center; font-size:11px; border:0px;">
                                    
                                    Alliance Laboratory, part of Healthcare Alliance Medical Center . license No.: 6233
                                    <br>
                                    <span dir="RTL">تاقیگەی بزیشکی ئەڵایەنس  
                                    <br>
                                    ڕێگای فڕۆکەخانە، سەربەستی، هەولێر </span>
                                </td>
                                <td class="top-cell" width="15%" style="border:0px; font-size:11px;">
	                                <p style="padding-top:15px;">
	                                Nyaz Rafeeq
	                                </p>   
	                                <p>
	                                Lab Supervisor
	                                </p>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                </div>
            ');

            // CSS to prevent row breaking
            $css = '<style>
			            	.top-cell {
					            vertical-align: top;
					        }
			                tr { 
			                    page-break-inside: avoid !important; /* Keep rows intact */
			                }
			                
			                td {
			                    font-size:16px;
			                }

			                .pad20{
			                	padding-left:20px;
			                }

			                .pad5{
			                	padding-bottom:4px;
			                	padding-top:4px;
			                }

			                .b1{
			                	border-bottom:1px solid #ebeaea;
			                }

			                .b1g{
			                	border-bottom:1px solid #868686;
			                }
			                .f16{
			                	font-size:12px !important;
			                }
			                .fw{
			                	font-weight:bold;
			                }
			                .lnh1{
			                	line-height:35px;
			                }

			                .table2 tbody tr:nth-child(even) {
							    background-color: #f8f9fa;
							}

							.table thead {
							    display: table-header-group;
							}

							.table th {
							    background-color: #808080;
							    padding: 12px 8px;
							    text-align: left;
							    font-weight: bold;
							    position: sticky;
							    top: 0;
							}
            		</style>';


            $lab ='';
            $rad ='';
            $trt ='';
            $l=0;
            $r=0;
            $t=0;
            $total_price=0;
            
            for ($i = 0; $i < count($op['data']); $i++) {

                if ($op['data'][$i]['lab_test_id'] > 0) {
                    $t++;

                    $detail_param = '';


                    if (count($op['detail'])>0) {
                        for ($j = 0; $j < count($op['detail']); $j++) {

                            if ($op['data'][$i]['lab_test_detail_id'] == $op['detail'][$j]['lab_test_detail_id_fk']) {

                                $detail_param.='<tr style="padding:5px; ">
	                                                
	                                                <td class="top-cell  pad20 pad5">
	                                                    '.$op['detail'][$j]['product_detail_name'].'
	                                                </td>

	                                                <td class="top-cell b1 pad5">
	                                                    '.$op['detail'][$j]['item_test_result'].'

	                                                </td>

	                                                <td class="top-cell b1 pad5">
	                                                    <div>
	                                                    '.nl2br($op['detail'][$j]['detail_reference_value']).'
	                                                    </div>
	                                                </td>

	                                                <td class="top-cell  pad5">
	                                                    '.$op['detail'][$j]['detail_test_unit'].'
	                                                </td>

	                                            </tr>';
                            } 
                        }
                    }else{
                        for ($j = 0; $j < count($op['normal']); $j++) {

                            if ($op['data'][$i]['lab_test_detail_id'] == $op['normal'][$j]['lab_test_detail_id']) {


                                $detail_param.='<tr class="" style="margin-bottom:5px;">
	                                                
	                                                <td class="top-cell  pad20 pad5">
	                                                    '.$op['normal'][$j]['product_detail_name'].'

	                                                </td>

	                                                <td class="top-cell b1  pad5">
	                                                </td>

	                                                <td class="top-cell b1  pad5">
	                                                	<div >
					                                		'.nl2br($op['normal'][$j]['detail_reference_value']).'
					                                	</div>
	                                                    
	                                                </td>

	                                                <td class="top-cell  pad5">
	                                                    '.$op['normal'][$j]['detail_test_unit'].'

	                                                </td>

	                                                
	                                            </tr>';
                            } 
                        }
                    }


                    $trt.='<tr style="border: 0px solid !important;">
                               
                                
                                <td class="top-cell fw pad5" style="width: 325px;">
                                    '.$op['data'][$i]['product_name'].'
                                </td>
                                <td class="top-cell pad5" style="width: 170px;">
                                    '.$op['data'][$i]['test_result'].'
                                </td>
                                <td class="top-cell pad5" style="width: 300px;">
                                	<div >
                                		'.nl2br($op['data'][$i]['reference_value']).'
                                	</div>

                                    
                                </td>
                                <td class="top-cell pad5" style="width: 100px;">
                                    '.$op['data'][$i]['test_unit'].'
                                </td>
                            </tr>
                            	'.$detail_param.'
                            
                            <tr>
                                <td class="top-cell b1">Remarks:</td>
                                <td class="top-cell b1" style="text-align:left;width: 100px;padding:10px !important;" colspan="3">
                                    '.$op['data'][$i]['test_note'].'

                                </td>
                            </tr>
                            ';
                
                }
            }

            

            
            $table= $css.'<table class="table" border=0 cellpadding=0 cellspacing=0 style="width:100%; v">
            					<thead>
                                	<tr style="background-color:#808080; " >
                                        <th class="fw lnh">Investigation</th>
                                        <th class="fw lnh">Result</th>
                                        <th class="fw lnh">Reference Values</th>
                                        <th class="fw lnh">Units</th>
                                        
                                    </tr>
                                </thead>
                                <tbody>

                                    '.$trt.'
                                    <tr >
                                        <td colspan=4><br></td>
                                    </tr>
                                            
                                </tbody>
                            </table>';

            $mpdf->WriteHTML("$table");
            $mpdf->Output('document.pdf', 'I');


            $op['is_success'] = true;
            echo json_encode($op);
            exit;
        } else {
            $op['is_success'] = false;
            $op['data']       = $db->error;
            echo json_encode($op);

            exit;
        }
    }

    if ($_GET['type'] == "pdf_visit") {

		$id = $_GET['edited_id'];
		$op  = array('is_success' => false, 'data' => array(), 'lab' => array(), 'radiology' => array(), 'treat' => array(), 'consultation' => array(), 'service' => array(), 'tour' => array(), 'invoice' => array(), 'detail' => array(), 'normal' => array());

		$res = $db->query("SELECT
										patient_report_id,
										report_reference_number,
									 	past_medical_history,
									 	past_surgical_history,
									 	past_drug_history,
									 	present_complaint,
									 	present_illness,
									 	family_history,
									 	social_history,
									 	assessment,
									 	chest,
									 	abdomen,
									 	heart,
									 	cns,
									 	bp,
									 	pr,
									 	rr,
									 	temp,
									 	spo2,
									 	gcs,
									 	provisional_diagnosis,
									 	follow_up,
									 	follow_note,
									 	sick_leave,
									 	sick_leave_from,
									 	sick_leave_to,
									 	sick_leave_note,
									 	referral_to,
									 	reason_of_referral,
									 	report_note,
									 	discharge_summary,
									 	medical_report,
									 	sequence_number,
									 	report_date,
									 	PR.patient_id_fk,
									 	PR.staff_id_fk,
									 	patient_full_name,
										patient_card_number,
										gender,
										patient_date_of_birth,
										blood_group,
										allergies,
										occupation,
										company_name,
										is_refferal,
										(
											year(curdate())
											-
										 	year(patient_date_of_birth) 
										) AS age,
										patient_refferal_id,
										referred_to,
										refferal_date,
										clinc_site_name,
										chief_complaint,
										reason_for_refferal,
										IFNULL(full_name,'') as site_doctor,
										refferal_note,
										PR.created_by,
										P.insurance,
										P.company_id_fk,
										PR.insurance_status,
										insurance_company_name

								FROM patient_report PR
								LEFT JOIN patient_report_detail PRD ON (PR.patient_report_id = PRD.patient_report_id_fk)	
								LEFT JOIN patient P ON (PR.patient_id_fk = P.patient_id)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	
								LEFT JOIN insurance_company IC ON (P.insurance_company_id_fk = IC.insurance_company_id )	
								LEFT JOIN patient_refferal PRR ON (PR.patient_report_id = PRR.patient_report_id_fk)	
								LEFT JOIN staff S ON (PR.staff_id_fk = S.staff_id)	

								WHERE PR.is_deleted = 0 AND PR.patient_report_id = $id 

								");

		$res2 = $db->query("SELECT
										
										treatment_id,
										patient_report_id_fk,
										IFNULL(product_name,medicine_name) as medicine_name,
										treat_form_id_fk,
										dose,
										treat_route_id_fk,
										treat_frequency_id_fk,
										treat_note,
										form_name,
										frequency_name,
										route_name,
										product_id_fk,
										product_name,
										PT.created_at,
										DATE(PT.created_at) as day_group,
										IFNULL(full_name,'') as added_by,
										PT.created_by


								FROM patient_treatment PT
								LEFT JOIN product PD ON (PT.product_id_fk = PD.product_id)	
								LEFT JOIN treat_form TF ON (PT.treat_form_id_fk = TF.treat_form_id)	
								LEFT JOIN treat_frequency FR ON (PT.treat_frequency_id_fk = FR.treat_frequency_id)	
								LEFT JOIN treat_route TR ON (PT.treat_route_id_fk = TR.treat_route_id)	

								LEFT JOIN staff S ON (PT.created_by = S.staff_id)	

								WHERE PT.is_deleted = 0 AND PT.patient_report_id_fk = $id 

								");


		$res3 = $db->query("SELECT
										lab_test_id,
										lab_test_date,
										result_note,
										result_file,
										result_conclusion,
										lab_test_status,
										test_type,
										PI.patient_id_fk,
										PI.staff_id_fk,
										to_doctor,
										IFNULL(S.full_name,to_doctor) as site_doctor,
										IFNULL(S2.full_name,'') as lab_doctor,
										lab_test_detail_id,
										product_id_fk,
										product_name,
										test_note,
										test_number,
										cost,
										sell,
										test_result,
										test_status,
										patient_full_name,
		                    			patient_phone,
		                    			gender,
		                    			patient_date_of_birth,
		                    			blood_group,
		                    			allergies,
		                    			company_name,
		                    			occupation,
		                    			reference_value,
		                    			test_unit,
		                    			attach_file,
		                    			PI.patient_report_id_fk,
		                    			PID.created_at,
										DATE(PID.created_at) as day_group,

										IFNULL(S3.full_name,'') as added_by,
										PID.created_by

								FROM lab_test PI 
								
								LEFT JOIN patient P ON (PI.patient_id_fk = P.patient_id)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	
								LEFT JOIN lab_test_detail PID ON (PI.lab_test_id = PID.lab_test_id_fk)	
								LEFT JOIN product PD ON (PID.product_id_fk = PD.product_id)	
								
								LEFT JOIN staff S ON (PI.staff_id_fk = S.staff_id)	
								LEFT JOIN staff S2 ON (PI.created_by = S2.staff_id)	
								LEFT JOIN staff S3 ON (PID.created_by = S3.staff_id)	

								WHERE PI.is_deleted = 0 AND PID.is_deleted=0 AND PI.patient_report_id_fk = $id 

								
								");

		$res4 = $db->query("SELECT
										radiology_test_id,
										radiology_test_date,
										result_note,
										result_file,
										result_conclusion,
										radiology_test_status,
										test_type,
										PI.patient_id_fk,
										PI.staff_id_fk,
										to_doctor,
										IFNULL(S.full_name,to_doctor) as site_doctor,
										IFNULL(S2.full_name,'') as lab_doctor,
										radiology_test_detail_id,
										product_id_fk,
										product_name,
										test_note,
										test_number,
										cost,
										sell,
										test_result,
										test_status,
										patient_full_name,
		                    			patient_phone,
		                    			gender,
		                    			patient_date_of_birth,
		                    			blood_group,
		                    			allergies,
		                    			company_name,
		                    			occupation,
		                    			reference_value,
		                    			test_unit,
		                    			attach_file,
		                    			PI.patient_report_id_fk,
		                    			PID.created_at,
										DATE(PID.created_at) as day_group,

										IFNULL(S3.full_name,'') as added_by,
										PID.created_by

								FROM radiology_test PI 
								
								LEFT JOIN patient P ON (PI.patient_id_fk = P.patient_id)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	
								LEFT JOIN radiology_test_detail PID ON (PI.radiology_test_id = PID.radiology_test_id_fk)	
								LEFT JOIN product PD ON (PID.product_id_fk = PD.product_id)	
								
								LEFT JOIN staff S ON (PI.staff_id_fk = S.staff_id)	
								LEFT JOIN staff S2 ON (PI.created_by = S2.staff_id)	
								LEFT JOIN staff S3 ON (PID.created_by = S3.staff_id)	

								WHERE PI.is_deleted = 0 AND PID.is_deleted=0 AND PI.patient_report_id_fk = $id 

								");

		$res5 = $db->query("SELECT
										
										sell_detail_id,
										product_id_fk,
										sell_quantity,
										SD.sell_price,
										cost_price,
										discount,
										sell_detail_date,
										SD.product_unit_id_fk,
										unit_scale,
										sell_detail_note,
										origin_from,
										origin_from_id_fk,
										consultant_name,
										stock_id_fk,
										SD.product_type_id_fk,
										sell_id_fk,
										patient_report_id_fk,
										patient_id_fk,
										product_name,
										SD.created_at,
										DATE(SD.created_at) as day_group,

										IFNULL(S.full_name,'') as added_by,
										SD.created_by

								FROM sell_detail SD
								LEFT JOIN product PD ON (SD.product_id_fk = PD.product_id)	
								LEFT JOIN staff S ON (SD.created_by = S.staff_id)	

								WHERE SD.is_deleted = 0 AND origin_from='consultation' AND SD.patient_report_id_fk = $id 

								");

		$res6 = $db->query("SELECT
										
										sell_detail_id,
										product_id_fk,
										sell_quantity,
										SD.sell_price,
										cost_price,
										discount,
										sell_detail_date,
										SD.product_unit_id_fk,
										unit_scale,
										sell_detail_note,
										origin_from,
										origin_from_id_fk,
										consultant_name,
										stock_id_fk,
										SD.product_type_id_fk,
										sell_id_fk,
										patient_report_id_fk,
										patient_id_fk,
										product_name,
										SD.created_at,
										DATE(SD.created_at) as day_group,

										IFNULL(S.full_name,'') as added_by,
										SD.created_by

								FROM sell_detail SD
								LEFT JOIN product PD ON (SD.product_id_fk = PD.product_id)	
								LEFT JOIN staff S ON (SD.created_by = S.staff_id)	

								WHERE SD.is_deleted = 0 AND origin_from='procedure' AND SD.patient_report_id_fk = $id 

								");

		$res7 = $db->query("SELECT
										
										note_id,
										report_note_tour,
										noter_name,
										note_date,
										note_type,
										patient_report_id_fk,
										patient_id_fk,
										staff_id_fk,
										note_file,
										PRN.created_at,
										DATE(PRN.created_at) as day_group,

										IFNULL(S.full_name,'') as added_by,
										PRN.created_by

								FROM patient_report_note PRN
								LEFT JOIN staff S ON (PRN.created_by = S.staff_id)	

								WHERE PRN.is_deleted = 0 AND PRN.patient_report_id_fk = $id 

								");

		$res8 = $db->query("SELECT
										
		                    			sell_detail_id,
		                    			sell_id_fk,
		                    			origin_from,
		                    			product_id_fk

									FROM sell_detail SD 	

								
									WHERE SD.is_deleted = 0  AND SD.patient_report_id_fk = $id 

								");

		$res9 = $db->query("
							SELECT
															
								lab_test_detail_item_id,
								LTDI.item_test_note,
								LTDI.item_test_result,
								product_detail_id_fk,
								lab_test_detail_id_fk,
								product_detail_id,
								product_detail_name,
								detail_test_unit,
								detail_reference_value

							FROM lab_test_detail_item LTDI 	

							LEFT JOIN product_detail PD ON (PD.product_detail_id = LTDI.product_detail_id_fk AND PD.is_deleted=0)	
						
							WHERE LTDI.is_deleted = 0  AND LTDI.patient_report_id_fk = $id

							");

		if ($res) {

			$past_medical_history = '';
			$past_surgical_history = '';
			$past_surgical_history = '';

			while ($row = $res->fetch_assoc()) {

				$result['patient_report_id']  		= $row['patient_report_id'];
				$result['report_reference_number'] 	= $row['report_reference_number'];
				$result['present_complaint'] 		= $row['present_complaint'];
				$result['present_illness'] 			= $row['present_illness'];
				$result['past_medical_history'] 	= !empty($row['past_medical_history']) ? $row['past_medical_history'] : $past_medical_history;
				$result['past_surgical_history'] 	= !empty($row['past_surgical_history']) ? $row['past_surgical_history'] : $past_surgical_history;
				$result['past_drug_history'] 	    = !empty($row['past_drug_history']) ? $row['past_drug_history'] : $past_surgical_history;
				$result['family_history']  			= $row['family_history'];
				$result['social_history']  			= $row['social_history'];
				$result['assessment']  				= $row['assessment'];
				$result['chest']  					= $row['chest'];
				$result['abdomen'] 					= $row['abdomen'];
				$result['heart'] 					= $row['heart'];
				$result['cns']  					= $row['cns'];
				$result['bp'] 						= $row['bp'];
				$result['pr']  						= $row['pr'];
				$result['rr']  						= $row['rr'];
				$result['temp']  					= $row['temp'];
				$result['spo2']  					= $row['spo2'];
				$result['gcs']  					= $row['gcs'];
				$result['provisional_diagnosis']  	= $row['provisional_diagnosis'];
				$result['follow_up']  				= $row['follow_up'];
				$result['follow_note']  			= $row['follow_note'];
				$result['sick_leave']  				= $row['sick_leave'];
				$result['sick_leave_from']  		= $row['sick_leave_from'];
				$result['sick_leave_to']  			= $row['sick_leave_to'];
				$result['sick_leave_note']  		= $row['sick_leave_note'];
				$result['referral_to']  			= $row['referral_to'];
				$result['reason_of_referral']  		= $row['reason_of_referral'];
				$result['report_note']  			= $row['report_note'];
				$result['discharge_summary']  		= $row['discharge_summary'];
				$result['medical_report']  			= $row['medical_report'];
				$result['report_date']  			= $row['report_date'];
				$result['patient_id_fk']  			= $row['patient_id_fk'];
				$result['patient_full_name']  		= $row['patient_full_name'];
				$result['patient_card_number']		= $row['patient_card_number'];
				$result['gender']  					= $row['gender'];
				$result['patient_date_of_birth']  	= $row['patient_date_of_birth'];
				$result['blood_group']  			= $row['blood_group'];
				$result['age']  			= $row['age'];
				$result['allergies']  				= $row['allergies'];
				$result['occupation']  				= $row['occupation'];
				$result['company_name']  			= $row['company_name'];
				$result['is_refferal']  			= $row['is_refferal'];
				$result['patient_refferal_id']  	= $row['patient_refferal_id'];
				$result['referred_to']  			= $row['referred_to'];
				$result['refferal_date']  			= $row['refferal_date'];
				$result['clinc_site_name']  		= $row['clinc_site_name'];
				$result['chief_complaint']  		= $row['chief_complaint'];
				$result['reason_for_refferal']  	= $row['reason_for_refferal'];
				$result['refferal_note']  			= $row['refferal_note'];
				$result['site_doctor']  			= $row['site_doctor'];
				$result['created_by']  				= $row['created_by'];
				$result['insurance']  				= $row['insurance'];
				$result['insurance_status']  		= $row['insurance_status'];
				$result['company_id_fk']  			= $row['company_id_fk'];
				$result['insurance_company_name']  	= $row['insurance_company_name'];

				array_push($op['data'], $result);
			}
			while ($row = $res2->fetch_assoc()) {


				$result2['treatment_id']  			= $row['treatment_id'];
				$result2['medicine_name']  			= $row['medicine_name'];
				$result2['product_id_fk']  			= $row['product_id_fk'];
				$result2['product_name']  			= $row['product_name'];
				$result2['treat_form_id_fk']  		= $row['treat_form_id_fk'];
				$result2['dose']  					= $row['dose'];
				$result2['treat_route_id_fk']  		= $row['treat_route_id_fk'];
				$result2['treat_frequency_id_fk']  	= $row['treat_frequency_id_fk'];
				$result2['treat_note']  			= $row['treat_note'];
				$result2['form_name']  				= $row['form_name'];
				$result2['frequency_name']  		= $row['frequency_name'];
				$result2['route_name']  			= $row['route_name'];
				$result2['patient_report_id_fk'] 	= $row['patient_report_id_fk'];
				$result2['created_at'] 				= $row['created_at'];
				$result2['added_by'] 				= $row['added_by'];
				$result2['created_by'] 				= $row['created_by'];
				$result2['day_group'] 				= $row['day_group'];

				array_push($op['treat'], $result2);
			}
			while ($row = $res3->fetch_assoc()) {


				$result3['lab_test_id'] = $row['lab_test_id'];
				$result3['lab_test_date']  	= $row['lab_test_date'];
				$result3['result_note']  			= $row['result_note'];
				$result3['result_file']  			= $row['result_file'];
				$result3['result_conclusion']  		= $row['result_conclusion'];
				$result3['lab_test_status']  	= $row['lab_test_status'];
				$result3['test_type']  	= $row['test_type'];
				$result3['patient_id_fk']			= $row['patient_id_fk'];
				$result3['staff_id_fk']				= $row['staff_id_fk'];
				$result3['to_doctor']				= $row['to_doctor'];
				$result3['patient_full_name']		= $row['patient_full_name'];
				$result3['patient_phone']			= $row['patient_phone'];
				$result3['lab_test_detail_id'] = $row['lab_test_detail_id'];
				$result3['product_id_fk']  			= $row['product_id_fk'];
				$result3['product_name']  			= $row['product_name'];
				$result3['test_unit']  				= $row['test_unit'];
				$result3['reference_value']  		= $row['reference_value'];
				$result3['test_note']  	= $row['test_note'];
				$result3['cost']  					= $row['cost'];
				$result3['sell']  					= $row['sell'];
				$result3['test_result']  			= $row['test_result'];
				$result3['test_status']  			= $row['test_status'];
				$result3['patient_report_id_fk']  	= $row['patient_report_id_fk'];
				$result3['site_doctor']  			= $row['site_doctor'];
				$result3['test_number']  	= $row['test_number'];
				$result3['lab_doctor']  			= $row['lab_doctor'];
				$result3['gender']  				= $row['gender'];
				$result3['patient_date_of_birth']  	= $row['patient_date_of_birth'];
				$result3['blood_group']  			= $row['blood_group'];
				$result3['allergies']  				= $row['allergies'];
				$result3['company_name']  			= $row['company_name'];
				$result3['occupation']  			= $row['occupation'];
				$result3['attach_file']  			= $row['attach_file'];
				$result3['created_at'] 				= $row['created_at'];
				$result3['added_by'] 				= $row['added_by'];
				$result3['created_by'] 				= $row['created_by'];
				$result3['day_group'] 				= $row['day_group'];

				array_push($op['lab'], $result3);
			}

			while ($row = $res4->fetch_assoc()) {


				$result4['radiology_test_id'] = $row['radiology_test_id'];
				$result4['radiology_test_date']  	= $row['radiology_test_date'];
				$result4['result_note']  			= $row['result_note'];
				$result4['result_file']  			= $row['result_file'];
				$result4['result_conclusion']  		= $row['result_conclusion'];
				$result4['radiology_test_status']  	= $row['radiology_test_status'];
				$result4['test_type']  	= $row['test_type'];
				$result4['patient_id_fk']			= $row['patient_id_fk'];
				$result4['staff_id_fk']				= $row['staff_id_fk'];
				$result4['to_doctor']				= $row['to_doctor'];
				$result4['patient_full_name']		= $row['patient_full_name'];
				$result4['patient_phone']			= $row['patient_phone'];
				$result4['radiology_test_detail_id'] = $row['radiology_test_detail_id'];
				$result4['product_id_fk']  			= $row['product_id_fk'];
				$result4['product_name']  			= $row['product_name'];
				$result4['test_unit']  				= $row['test_unit'];
				$result4['reference_value']  		= $row['reference_value'];
				$result4['test_note']  	= $row['test_note'];
				$result4['cost']  					= $row['cost'];
				$result4['sell']  					= $row['sell'];
				$result4['test_result']  			= $row['test_result'];
				$result4['test_status']  			= $row['test_status'];
				$result4['patient_report_id_fk']  	= $row['patient_report_id_fk'];
				$result4['site_doctor']  			= $row['site_doctor'];
				$result4['test_number']  	= $row['test_number'];
				$result4['lab_doctor']  			= $row['lab_doctor'];
				$result4['gender']  				= $row['gender'];
				$result4['patient_date_of_birth']  	= $row['patient_date_of_birth'];
				$result4['blood_group']  			= $row['blood_group'];
				$result4['allergies']  				= $row['allergies'];
				$result4['company_name']  			= $row['company_name'];
				$result4['occupation']  			= $row['occupation'];
				$result4['attach_file']  			= $row['attach_file'];
				$result4['created_at'] 				= $row['created_at'];
				$result4['added_by'] 				= $row['added_by'];
				$result4['created_by'] 				= $row['created_by'];
				$result4['day_group'] 				= $row['day_group'];

				array_push($op['radiology'], $result4);
			}

			while ($row = $res5->fetch_assoc()) {


				$result5['sell_detail_id']		= $row['sell_detail_id'];
				$result5['product_id_fk']  		= $row['product_id_fk'];
				$result5['sell_quantity']  		= $row['sell_quantity'];
				$result5['sell_price']  		= $row['sell_price'];
				$result5['cost_price']  		= $row['cost_price'];
				$result5['discount']  			= $row['discount'];
				$result5['sell_detail_date']	= $row['sell_detail_date'];
				$result5['product_unit_id_fk']	= $row['product_unit_id_fk'];
				$result5['unit_scale']			= $row['unit_scale'];
				$result5['sell_detail_note']	= $row['sell_detail_note'];
				$result5['origin_from']			= $row['origin_from'];
				$result5['origin_from_id_fk'] 	= $row['origin_from_id_fk'];
				$result5['consultant_name']  	= $row['consultant_name'];
				$result5['product_name']  		= $row['product_name'];
				$result5['stock_id_fk']  		= $row['stock_id_fk'];
				$result5['product_type_id_fk']  = $row['product_type_id_fk'];
				$result5['sell_id_fk']  		= $row['sell_id_fk'];
				$result5['patient_report_id_fk'] = $row['patient_report_id_fk'];
				$result5['patient_id_fk']  		= $row['patient_id_fk'];
				$result5['created_at'] 				= $row['created_at'];
				$result5['added_by'] 				= $row['added_by'];
				$result5['created_by'] 				= $row['created_by'];
				$result5['day_group'] 				= $row['day_group'];

				array_push($op['consultation'], $result5);
			}

			while ($row = $res6->fetch_assoc()) {


				$result6['sell_detail_id']		= $row['sell_detail_id'];
				$result6['product_id_fk']  		= $row['product_id_fk'];
				$result6['sell_quantity']  		= $row['sell_quantity'];
				$result6['sell_price']  		= $row['sell_price'];
				$result6['cost_price']  		= $row['cost_price'];
				$result6['discount']  			= $row['discount'];
				$result6['sell_detail_date']	= $row['sell_detail_date'];
				$result6['product_unit_id_fk']	= $row['product_unit_id_fk'];
				$result6['unit_scale']			= $row['unit_scale'];
				$result6['sell_detail_note']	= $row['sell_detail_note'];
				$result6['origin_from']			= $row['origin_from'];
				$result6['origin_from_id_fk'] 	= $row['origin_from_id_fk'];
				$result6['consultant_name']  	= $row['consultant_name'];
				$result6['product_name']  		= $row['product_name'];
				$result6['stock_id_fk']  		= $row['stock_id_fk'];
				$result6['product_type_id_fk']  = $row['product_type_id_fk'];
				$result6['sell_id_fk']  		= $row['sell_id_fk'];
				$result6['patient_report_id_fk'] = $row['patient_report_id_fk'];
				$result6['patient_id_fk']  		= $row['patient_id_fk'];
				$result6['created_at'] 			= $row['created_at'];
				$result6['added_by'] 			= $row['added_by'];
				$result6['created_by'] 			= $row['created_by'];
				$result6['day_group'] 			= $row['day_group'];

				array_push($op['service'], $result6);
			}

			while ($row = $res7->fetch_assoc()) {


				$result7['note_id']					= $row['note_id'];
				$result7['report_note_tour']  		= $row['report_note_tour'];
				$result7['noter_name']  			= $row['noter_name'];
				$result7['note_date']  				= $row['note_date'];
				$result7['note_type']  				= $row['note_type'];
				$result7['patient_report_id_fk']  	= $row['patient_report_id_fk'];
				$result7['patient_id_fk']			= $row['patient_id_fk'];
				$result7['staff_id_fk']				= $row['staff_id_fk'];
				$result7['created_at'] 				= $row['created_at'];
				$result7['added_by'] 				= $row['added_by'];
				$result7['created_by'] 				= $row['created_by'];
				$result7['note_file'] 				= $row['note_file'];
				$result7['day_group'] 				= $row['day_group'];

				array_push($op['tour'], $result7);
			}

			while ($row = $res8->fetch_assoc()) {


				$result8['sell_detail_id']			= $row['sell_detail_id'];
				$result8['sell_id_fk']  			= $row['sell_id_fk'];
				$result8['origin_from']  			= $row['origin_from'];
				$result8['product_id_fk']  			= $row['product_id_fk'];
				$result8['is_found']  				= 0;

				array_push($op['invoice'], $result8);
			}

			while ($row = $res9->fetch_assoc()) {

				$result9['lab_test_detail_item_id'] = $row['lab_test_detail_item_id'];
				$result9['item_test_note']  		= $row['item_test_note'];
				$result9['item_test_result']  		= $row['item_test_result'];
				$result9['product_detail_id_fk']  	= $row['product_detail_id_fk'];
				$result9['product_detail_id']  		= $row['product_detail_id'];
				$result9['product_detail_name']  	= $row['product_detail_name'];
				$result9['detail_test_unit']  		= $row['detail_test_unit'];
				$result9['detail_reference_value']  = $row['detail_reference_value'];
				$result9['lab_test_detail_id_fk']   = $row['lab_test_detail_id_fk'];

				array_push($op['detail'], $result9);
			}


			$mpdf = new Mpdf([
                'margin_top' => 70,
                'margin_bottom' => 30,
                'default_font' => 'Kanit', // Arabic-supporting font
                'format' => 'A4',
                'mode' => 'utf-8',
                'orientation' => 'P',      // 'P' for Portrait, 'L' for Landscape
                'autoScriptToLang' => true,
				'autoLangToFont' => true,
            ]);



            // Header/Footer Setup
            $mpdf->SetHTMLHeader('
                <div style="text-align:center; padding:1px; border-bottom:2px solid #000;">
                    <table border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    <tr >
                                        <td width=20%>
                                        	<img style="width:120px;" src="../'.$_GET['company_logo'].'">
                                        </td>
                                        <td width="55%" style="text-align:center; color:#0E59A5;">
                                            <span style="text-align:center;font-size:28px; font-weight:700; ">'.$_GET['company_name'].'</span>
                                            <br>
                                            Patient Report
                                        </td>
                                        <td width=25%  style="text-align:start; font-size:12px;">
                                        	Date:'.$op['data'][0]['report_date'].'
                                        	<br>
                                        	Reference No.:'.$op['data'][0]['report_reference_number'].'
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                    </table>
                </div>
                <div style="text-align:center; padding:1px; border-bottom:1px solid #ccc;">      
                    <table class="table1" border=0 cellpadding=0 cellspacing=0 style="width:100%; text-align:left; font-size:12px;" >
                        <tbody>

                            <tr >
                                <td width=60%  class="f16 fw">
                                    Name: 
                                
                                    '.$op['data'][0]['patient_full_name'].'                                            
                                </td>

                                <td  class="f16">
                                    Gender:
                                </td>
                                <td  class="f16">
                                	'.$op['data'][0]['gender'].'
                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    D.O.B: 
                                
                                	'.$op['data'][0]['patient_date_of_birth'].'
                                                                             
                                </td>
                                <td  class="f16">
                                    Blood Group:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['blood_group'].'
                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    Age: 
                                
                                    '.$op['data'][0]['age'].' Y
                                </td>
                                <td class="f16">
                                    Allergies:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['allergies'].'
                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    Sample Date: 
                                

                                    '.$op['data'][0]['report_date'] .'                                   
                                </td>

                                <td class="f16">
                                    Patient ID:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['patient_id_fk'].'
                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    Occupation: 
                                
                                    '.$op['data'][0]['occupation'] .'                                    
                                </td>

                                <td class="f16">
                                    Company Name:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['company_name'].'

                                </td>
                            </tr>

                            <tr >
                                <td  class="f16">
                                    Insurance Status: 
                                
                                    '.$op['data'][0]['insurance'].'
                                </td>

                                <td class="f16">
                                    Insurance Company:
                                </td>
                                <td  class="f16">
                                    '.$op['data'][0]['insurance_company_name'].'

                                </td>
                            </tr>

                            
                        </tbody>
                    </table>
                </div>
            ');

            $mpdf->SetHTMLFooter('
                <div style="text-align:center; padding:5px; border-top:1px solid #ccc;">
                    

                    <table class="table1 " border=0 cellpadding=0 cellspacing=0 style="width:99%; margin-top:15px;">
                        <tbody>
                            <tr class="top-cell">

                            	<td class="top-cell" width="25%" style="border:0px; font-size:11px;">
	                                <p style="padding-top:15px;">
	                                	Doctor: '.$op['data'][0]['site_doctor'].'
	                                </p>   
	                                <p>
	                                
	                                Signature and Stamp:
	                                </p>
                                </td>

                            	

                                <td class="top-cell"  style="text-align:center; font-size:11px; border:0px;">
                                    
                                    Healthcare Alliance Medical Center
                                    <br>
                                    <span dir="RTL">تاقیگەی بزیشکی ئەڵایەنس  
                                    <br>
                                    ڕێگای فڕۆکەخانە، سەربەستی، هەولێر </span>
                                </td>

                                <td class="top-cell" width="15%" style="border:0px; font-size:11px;">
	                                Page {PAGENO} of {nbpg}
                                </td>
                                
                            </tr>

                        </tbody>
                    </table>
                </div>
            ');

            // CSS to prevent row breaking
            $css = '<style>
			            	.top-cell {
					            vertical-align: top;
					        }
			                tr { 
			                    page-break-inside: avoid !important; /* Keep rows intact */
			                }
			                
			                td {
			                    font-size:16px;
			                }

			                .pad20{
			                	padding-left:20px;
			                }

			                .pad5{
			                	padding-bottom:4px;
			                	padding-top:4px;
			                }

			                .b1{
			                	border-bottom:1px solid #ebeaea;
			                }

			                .b1g{
			                	border-bottom:1px solid #868686;
			                }
			                .f16{
			                	font-size:12px !important;
			                }
			                .fw{
			                	font-weight:bold;
			                }
			                .lnh1{
			                	line-height:35px;
			                }

			                .table2 tbody tr:nth-child(even) {
							    background-color: #f8f9fa;
							}

							.table thead {
							    display: table-header-group;
							}

							.table th {
							    background-color: #808080;
							    
							    position: sticky;
							    top: 0;
							}

							.table-bordered td{
								// border: 1px solid #000;
								font-size:11px !important;
								text-align:center;
								padding: 5px 1px;
							}

							.table-bordered-s td{
								font-size:12px;
								text-align:center;
								padding: 5px 1px;
							}



                    #patient_table_id td {
                        text-align:left !important;
                        border-left: 0px solid #9d9b9b !important;

                    }

                    #header_table td {
                        border: 0px solid #9d9b9b;
                    }
                    
                    .bg-primary{
                        background-color:grey;
                    }

                    .no_border td {
                        border: 0px !important;

                    }

                    .prestyle{
                        white-space: pre-wrap;
                        word-wrap: break-word;
                    }

                    #footer_first{         
                                position:absolute;
                                top:25.7cm;
                                width: -webkit-fill-available;

                                }

                    .hidden-attach{
                        display: none;
                    }

                    .font-bold{
                        font-weight: bold;
                        line-height: 20px;
                    }

                    .bb{
                        border-bottom: 0.5px solid #9d9b9b;
                    }
                    .bl{
                        border-left: 0.5px solid #9d9b9b;
                    }
                    .br{
                        border-right: 0.5px solid #9d9b9b;
                    }
                    .bt{
                        border-top: 0.5px solid #9d9b9b;
                    }
                    .tl{
                        text-align:left !important;
                    }
                    .nbl {
                        border-left: 0px solid #9d9b9b !important;
                    }
                    .nbb {
                        border-bottom: 0px solid #9d9b9b !important;
                    }

                    .nbt {
                        border-top: 0px solid #9d9b9b;
                    }

                    .nbr {
                        border-right: 0px solid #9d9b9b;
                    }

                    .tj{
                        text-align: justify !important;
                        text-justify: inter-word !important;
                    }
            		</style>';




			$lab ='';
            $rad ='';
            $trt ='';
            $con ='';
            $ser ='';
            $tur ='';
            $l=0;
            $r=0;
            $t=0;
            

            for ($i = 0; $i < count($op['lab']); $i++) {

                if ($op['lab'][$i]['lab_test_id'] > 0) {
                    $t++;


                    $lab.='<tr class="bb">
                                    <td class="bb br bl">'.$t.'</td>
                                    <td class="bb br">
                                        '.$op['lab'][$i]['product_name'].'
                                    </td>
                                    <td class="bb br">
                                        '.$op['lab'][$i]['test_result'].'

                                    </td>
                                    <td class="bb br">
                                        '.$op['lab'][$i]['test_unit'].'

                                    </td>
                                    <td class="bb br">
                                        <div >
                                		'.nl2br($op['lab'][$i]['reference_value']).'
                                		</div>
                                    </td>
                                    <td class="bb br">
                                        '.$op['lab'][$i]['test_note'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['lab'][$i]['added_by'].'

                                    </td>

                                    <td class=" bb br ">
                                        '.$op['lab'][$i]['created_at'].'

                                    </td>

                                    
                                    
                                </tr>';
                
                }
            }



            $t=0;

            for ($i = 0; $i < count($op['radiology']); $i++) {

                if ($op['radiology'][$i]['radiology_test_id'] > 0) {
                    $t++;


                    $rad.='<tr class="clone_row">
                                    <td class="bb br bl">'.$t.'</td>
                                    <td class="bb br">
                                        '.$op['radiology'][$i]['product_name'].'
                                    </td>
                                    <td class="bb br">
                                        '.$op['radiology'][$i]['test_result'].'
                                    </td>
                                    
                                    <td class="bb br">
                                        '.$op['radiology'][$i]['test_note'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['radiology'][$i]['added_by'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['radiology'][$i]['created_at'].'
                                    </td>

                                    
                                    
                                </tr>';
                
                }
            }

            $t=0;

            for ($i = 0; $i < count($op['treat']); $i++) {

                if ($op['treat'][$i]['treatment_id'] > 0) {
                    $t++;


                    $trt.='<tr class="clone_row">
                                    <td class="bb br bl">'.$t.'</td>
                                    <td class="bb br">
                                        '.$op['treat'][$i]['medicine_name'].'
                                    </td>
                                    <td class="bb br">
                                        '.$op['treat'][$i]['form_name'].'
                                    </td>
                                    <td class="bb br">
                                       '.$op['treat'][$i]['dose'].'
                                    </td>
                                    <td class="bb br">
                                        '.$op['treat'][$i]['route_name'].'
                                    </td>
                                    <td class="bb br">
                                        '.$op['treat'][$i]['frequency_name'].'
                                    </td>

                                    <td class="bb br">
                                       '.$op['treat'][$i]['treat_note'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['treat'][$i]['added_by'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['treat'][$i]['created_at'].'
                                    </td>
                                    
                                </tr>';
                
                }
            }

            $t=0;

            for ($i = 0; $i < count($op['consultation']); $i++) {

                if ($op['consultation'][$i]['sell_detail_id'] > 0) {
                    $t++;

                    $con.='<tr class="clone_row">
                                    <td class="bb br bl">'.$t.'</td>
                                    <td class="bb br">
                                        '.$op['consultation'][$i]['product_name'].'
                                    </td>
                                    <td class="bb br">
                                        '.$op['consultation'][$i]['consultant_name'].'
                                    </td>
                                    <td  class="bb br">
                                       <div >
                                		'.nl2br($op['consultation'][$i]['sell_detail_note']).'
                                		</div>
                                    </td>

                                    <td class="bb br">
                                        '.$op['consultation'][$i]['added_by'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['consultation'][$i]['created_at'].'
                                    </td>
                                    
                                </tr>';
                
                }
            }

            $t=0;

            for ($i = 0; $i < count($op['service']); $i++) {

                if ($op['service'][$i]['sell_detail_id'] > 0) {
                    $t++;

                    $ser.='<tr class="clone_row">
                                    <td class="bb br bl">'.$t.'</td>
                                    <td class="bb br">
                                        '.$op['service'][$i]['product_name'].'
                                    </td>
                                    <td class="bb br">
                                        '.$op['service'][$i]['consultant_name'].'
                                    </td>
                                    <td  class="bb br">
                                    	<div >
                                		'.nl2br($op['service'][$i]['sell_detail_note']).'
                                		</div>
                                    </td>

                                    <td class="bb br">
                                        '.$op['service'][$i]['added_by'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['service'][$i]['created_at'].'
                                    </td>
                                    
                                </tr>';
                
                }
            }

            $t=0;

            for ($i = 0; $i < count($op['tour']); $i++) {

                if ($op['tour'][$i]['note_id'] > 0) {
                    $t++;

                    $tur_type = "";
                    switch ($op['tour'][$i]['note_type']) {
                        case 0:
                            $tur_type = "Default Note";
                            break;
                        case 1:
                            $tur_type = "Doctor Note";
                            break;
                        case 2:
                            $tur_type = "Nurse Note";
                            break;
                        case 3:
                            $tur_type = "Day Tour";
                            break;
                        case 4:
                            $tur_type = "Night Tour";
                            break;
                        case 5:
                            $tur_type = "Follow up";
                            break;
                    }

                    $tur.='<tr class="clone_row">
                                    <td class="bb bl br">'.$t.'</td>
                                    <td class=" bb br tj tl">
                                    	<div >
                                		'.nl2br($op['tour'][$i]['report_note_tour']).'
                                		</div>
                                    </td>
                                    <td class="bb br">
                                        '.$op['tour'][$i]['noter_name'].'
                                    </td>

                                    <td class="bb br">
                                        '.$tur_type.'
                                    </td>
                                    

                                    <td class="bb br">
                                        '.$op['tour'][$i]['added_by'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['tour'][$i]['created_at'].'
                                    </td>

                                    
                                    
                                </tr>';
                
                }
            }

            
                        
            $tr = '
                        <div class="table-responsive1">
                            
                            '.$css.'
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td class="font-bold bt bl br" width="20%">
                                            Cheif Complaint and Duration
                                        </td>
                                        <td class="bt br tl tj">
                                            '.$op['data'][0]['present_complaint'].'
                                        </td>
                                    </tr>
                                    <tr class="border">
                                        <td class="font-bold bt bl br" width="15%">
                                            History of Present Illness
                                        </td>
                                        <td class="bt br tl tj">
                                            '.$op['data'][0]['present_illness'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br">
                                            Past Medical History
                                        </td>
                                        <td class="bt br tl tj">
                                            '.$op['data'][0]['past_medical_history'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br">
                                            Past Surgical History
                                        </td>
                                        <td class="bt br tl tj">
                                            '.$op['data'][0]['past_surgical_history'].'
                                        </td>

                                    </tr>
                                    <tr class="border">
                                        <td class="font-bold bt bl br">
                                            Past Drug History
                                        </td>
                                        <td class="bt br tl tj">
                                            '.$op['data'][0]['past_drug_history'].'
                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br">
                                            Family History
                                        </td>
                                        <td class="bt br tl tj">
                                            '.$op['data'][0]['family_history'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br">
                                            Social History
                                        </td>
                                        <td class="bt br tl tj">
                                            '.$op['data'][0]['social_history'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br bb">
                                            Assessment
                                        </td>
                                        <td class="bt br bb tl tj">
                                            '.$op['data'][0]['assessment'].'
                                        </td>
                                    </tr>


                                </tbody>
                            </table>
                            <br>
                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td class="font-bold bt bl br" width="15%">
                                            Chest:
                                        </td>
                                        <td class="bt br" width="40%">
                                            '.$op['data'][0]['chest'].'
                                        </td>

                                        <td class="font-bold bt br" width="15%">
                                            BP:
                                        </td>
                                        <td class="bt br">
                                            '.$op['data'][0]['bp'].'
                                        </td>
                                        <td class="font-bold bt br" width="15%" style="font-style: italic;">
                                            mmHg
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br" width="15%">
                                            Abdomen:
                                        </td>
                                        <td class="bt br">
                                            '.$op['data'][0]['abdomen'].'
                                        </td>

                                        <td class="font-bold bt br" width="15%">
                                            PR:
                                        </td>
                                        <td class="bt br">
                                            '.$op['data'][0]['pr'].'
                                        </td>
                                        <td class="font-bold br bt" width="15%" style="font-style: italic;">
                                            bpm
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br" width="15%">
                                            Heart:
                                        </td>
                                        <td class=" bt  br">
                                            '.$op['data'][0]['heart'].'
                                        </td>

                                        <td class="font-bold bt br" width="15%">
                                            RR:
                                        </td>
                                        <td class=" bt  br">
                                            '.$op['data'][0]['rr'].'
                                        </td>
                                        <td class="font-bold bt br" width="15%" style="font-style: italic;">
                                            cpm
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br bb" width="15%">
                                            CNS:
                                        </td>
                                        <td class=" bt  br bb">
                                            '.$op['data'][0]['cns'].'
                                        </td>

                                        <td class="font-bold bt  br" width="15%">
                                            Temp:
                                        </td>
                                        <td class=" bt  br">
                                            '.$op['data'][0]['temp'].'
                                        </td>
                                        <td width="15%" class="font-bold bt  br" style="font-style: italic;">
                                            <sup>0</sup>C
                                        </td>
                                    </tr>

                                    <tr >
                                        <td colspan="2" rowspan="3" class="nbl nbb ">
                                            
                                        </td>
                                        

                                        <td class="font-bold bt bl br" width="15%">
                                            SPO<sub>2</sub>:
                                        </td>
                                        <td class=" bt  br">
                                            '.$op['data'][0]['spo2'].'
                                        </td>
                                        <td width="15%" class="font-bold bt br" style="font-style: italic;">
                                            %
                                        </td>
                                    </tr>

                                    <tr >
                                        
                                        <td class="font-bold bl bb bt br" width="15%">
                                            GCS:
                                        </td>
                                        <td class=" bt bb br">
                                            '.$op['data'][0]['gcs'].'
                                        </td>
                                        <td width="15%" class="font-bold bt bb br" style="font-style: italic;">
                                            /15
                                        </td>
                                    </tr>

                                    


                                </tbody>
                            </table>
                            <br>
                            <br>

                            <table width="100%" class="table table-bordered table-lg lab-table" border=0 cellpadding=0 cellspacing=0>
                            	<thead>
                            		<tr class="">
                                        <td colspan=8>Investigations/Laboratory</td>
                                        
                                    </tr>
                                    
                                    <tr class=" bg-primary">
                                        <td class="font-bold bt">#</td>
                                        <td  class="font-bold bt">Lab Test</td>
                                        <td  class="font-bold bt">Result</td>
                                        <td  class="font-bold bt">Units</td>
                                        <td  class="font-bold bt">Reference Values</td>
                                        <td  class="font-bold bt">Note</td>
                                        <td  class="font-bold bt">Added By</td>
                                        <td  class="font-bold bt br">Datetime</td>
                                    </tr>
                            	</thead>
                                <tbody>

                                	
                                    '.$lab.'
                                    
                                    
                                </tbody>
                                
                            </table>
                            <br>
                            <br>

                            <table width="100%" class="table table-bordered table-lg radiology-table" border=0 cellpadding=0 cellspacing=0>

                            	<thead>
                            		<tr class="">
                                        <td colspan=6>Investigations/Radiology</td>
                                        
                                    </tr>

                                    <tr class=" bg-primary">
                                        <td class="font-bold bt"  width=5%>#</td>
                                        <td class="font-bold bt"  >Study Name</td>
                                        <td  class="font-bold bt" >Result</td>
                                        <td class="font-bold bt"  >Note</td>
                                        <td class="font-bold bt"  >Added By</td>
                                        <td class="font-bold bt br"  >Datetime</td>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                    '.$rad.'
                                    
                                    
                                </tbody>
                                
                            </table>

                            <br>
                            <br>

                            <table width="100%" class="table table-bordered table-lg lab-table" border=0 cellpadding=0 cellspacing=0>
                                <tbody>
                                    <tr class="">
                                        <td colspan=6>Consultation</td>
                                        
                                    </tr>
                                    <tr class=" bg-primary">
                                        <td class="font-bold bt">#</td>
                                        <td  class="font-bold bt">Consultation Type</td>
                                        <td  class="font-bold bt">Consultant Name</td>
                                        <td  class="font-bold bt">Consultant Note</td>
                                        <td  class="font-bold bt">Added By</td>
                                        <td  class="font-bold bt br">Datetime</td>
                                    </tr>
                                    '.$con.'
                                    
                                    
                                </tbody>
                                
                            </table>
                            <br>
                            <br>
                            <table width="100%" class="table table-bordered table-lg lab-table" border=0 cellpadding=0 cellspacing=0>
                                <tbody>
                                    <tr class="">
                                        <td colspan=6>Procedures & Services</td>
                                        
                                    </tr>
                                    <tr class=" bg-primary">
                                        <td class="font-bold bt">#</td>
                                        <td  class="font-bold bt">Procedure/Service</td>
                                        <td  class="font-bold bt">Employee Name</td>
                                        <td  class="font-bold bt">Note</td>
                                        <td  class="font-bold bt">Added By</td>
                                        <td  class="font-bold bt br">Datetime</td>
                                    </tr>
                                    '.$ser.'
                                    
                                    
                                </tbody>
                                
                            </table>
                            <br>
                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    

                                    <tr class="border">
                                        <td width="20%" class="font-bold bt br bl bb">
                                            Provisional Diagnosis:
                                        </td>
                                        <td colspan=2 class="bt br bb">
                                            '.$op['data'][0]['provisional_diagnosis'].'
                                        </td>
                                    </tr>

                                    
                            	</tbody>
                            </table>
                            <br>
                            <br>

                            <table width="100%" class="table table-bordered table-lg treatment-table" border=0 cellpadding=0 cellspacing=0>
	                            <tbody>
	                            	<tr class="">
                                        <td colspan=9>Treatment <span style="font-style: italic;">(Dose and route)</td>
                                        
                                    </tr>
	                                <tr class="border bg-primary">
	                                    <td class="font-bold bt">#</td>
	                                    <td class="font-bold bt" >Medicine</td>
	                                    <td class="font-bold bt" >Form</td>
	                                    <td class="font-bold bt" >Dose</td>
	                                    <td class="font-bold bt" >Route</td>
	                                    <td class="font-bold bt" >Frequency</td>
	                                    <td class="font-bold bt" >Note</td>
	                                    <td class="font-bold bt" >Added By</td>
	                                    <td class="font-bold bt br" >Datetime</td>
	                                </tr>
	                                '.$trt.'
	                                
	                                
	                            </tbody>
	                        </table>
                            <br>
                            <br>  

                            <table width="100%" class="table table-bordered table-lg treatment-table" border=0 cellpadding=0 cellspacing=0>
                                <tbody>
                                    <tr class="">
                                        <td colspan=6>Doctors, Nurse & Tour Notes</td>
                                        
                                    </tr>
                                    <tr class="border bg-primary">
                                        <td class="bt">#</td>
                                        <td class="font-bold bt">Tour/Note</td>
                                        <td class="font-bold bt">Medical Name</td>
                                        <td class="font-bold bt">Type</td>
                                        <td class="font-bold bt">Added By</td>
                                        <td class="font-bold bt br">Datetime</td>
                                    </tr>
                                    '.$tur.'
                                    
                                    
                                </tbody>
                                
                            </table>

                            
                            <br>
                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; text-align:left !important;">
                                <tbody>
                                    <tr class="border">
                                        <td class="font-bold bt bl br" width="15%">Follow up:</td>
                                        <td width="35%" class="bt br">
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    '.$op['data'][0]['follow_up'].'
                                                </div>

                                                <div class="col-sm-8">
                                                    '.$op['data'][0]['follow_note'].'
                                                </div>
                                            </div>
                                            
                                        </td>
                                    
                                        <td class="font-bold bt br">
                                            Sick Leave:
                                        </td>
                                        <td class="bt br">
                                            <div class="row">
                                                <div class="col-sm-4">
                                                    '.$op['data'][0]['sick_leave'].'
                                                </div>
                                                <div class="col-sm-4">
                                                    <label class="control-label " data-i18n="page.reception.role">From</label>
                                                    '.$op['data'][0]['sick_leave_from'].'
                                                </div>
                                                <div class="col-sm-4">
                                                    <label class="control-label " data-i18n="page.reception.role">To</label>
                                                    '.$op['data'][0]['sick_leave_to'].'
                                                </div>
                                            </div>
                                            <div class="row">
                                                    
                                                            
                                                <div class="col-sm-12">
                                                	<div >
			                                			'.nl2br($op['data'][0]['sick_leave_note']).'
			                                		</div>
                                                    
                                                </div>
                                            </div>
                                            
                                            
                                            
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br" width="15%">Referral to:</td>
                                        <td class=" bt  br">
                                            '.$op['data'][0]['referral_to'].'
                                        </td>
                                    
                                        <td class="font-bold bt br">
                                            Reason of Referral:
                                        </td>
                                        <td class="br bt">
                                            '.$op['data'][0]['reason_of_referral'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bt bl br" width="15%">Note:</td>
                                        
                                        <td colspan="3" class="br bt tj">
                                            '.$op['data'][0]['report_note'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bl bt br" width="15%">Discharge Summary</td>
                                        
                                        <td colspan="3" class="br bt tj">
                                            '.$op['data'][0]['discharge_summary'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="font-bold bl bt br bb" width="15%">Medical Report</td>
                                        
                                        <td colspan="3" class="br bt bb tj">
                                            '.$op['data'][0]['medical_report'].'
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                            
                            
                        </div>

                         ';

            $mpdf->WriteHTML("$tr");
            $mpdf->Output('document.pdf', 'I');

          

			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			echo json_encode($op);

			exit;
		}
	}

    if ($_GET['type'] == "merege_pdf_checkup") {

        $id = $_GET['edited_id'];


        $op  = array('is_success' => false, 'data' => array(), 'lab' => array(), 'radiology' => array(), 'treat' => array(), 'consultation' => array(), 'service' => array(), 'invoice' => array(), 'detail' => array());


        $res = $db->query("SELECT
                                        patient_checkup_id,
                                        chekup_reference_number,
                                        g_p_doctor,
                                        employer,
                                        work_site,
                                        date_of_examination,
                                        recommendations_for_review,
                                        examining_medical_officer,
                                        past_medical_history,
                                        past_surgical_history,
                                        is_allergies,
                                        PC.allergies,
                                        surgical_procedure,
                                        is_take_medication,
                                        list_medicine,
                                        is_smoke,
                                        somke_per_week,
                                        is_alcohol,
                                        unit_per_week,
                                        is_cough,
                                        is_wheeze,
                                        is_shortness_breath,
                                        is_hypertension,
                                        is_chest_pain,
                                        is_weight_change,
                                        is_bowel_change,
                                        is_neck_pain,
                                        is_hand_injury,
                                        is_joint_problem,
                                        is_nervous_disease,
                                        is_blackouts,
                                        is_weakness,
                                        is_psychiatric,
                                        is_hear_change,
                                        is_skin_problem,
                                        is_dermatitis,
                                        is_eczema,
                                        is_boils,
                                        is_cancers,
                                        is_other,
                                        patient_bedsite,
                                        patient_certificate,
                                        spirometer,
                                        audiometer,
                                        skin_other_describe,
                                        is_health_problem,
                                        health_problem,
                                        PC.patient_id_fk,
                                        PC.staff_id_fk,
                                        
                                        patient_checkup_detail_id,
                                        PCD.patient_checkup_id_fk,
                                        height,
                                        weight,
                                        bmi,
                                        rbs,
                                        spo2,
                                        pulse,
                                        is_regular,
                                        blood_presure_high,
                                        blood_presure_low,
                                        blood_sugar,
                                        glucose,
                                        protein,
                                        blood_sugar_level,
                                        cardiovascular,
                                        respiratory,
                                        fev1_measured,
                                        fev1_predict,
                                        fvc_measure,
                                        fvc_predict,
                                        abdominal_examination,
                                        central_nervous_system,
                                        neck_movements,
                                        shoulder_movements,
                                        elbow_movements,
                                        wrist_movements,
                                        hand_grips,
                                        limb_power,
                                        back_movements,
                                        squat_rise,
                                        foot_power,

                                        patient_checkup_item_id,
                                        PCI.patient_checkup_id_fk,
                                        vision_uncor_distance_rit,
                                        vision_uncor_distance_lft,
                                        vision_uncor_near_rit,
                                        vision_uncor_near_lft,
                                        vision_cor_distance_rit,
                                        vision_cor_distance_lft,
                                        vision_cor_near_rit,
                                        vision_cor_near_lft,
                                        visual_acuity,
                                        ishihara,
                                        visual_fields,
                                        whisper_test,
                                        comments,
                                        drug_test_given,
                                        drug_test_given_consent,
                                        drug_test_given_comment,
                                        position,
                                        is_capable_1,
                                        is_capable_2,
                                        is_capable_2_comment,
                                        is_capable_3,
                                        is_capable_3_comment,
                                        is_capable_4,
                                        print_name,
                                        print_date,

                                        patient_full_name,
                                        third_name,
                                        second_name,
                                        first_name,
                                        gender,
                                        patient_email,
                                        patient_address,
                                        patient_phone,
                                        
                                        patient_date_of_birth,
                                        blood_group,
                                        occupation,
                                        company_name,
                                        IFNULL(full_name,'') as site_doctor,
                                        P.insurance,
                                        P.company_id_fk,
                                        insurance_status

                                FROM patient_checkup PC
                                LEFT JOIN patient_checkup_detail PCD ON (PC.patient_checkup_id = PCD.patient_checkup_id_fk) 
                                LEFT JOIN patient_checkup_item PCI ON (PC.patient_checkup_id = PCI.patient_checkup_id_fk)   
                                LEFT JOIN patient P ON (PC.patient_id_fk = P.patient_id)    
                                LEFT JOIN company C ON (P.company_id_fk = C.company_id) 
                                LEFT JOIN staff S ON (PC.staff_id_fk = S.staff_id)  

                                WHERE PC.is_deleted = 0 AND PC.patient_checkup_id = $id 

                                ");

        $res2 = $db->query("SELECT
                                        lab_test_id,
                                        lab_test_date,
                                        result_note,
                                        result_file,
                                        result_conclusion,
                                        lab_test_status,
                                        test_type,
                                        PI.patient_id_fk,
                                        PI.staff_id_fk,
                                        to_doctor,
                                        IFNULL(S.full_name,to_doctor) as site_doctor,
                                        IFNULL(S2.full_name,'') as lab_doctor,
                                        lab_test_detail_id,
                                        product_id_fk,
                                        product_name,
                                        test_note,
                                        test_number,
                                        cost,
                                        sell,
                                        test_result,
                                        test_status,
                                        patient_full_name,
                                        patient_phone,
                                        gender,
                                        patient_date_of_birth,
                                        blood_group,
                                        allergies,
                                        company_name,
                                        occupation,
                                        reference_value,
                                        test_unit,
                                        attach_file,
                                        PI.patient_checkup_id_fk,
                                        PID.created_at,
                                        IFNULL(S3.full_name,'') as added_by,
                                        PID.created_by

                                FROM lab_test PI 
                                
                                LEFT JOIN patient P ON (PI.patient_id_fk = P.patient_id)    
                                LEFT JOIN company C ON (P.company_id_fk = C.company_id) 
                                LEFT JOIN lab_test_detail PID ON (PI.lab_test_id = PID.lab_test_id_fk)  
                                LEFT JOIN product PD ON (PID.product_id_fk = PD.product_id) 
                                
                                LEFT JOIN staff S ON (PI.staff_id_fk = S.staff_id)  
                                LEFT JOIN staff S2 ON (PI.created_by = S2.staff_id) 
                                LEFT JOIN staff S3 ON (PID.created_by = S3.staff_id)    

                                WHERE PI.is_deleted = 0 AND PID.is_deleted=0 AND PI.patient_checkup_id_fk = $id 

                                ");

        $res3 = $db->query("SELECT
                                        radiology_test_id,
                                        radiology_test_date,
                                        result_note,
                                        result_file,
                                        result_conclusion,
                                        radiology_test_status,
                                        test_type,
                                        PI.patient_id_fk,
                                        PI.staff_id_fk,
                                        to_doctor,
                                        IFNULL(S.full_name,to_doctor) as site_doctor,
                                        IFNULL(S2.full_name,'') as lab_doctor,
                                        radiology_test_detail_id,
                                        product_id_fk,
                                        product_name,
                                        test_note,
                                        test_number,
                                        cost,
                                        sell,
                                        test_result,
                                        test_status,
                                        patient_full_name,
                                        patient_phone,
                                        gender,
                                        patient_date_of_birth,
                                        blood_group,
                                        allergies,
                                        company_name,
                                        occupation,
                                        reference_value,
                                        test_unit,
                                        attach_file,
                                        PI.patient_checkup_id_fk,
                                        PID.created_at,
                                        IFNULL(S3.full_name,'') as added_by,
                                        PID.created_by

                                FROM radiology_test PI 
                                
                                LEFT JOIN patient P ON (PI.patient_id_fk = P.patient_id)    
                                LEFT JOIN company C ON (P.company_id_fk = C.company_id) 
                                LEFT JOIN radiology_test_detail PID ON (PI.radiology_test_id = PID.radiology_test_id_fk)    
                                LEFT JOIN product PD ON (PID.product_id_fk = PD.product_id) 
                                
                                LEFT JOIN staff S ON (PI.staff_id_fk = S.staff_id)  
                                LEFT JOIN staff S2 ON (PI.created_by = S2.staff_id) 
                                LEFT JOIN staff S3 ON (PID.created_by = S3.staff_id)    

                                WHERE PI.is_deleted = 0 AND PID.is_deleted=0 AND PI.patient_checkup_id_fk = $id 

                                ");

        $res4 = $db->query("SELECT
                                                    
                                    sell_detail_id,
                                    sell_id_fk,
                                    origin_from,
                                    product_id_fk

                            FROM sell_detail SD     


                            WHERE SD.is_deleted = 0  AND SD.patient_checkup_id_fk = $id ");

        $res5 = $db->query("SELECT
                                                            
                                lab_test_detail_item_id,
                                LTDI.item_test_note,
                                LTDI.item_test_result,
                                product_detail_id_fk,
                                lab_test_detail_id_fk,
                                product_detail_id,
                                product_detail_name,
                                detail_test_unit,
                                detail_reference_value

                            FROM lab_test_detail_item LTDI  

                            LEFT JOIN product_detail PD ON (PD.product_detail_id = LTDI.product_detail_id_fk AND PD.is_deleted=0)   

                            WHERE LTDI.is_deleted = 0  AND LTDI.patient_checkup_id_fk = $id ");


        if ($res) {


            while ($row = $res->fetch_assoc()) {

                $result['patient_checkup_id']           = $row['patient_checkup_id'];
                $result['chekup_reference_number']      = $row['chekup_reference_number'];
                $result['g_p_doctor']                   = $row['g_p_doctor'];
                $result['employer']                     = $row['employer'];
                $result['work_site']                    = $row['work_site'];
                $result['date_of_examination']          = $row['date_of_examination'];
                $result['recommendations_for_review']   = $row['recommendations_for_review'];
                $result['examining_medical_officer']    = $row['examining_medical_officer'];
                $result['past_medical_history']         = $row['past_medical_history'];
                $result['past_surgical_history']        = $row['past_surgical_history'];
                $result['is_allergies']                 = $row['is_allergies'];
                $result['allergies']                    = $row['allergies'];
                $result['surgical_procedure']           = $row['surgical_procedure'];
                $result['is_take_medication']           = $row['is_take_medication'];
                $result['list_medicine']                = $row['list_medicine'];
                $result['is_smoke']                     = $row['is_smoke'];
                $result['somke_per_week']               = $row['somke_per_week'];
                $result['is_alcohol']                   = $row['is_alcohol'];
                $result['unit_per_week']                = $row['unit_per_week'];
                $result['is_cough']                     = $row['is_cough'];
                $result['is_wheeze']                    = $row['is_wheeze'];
                $result['is_shortness_breath']          = $row['is_shortness_breath'];
                $result['is_hypertension']              = $row['is_hypertension'];
                $result['is_chest_pain']                = $row['is_chest_pain'];
                $result['is_weight_change']             = $row['is_weight_change'];
                $result['is_bowel_change']              = $row['is_bowel_change'];
                $result['is_neck_pain']                 = $row['is_neck_pain'];
                $result['is_hand_injury']               = $row['is_hand_injury'];
                $result['is_joint_problem']             = $row['is_joint_problem'];
                $result['is_nervous_disease']           = $row['is_nervous_disease'];
                $result['is_blackouts']                 = $row['is_blackouts'];
                $result['is_weakness']                  = $row['is_weakness'];
                $result['is_psychiatric']               = $row['is_psychiatric'];
                $result['is_hear_change']               = $row['is_hear_change'];
                $result['is_skin_problem']              = $row['is_skin_problem'];
                $result['is_dermatitis']                = $row['is_dermatitis'];
                $result['is_eczema']                    = $row['is_eczema'];
                $result['is_boils']                     = $row['is_boils'];
                $result['is_cancers']                   = $row['is_cancers'];
                $result['is_other']                     = $row['is_other'];
                $result['patient_bedsite']              = $row['patient_bedsite'];
                $result['patient_certificate']          = $row['patient_certificate'];
                $result['spirometer']                   = $row['spirometer'];
                $result['audiometer']                   = $row['audiometer'];
                $result['skin_other_describe']          = $row['skin_other_describe'];
                $result['is_health_problem']            = $row['is_health_problem'];
                $result['health_problem']               = $row['health_problem'];
                $result['patient_checkup_detail_id']    = $row['patient_checkup_detail_id'];
                $result['patient_checkup_id_fk']        = $row['patient_checkup_id_fk'];
                $result['height']                       = $row['height'];
                $result['weight']                       = $row['weight'];
                $result['bmi']                          = $row['bmi'];
                $result['rbs']                          = $row['rbs'];
                $result['spo2']                         = $row['spo2'];
                $result['pulse']                        = $row['pulse'];
                $result['is_regular']                   = $row['is_regular'];
                $result['blood_presure_high']           = $row['blood_presure_high'];
                $result['blood_presure_low']            = $row['blood_presure_low'];
                $result['blood_sugar']                  = $row['blood_sugar'];
                $result['glucose']                      = $row['glucose'];
                $result['protein']                      = $row['protein'];
                $result['blood_sugar_level']            = $row['blood_sugar_level'];
                $result['cardiovascular']               = $row['cardiovascular'];
                $result['respiratory']                  = $row['respiratory'];
                $result['fev1_measured']                = $row['fev1_measured'];
                $result['fev1_predict']                 = $row['fev1_predict'];
                $result['fvc_measure']                  = $row['fvc_measure'];
                $result['fvc_predict']                  = $row['fvc_predict'];
                $result['abdominal_examination']        = $row['abdominal_examination'];
                $result['central_nervous_system']       = $row['central_nervous_system'];
                $result['neck_movements']               = $row['neck_movements'];
                $result['shoulder_movements']           = $row['shoulder_movements'];
                $result['elbow_movements']              = $row['elbow_movements'];
                $result['wrist_movements']              = $row['wrist_movements'];
                $result['hand_grips']                   = $row['hand_grips'];
                $result['limb_power']                   = $row['limb_power'];
                $result['back_movements']               = $row['back_movements'];
                $result['squat_rise']                   = $row['squat_rise'];
                $result['foot_power']                   = $row['foot_power'];
                $result['patient_checkup_item_id']      = $row['patient_checkup_item_id'];
                $result['vision_uncor_distance_rit']    = $row['vision_uncor_distance_rit'];
                $result['vision_uncor_distance_lft']    = $row['vision_uncor_distance_lft'];
                $result['vision_uncor_near_rit']        = $row['vision_uncor_near_rit'];
                $result['vision_uncor_near_lft']        = $row['vision_uncor_near_lft'];
                $result['vision_cor_distance_rit']      = $row['vision_cor_distance_rit'];
                $result['vision_cor_distance_lft']      = $row['vision_cor_distance_lft'];
                $result['vision_cor_near_rit']          = $row['vision_cor_near_rit'];
                $result['vision_cor_near_lft']          = $row['vision_cor_near_lft'];
                $result['visual_acuity']                = $row['visual_acuity'];
                $result['ishihara']                     = $row['ishihara'];
                $result['visual_fields']                = $row['visual_fields'];
                $result['whisper_test']                 = $row['whisper_test'];
                $result['comments']                     = $row['comments'];
                $result['drug_test_given']              = $row['drug_test_given'];
                $result['drug_test_given_consent']      = $row['drug_test_given_consent'];
                $result['drug_test_given_comment']      = $row['drug_test_given_comment'];
                $result['position']                     = $row['position'];
                $result['is_capable_1']                 = $row['is_capable_1'];
                $result['is_capable_2']                 = $row['is_capable_2'];
                $result['is_capable_2_comment']         = $row['is_capable_2_comment'];
                $result['is_capable_3']                 = $row['is_capable_3'];
                $result['is_capable_3_comment']         = $row['is_capable_3_comment'];
                $result['is_capable_4']                 = $row['is_capable_4'];
                $result['print_name']                   = $row['print_name'];
                $result['print_date']                   = $row['print_date'];



                $result['patient_id_fk']            = $row['patient_id_fk'];
                $result['patient_full_name']        = $row['patient_full_name'];
                $result['first_name']               = $row['first_name'];
                $result['second_name']              = $row['second_name'];
                $result['third_name']               = $row['third_name'];
                $result['gender']                   = $row['gender'];
                $result['patient_date_of_birth']    = $row['patient_date_of_birth'];


                $result['patient_phone']            = $row['patient_phone'];
                $result['patient_email']            = $row['patient_email'];
                $result['patient_address']          = $row['patient_address'];
                $result['blood_group']              = $row['blood_group'];
                $result['allergies']                = $row['allergies'];
                $result['occupation']               = $row['occupation'];
                $result['company_name']             = $row['company_name'];
                $result['site_doctor']              = $row['site_doctor'];
                $result['insurance']                = $row['insurance'];
                $result['company_id_fk']            = $row['company_id_fk'];
                $result['insurance_status']         = $row['insurance_status'];

                array_push($op['data'], $result);
            }
            while ($row = $res2->fetch_assoc()) {


                $result3['lab_test_id'] = $row['lab_test_id'];
                $result3['lab_test_date']   = $row['lab_test_date'];
                $result3['result_note']             = $row['result_note'];
                $result3['result_file']             = $row['result_file'];
                $result3['result_conclusion']       = $row['result_conclusion'];
                $result3['lab_test_status']     = $row['lab_test_status'];
                $result3['test_type']   = $row['test_type'];
                $result3['patient_id_fk']           = $row['patient_id_fk'];
                $result3['staff_id_fk']             = $row['staff_id_fk'];
                $result3['to_doctor']               = $row['to_doctor'];
                $result3['patient_full_name']       = $row['patient_full_name'];
                $result3['patient_phone']           = $row['patient_phone'];
                $result3['lab_test_detail_id'] = $row['lab_test_detail_id'];
                $result3['product_id_fk']           = $row['product_id_fk'];
                $result3['product_name']            = $row['product_name'];
                $result3['test_unit']               = $row['test_unit'];
                $result3['reference_value']         = $row['reference_value'];
                $result3['test_note']   = $row['test_note'];
                $result3['cost']                    = $row['cost'];
                $result3['sell']                    = $row['sell'];
                $result3['test_result']             = $row['test_result'];
                $result3['test_status']             = $row['test_status'];
                $result3['patient_checkup_id_fk']   = $row['patient_checkup_id_fk'];
                $result3['site_doctor']             = $row['site_doctor'];
                $result3['test_number']     = $row['test_number'];
                $result3['lab_doctor']              = $row['lab_doctor'];
                $result3['gender']                  = $row['gender'];
                $result3['patient_date_of_birth']   = $row['patient_date_of_birth'];
                $result3['blood_group']             = $row['blood_group'];
                $result3['allergies']               = $row['allergies'];
                $result3['company_name']            = $row['company_name'];
                $result3['occupation']              = $row['occupation'];
                $result3['attach_file']             = $row['attach_file'];
                $result3['created_at']              = $row['created_at'];
                $result3['added_by']                = $row['added_by'];
                $result3['created_by']              = $row['created_by'];

                array_push($op['lab'], $result3);
            }

            while ($row = $res3->fetch_assoc()) {


                $result4['radiology_test_id'] = $row['radiology_test_id'];
                $result4['radiology_test_date']     = $row['radiology_test_date'];
                $result4['result_note']             = $row['result_note'];
                $result4['result_file']             = $row['result_file'];
                $result4['result_conclusion']       = $row['result_conclusion'];
                $result4['radiology_test_status']   = $row['radiology_test_status'];
                $result4['test_type']   = $row['test_type'];
                $result4['patient_id_fk']           = $row['patient_id_fk'];
                $result4['staff_id_fk']             = $row['staff_id_fk'];
                $result4['to_doctor']               = $row['to_doctor'];
                $result4['patient_full_name']       = $row['patient_full_name'];
                $result4['patient_phone']           = $row['patient_phone'];
                $result4['radiology_test_detail_id'] = $row['radiology_test_detail_id'];
                $result4['product_id_fk']           = $row['product_id_fk'];
                $result4['product_name']            = $row['product_name'];
                $result4['test_unit']               = $row['test_unit'];
                $result4['reference_value']         = $row['reference_value'];
                $result4['test_note']   = $row['test_note'];
                $result4['cost']                    = $row['cost'];
                $result4['sell']                    = $row['sell'];
                $result4['test_result']             = $row['test_result'];
                $result4['test_status']             = $row['test_status'];
                $result4['patient_checkup_id_fk']   = $row['patient_checkup_id_fk'];
                $result4['site_doctor']             = $row['site_doctor'];
                $result4['test_number']     = $row['test_number'];
                $result4['lab_doctor']              = $row['lab_doctor'];
                $result4['gender']                  = $row['gender'];
                $result4['patient_date_of_birth']   = $row['patient_date_of_birth'];
                $result4['blood_group']             = $row['blood_group'];
                $result4['allergies']               = $row['allergies'];
                $result4['company_name']            = $row['company_name'];
                $result4['occupation']              = $row['occupation'];
                $result4['attach_file']             = $row['attach_file'];
                $result4['created_at']              = $row['created_at'];
                $result4['added_by']                = $row['added_by'];
                $result4['created_by']              = $row['created_by'];

                array_push($op['radiology'], $result4);
            }

            while ($row = $res4->fetch_assoc()) {


                $result8['sell_detail_id']          = $row['sell_detail_id'];
                $result8['sell_id_fk']              = $row['sell_id_fk'];
                $result8['origin_from']             = $row['origin_from'];
                $result8['product_id_fk']           = $row['product_id_fk'];
                $result8['is_found']                = 0;

                array_push($op['invoice'], $result8);
            }

            while ($row = $res5->fetch_assoc()) {

                $result9['lab_test_detail_item_id'] = $row['lab_test_detail_item_id'];
                $result9['item_test_note']          = $row['item_test_note'];
                $result9['item_test_result']        = $row['item_test_result'];
                $result9['product_detail_id_fk']    = $row['product_detail_id_fk'];
                $result9['product_detail_id']       = $row['product_detail_id'];
                $result9['product_detail_name']     = $row['product_detail_name'];
                $result9['detail_test_unit']        = $row['detail_test_unit'];
                $result9['detail_reference_value']  = $row['detail_reference_value'];
                $result9['lab_test_detail_id_fk']   = $row['lab_test_detail_id_fk'];

                array_push($op['detail'], $result9);
            }

            $mpdf = new Mpdf([
                'margin_top' => 40,
                'margin_bottom' => 30,
                'default_font' => 'Kanit', // Arabic-supporting font
                'format' => 'A4',
                'mode' => 'utf-8',
                'orientation' => 'P',      // 'P' for Portrait, 'L' for Landscape
                'autoScriptToLang' => true,
                'autoLangToFont' => true,
            ]);



            // Header/Footer Setup
            $mpdf->SetHTMLHeader('
                <div style="text-align:center; padding:1px; border-bottom:2px solid #000;">
                    <table border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    <tr >
                                        <td width=20%>
                                            <img style="width:120px;" src="../'.$_GET['company_logo'].'">
                                        </td>
                                        <td width="55%" style="text-align:center; color:#0E59A5;">
                                            <span style="text-align:center;font-size:28px; font-weight:700; ">'.$_GET['company_name'].'</span>
                                            <br>
                                            Occupational Health Assessment
                                        </td>
                                        <td width=25%  style="text-align:start; font-size:12px;">
                                            Date:'.$op['data'][0]['date_of_examination'].'
                                            <br>
                                            Reference No.:'.$op['data'][0]['chekup_reference_number'].'
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                    </table>
                </div>
                
            ');

            $mpdf->SetHTMLFooter('
                <div style="text-align:center; padding:5px; border-top:1px solid #ccc;">
                    

                    <table class="table1 " border=0 cellpadding=0 cellspacing=0 style="width:99%; margin-top:15px;">
                        <tbody>
                            <tr class="top-cell">
                                <td class="top-cell" width="33%"  style="border:0px; text-align:left; font-size:11px;">
                                    Provided by '.$_GET['company_website'].'
                                </td>

                                <td class="top-cell" width="34%"  style="border:0px; text-align:center; font-size:11px;">
                                    Page {PAGENO} of {nbpg}
                                </td>

                                <td class="top-cell" width="33%"  style="text-align:right; font-size:11px; border:0px;">
                                    Version 3: 2025                                   
                                </td>
                                
                            </tr>

                        </tbody>
                    </table>
                </div>
            ');

            // CSS to prevent row breaking
            $css = '<style>
                            .top-cell {
                                vertical-align: top;
                            }
                            tr { 
                                page-break-inside: avoid !important; /* Keep rows intact */
                            }
                            
                            td {
                                font-size:16px;
                            }

                            .pad20{
                                padding-left:20px;
                            }

                            .pad5{
                                padding-bottom:4px;
                                padding-top:4px;
                            }

                            .b1{
                                border-bottom:1px solid #ebeaea;
                            }

                            .b1g{
                                border-bottom:1px solid #868686;
                            }
                            .f16{
                                font-size:12px !important;
                            }
                            .fw{
                                font-weight:bold;
                            }
                            .lnh1{
                                line-height:35px;
                            }

                            .table2 tbody tr:nth-child(even) {
                                background-color: #f8f9fa;
                            }

                            .table thead {
                                display: table-header-group;
                            }

                            .table th {
                                background-color: #808080;
                                
                                position: sticky;
                                top: 0;
                            }

                            .table-bordered td{
                                // border: 1px solid #000;
                                font-size:11.5px !important;
                                text-align:left ;
                                padding: 5px 1px;
                                border: 0.5px solid #9d9b9b;
                            }

                            .table-bordered-s td{
                                font-size:12px;
                                text-align:center;
                                padding: 5px 1px;
                            }



                            #patient_table_id td {
                                text-align:left !important;
                                border-left: 0px solid #9d9b9b !important;

                            }

                            #header_table td {
                                border: 0px solid #9d9b9b;
                            }
                            
                            .bg-primary{
                                background-color:grey;
                            }

                            .no_border td {
                                border: 0px !important;

                            }

                            .prestyle{
                                white-space: pre-wrap;
                                word-wrap: break-word;
                            }

                            #footer_first{         
                                        position:absolute;
                                        top:25.7cm;
                                        width: -webkit-fill-available;

                                        }

                            .hidden-attach{
                                display: none;
                            }

                            .font-bold{
                                font-weight: bold;
                                line-height: 20px;
                            }

                            .bb{
                                border-bottom: 0.5px solid #9d9b9b;
                            }
                            .bl{
                                border-left: 0.5px solid #9d9b9b;
                            }
                            .br{
                                border-right: 0.5px solid #9d9b9b;
                            }
                            .bt{
                                border-top: 0.5px solid #9d9b9b;
                            }
                            .tl{
                                text-align:left !important;
                            }
                            .nbl {
                                border-left: 0px solid #9d9b9b !important;
                            }
                            .nbb {
                                border-bottom: 0px solid #9d9b9b !important;
                            }

                            .nbt {
                                border-top: 0px solid #9d9b9b;
                            }

                            .nbr {
                                border-right: 0px solid #9d9b9b;
                            }

                            .tj{
                                text-align: justify !important;
                                text-justify: inter-word !important;
                            }

                            .break-page{
                                page-break-after:always;
                            }
                    </style>';




            $lab ='';
            $rad ='';
            $trt ='';
            $con ='';
            $ser ='';
            $tur ='';
            $l=0;
            $r=0;
            $t=0;
            

            for ($i = 0; $i < count($op['lab']); $i++) {

                if ($op['lab'][$i]['lab_test_id'] > 0) {
                    $t++;


                    $lab.='<tr class="bb">
                                    <td class="bb br bl">'.$t.'</td>
                                    <td class="bb br">
                                        '.$op['lab'][$i]['product_name'].'
                                    </td>
                                    <td class="bb br">
                                        '.$op['lab'][$i]['test_result'].'

                                    </td>
                                    <td class="bb br">
                                        '.$op['lab'][$i]['test_unit'].'

                                    </td>
                                    <td class="bb br">
                                        <div >
                                        '.nl2br($op['lab'][$i]['reference_value']).'
                                        </div>
                                    </td>
                                    <td class="bb br">
                                        '.$op['lab'][$i]['test_note'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['lab'][$i]['added_by'].'

                                    </td>

                                    <td class=" bb br ">
                                        '.$op['lab'][$i]['created_at'].'

                                    </td>

                                    
                                    
                                </tr>';
                
                }
            }



            $t=0;

            for ($i = 0; $i < count($op['radiology']); $i++) {

                if ($op['radiology'][$i]['radiology_test_id'] > 0) {
                    $t++;


                    $rad.='<tr class="clone_row">
                                    <td class="bb br bl">'.$t.'</td>
                                    <td class="bb br">
                                        '.$op['radiology'][$i]['product_name'].'
                                    </td>
                                    <td class="bb br">
                                        '.$op['radiology'][$i]['test_result'].'
                                    </td>
                                    
                                    <td class="bb br">
                                        '.$op['radiology'][$i]['test_note'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['radiology'][$i]['added_by'].'
                                    </td>

                                    <td class="bb br">
                                        '.$op['radiology'][$i]['created_at'].'
                                    </td>

                                    
                                    
                                </tr>';
                
                }
            }

            
            $yes    ='☐';
            $no     ='☐';

            $is_allergies       = $op['data'][0]['is_allergies'];
            
            if ($is_allergies == 1) {
                $yes    ='☑';
                $no     ='☐';
            }elseif($is_allergies == 2){
                $yes    ='☐';
                $no     ='☑';
            }

            $is_take_medication = $op['data'][0]['is_take_medication'];
            if ($is_take_medication == 1) {
                $yes1    ='☑';
                $no1     ='☐';
            }elseif($is_take_medication == 2){
                $yes1    ='☐';
                $no1     ='☑';
            }else{
                $yes1    ='☐';
                $no1     ='☐';
            }

            $chk = $op['data'][0]['is_smoke'];
            if ($chk == 1) {
                $yes2    ='☑';
                $no2     ='☐';
            }elseif($chk == 2){
                $yes2    ='☐';
                $no2     ='☑';
            }else{
                $yes2    ='☐';
                $no2     ='☐';
            }

            

            $chk = $op['data'][0]['is_alcohol'];
            if ($chk == 1) {
                $yes3    ='☑';
                $no3     ='☐';
            }elseif($chk == 2){
                $yes3    ='☐';
                $no3     ='☑';
            }else{
                $yes3    ='☐';
                $no3     ='☐';
            }


            $chk = $op['data'][0]['is_cough'];
            if ($chk == 1) {
                $yes4    ='☑';
                $no4     ='☐';
            }elseif($chk == 2){
                $yes4    ='☐';
                $no4     ='☑';
            }else{
                $yes4    ='☐';
                $no4     ='☐';
            }


            $chk = $op['data'][0]['is_wheeze'];
            if ($chk == 1) {
                $yes5    ='☑';
                $no5     ='☐';
            }elseif($chk == 2){
                $yes5    ='☐';
                $no5     ='☑';
            }else{
                $yes5    ='☐';
                $no5     ='☐';
            }


            $chk = $op['data'][0]['is_shortness_breath'];
            if ($chk == 1) {
                $yes6    ='☑';
                $no6     ='☐';
            }elseif($chk == 2){
                $yes6    ='☐';
                $no6     ='☑';
            }else{
                $yes6    ='☐';
                $no6     ='☐';
            }

            
            
            $chk = $op['data'][0]['is_hypertension'];
            if ($chk == 1) {
                $yes7    ='☑';
                $no7     ='☐';
            }elseif($chk == 2){
                $yes7    ='☐';
                $no7     ='☑';
            }else{
                $yes7    ='☐';
                $no7     ='☐';
            } 

            $chk = $op['data'][0]['is_chest_pain'];
            if ($chk == 1) {
                $yes8    ='☑';
                $no8     ='☐';
            }elseif($chk == 2){
                $yes8    ='☐';
                $no8     ='☑';
            }else{
                $yes8    ='☐';
                $no8     ='☐';
            } 

            $chk = $op['data'][0]['is_weight_change'];
            if ($chk == 1) {
                $yes9    ='☑';
                $no9     ='☐';
            }elseif($chk == 2){
                $yes9    ='☐';
                $no9     ='☑';
            }else{
                $yes9    ='☐';
                $no9     ='☐';
            } 

            $chk = $op['data'][0]['is_bowel_change'];
            if ($chk == 1) {
                $yes10    ='☑';
                $no10     ='☐';
            }elseif($chk == 2){
                $yes10    ='☐';
                $no10     ='☑';
            }else{
                $yes10    ='☐';
                $no10     ='☐';
            } 

            $chk = $op['data'][0]['is_neck_pain'];
            if ($chk == 1) {
                $yes11    ='☑';
                $no11     ='☐';
            }elseif($chk == 2){
                $yes11    ='☐';
                $no11     ='☑';
            }else{
                $yes11    ='☐';
                $no11     ='☐';
            } 

            $chk = $op['data'][0]['is_hand_injury'];
            if ($chk == 1) {
                $yes12    ='☑';
                $no12     ='☐';
            }elseif($chk == 2){
                $yes12    ='☐';
                $no12     ='☑';
            }else{
                $yes12    ='☐';
                $no12     ='☐';
            } 

            $chk = $op['data'][0]['is_joint_problem'];
            if ($chk == 1) {
                $yes13    ='☑';
                $no13     ='☐';
            }elseif($chk == 2){
                $yes13    ='☐';
                $no13     ='☑';
            }else{
                $yes13    ='☐';
                $no13     ='☐';
            }

            $chk = $op['data'][0]['is_nervous_disease'];
            if ($chk == 1) {
                $yes14    ='☑';
                $no14     ='☐';
            }elseif($chk == 2){
                $yes14    ='☐';
                $no14     ='☑';
            }else{
                $yes14    ='☐';
                $no14     ='☐';
            } 

            $chk = $op['data'][0]['is_blackouts'];
            if ($chk == 1) {
                $yes15    ='☑';
                $no15     ='☐';
            }elseif($chk == 2){
                $yes15    ='☐';
                $no15     ='☑';
            }else{
                $yes15    ='☐';
                $no15     ='☐';
            }

            $chk = $op['data'][0]['is_weakness'];
            if ($chk == 1) {
                $yes16    ='☑';
                $no16     ='☐';
            }elseif($chk == 2){
                $yes16    ='☐';
                $no16     ='☑';
            }else{
                $yes16    ='☐';
                $no16     ='☐';
            }

            $chk = $op['data'][0]['is_psychiatric'];
            if ($chk == 1) {
                $yes17    ='☑';
                $no17     ='☐';
            }elseif($chk == 2){
                $yes17    ='☐';
                $no17     ='☑';
            }else{
                $yes17    ='☐';
                $no17     ='☐';
            }

            $chk = $op['data'][0]['is_hear_change'];
            if ($chk == 1) {
                $yes18    ='☑';
                $no18     ='☐';
            }elseif($chk == 2){
                $yes18    ='☐';
                $no18     ='☑';
            }else{
                $yes18    ='☐';
                $no18     ='☐';
            }

            $chk = $op['data'][0]['is_skin_problem'];
            if ($chk == 1) {
                $yes19    ='☑';
                $no19     ='☐';
            }elseif($chk == 2){
                $yes19    ='☐';
                $no19     ='☑';
            }else{
                $yes19    ='☐';
                $no19     ='☐';
            }

            $chk = $op['data'][0]['is_cancers'];
            if ($chk == 1) {
                $yes20    ='☑';
                $no20     ='☐';
            }elseif($chk == 2){
                $yes20    ='☐';
                $no20     ='☑';
            }else{
                $yes20    ='☐';
                $no20     ='☐';
            }

            $chk = $op['data'][0]['is_dermatitis'];
            if ($chk == 1) {
                $yes21    ='☑';
                $no21     ='☐';
            }elseif($chk == 2){
                $yes21    ='☐';
                $no21     ='☑';
            }else{
                $yes21    ='☐';
                $no21     ='☐';
            }

            $chk = $op['data'][0]['is_eczema'];
            if ($chk == 1) {
                $yes22    ='☑';
                $no22     ='☐';
            }elseif($chk == 2){
                $yes22    ='☐';
                $no22     ='☑';
            }else{
                $yes22    ='☐';
                $no22     ='☐';
            }

            $chk = $op['data'][0]['is_boils'];
            if ($chk == 1) {
                $yes23    ='☑';
                $no23     ='☐';
            }elseif($chk == 2){
                $yes23    ='☐';
                $no23     ='☑';
            }else{
                $yes23    ='☐';
                $no23     ='☐';
            } 

            $chk = $op['data'][0]['is_other'];
            if ($chk == 1) {
                $yes24    ='☑';
                $no24     ='☐';
            }elseif($chk == 2){
                $yes24    ='☐';
                $no24     ='☑';
            }else{
                $yes24    ='☐';
                $no24     ='☐';
            }

            $chk = $op['data'][0]['is_health_problem'];
            if ($chk == 1) {
                $yes25    ='☑';
                $no25     ='☐';
            }elseif($chk == 2){
                $yes25    ='☐';
                $no25     ='☑';
            }else{
                $yes25    ='☐';
                $no25     ='☐';
            }

            $chk = $op['data'][0]['is_regular'];
            if ($chk == 1) {
                $yes26    ='☑';
                $no26     ='☐';
            }elseif($chk == 2){
                $yes26    ='☐';
                $no26     ='☑';
            }else{
                $yes26    ='☐';
                $no26     ='☐';
            }

            $chk = $op['data'][0]['neck_movements'];
            if ($chk == 1) {
                $yes27    ='☑';
                $no27     ='☐';
            }elseif($chk == 2){
                $yes27    ='☐';
                $no27     ='☑';
            }else{
                $yes27    ='☐';
                $no27     ='☐';
            }

            $chk = $op['data'][0]['shoulder_movements'];
            if ($chk == 1) {
                $yes28    ='☑';
                $no28     ='☐';
            }elseif($chk == 2){
                $yes28    ='☐';
                $no28     ='☑';
            }else{
                $yes28    ='☐';
                $no28     ='☐';
            }

            $chk = $op['data'][0]['elbow_movements'];
            if ($chk == 1) {
                $yes29    ='☑';
                $no29     ='☐';
            }elseif($chk == 2){
                $yes29    ='☐';
                $no29     ='☑';
            }else{
                $yes29    ='☐';
                $no29     ='☐';
            }

            $chk = $op['data'][0]['wrist_movements'];
            if ($chk == 1) {
                $yes30    ='☑';
                $no30     ='☐';
            }elseif($chk == 2){
                $yes30    ='☐';
                $no30     ='☑';
            }else{
                $yes30    ='☐';
                $no30     ='☐';
            }

            $chk = $op['data'][0]['hand_grips'];
            if ($chk == 1) {
                $yes31    ='☑';
                $no31     ='☐';
            }elseif($chk == 2){
                $yes31    ='☐';
                $no31     ='☑';
            }else{
                $yes31    ='☐';
                $no31     ='☐';
            }

            $chk = $op['data'][0]['limb_power'];
            if ($chk == 1) {
                $yes32    ='☑';
                $no32     ='☐';
            }elseif($chk == 2){
                $yes32    ='☐';
                $no32     ='☑';
            }else{
                $yes32    ='☐';
                $no32     ='☐';
            }

            $chk = $op['data'][0]['back_movements'];
            if ($chk == 1) {
                $yes33    ='☑';
                $no33     ='☐';
            }elseif($chk == 2){
                $yes33    ='☐';
                $no33     ='☑';
            }else{
                $yes33    ='☐';
                $no33     ='☐';
            }

            $chk = $op['data'][0]['squat_rise'];
            if ($chk == 1) {
                $yes34    ='☑';
                $no34     ='☐';
            }elseif($chk == 2){
                $yes34    ='☐';
                $no34     ='☑';
            }else{
                $yes34    ='☐';
                $no34     ='☐';
            }

            $chk = $op['data'][0]['foot_power'];
            if ($chk == 1) {
                $yes35    ='☑';
                $no35     ='☐';
            }elseif($chk == 2){
                $yes35    ='☐';
                $no35     ='☑';
            }else{
                $yes35    ='☐';
                $no35     ='☐';
            }

            $chk = $op['data'][0]['is_capable_1'];
            if ($chk == 1) {
                $yes36    ='☑';
                $no36     ='☐';
            }elseif($chk == 2){
                $yes36    ='☐';
                $no36     ='☑';
            }else{
                $yes36    ='☐';
                $no36     ='☐';
            }

            $chk = $op['data'][0]['is_capable_2'];
            if ($chk == 1) {
                $yes37    ='☑';
                $no37     ='☐';
            }elseif($chk == 2){
                $yes37    ='☐';
                $no37     ='☑';
            }else{
                $yes37    ='☐';
                $no37     ='☐';
            }

            $chk = $op['data'][0]['is_capable_3'];
            if ($chk == 1) {
                $yes38    ='☑';
                $no38     ='☐';
            }elseif($chk == 2){
                $yes38    ='☐';
                $no38     ='☑';
            }else{
                $yes38    ='☐';
                $no38     ='☐';
            }

            $chk = $op['data'][0]['is_capable_4'];
            if ($chk == 1) {
                $yes39    ='☑';
                $no39     ='☐';
            }elseif($chk == 2){
                $yes39    ='☐';
                $no39     ='☑';
            }else{
                $yes39    ='☐';
                $no39     ='☐';
            }

            $patient_bedsite        = $op['data'][0]['patient_bedsite'] != null ?'Attached':'';
            $patient_certificate    = $op['data'][0]['patient_certificate'] != null ?'Attached':'';
            $spirometer             = $op['data'][0]['spirometer'] != null ?'Attached':'';
            $audiometer             = $op['data'][0]['audiometer'] != null ?'Attached':'';
                        
            $tr = '
                        <center>
                            
                            '.$css.'

                            <table  class="table table-bordered" border=0 cellpadding=0 cellspacing=0 style="width:99%; " >
                                <tbody>

                                    <tr >
                                        <td colspan=6 class="bt br bl " style="text-align:center;">
                                            SECTION 1:
                                            <br>
                                            To be Completed by Employee
                                        </td>
                                        
                                    </tr>


                                    <tr >
                                        <td class="bt br bl ">
                                            Surename:
                                        </td>
                                        <td class="bt br" colspan="2">
                                            '.$op['data'][0]['third_name'].'                                          
                                        </td>

                                        <td class="bt br">
                                            Forename(s):
                                        </td>
                                        <td class="bt br bl" colspan="2">
                                            '.$op['data'][0]['first_name'].'                                            
                                        </td>
                                    </tr>

                                    <tr class="border ">
                                        <td class="">
                                            Date of Birth
                                        </td>
                                        <td>
                                            '.$op['data'][0]['patient_date_of_birth'].'
                                        </td>

                                        <td class="">
                                            (yyyy-mm-dd)
                                        </td>
                                        <td>
                                            '.$op['data'][0]['gender'].'
                                        </td>

                                        <td class="">
                                            Patient ID
                                        </td>
                                        <td>
                                            '.$op['data'][0]['patient_id_fk'].'
                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td class="">
                                            Contact Address:
                                        </td>
                                        
                                        <td colspan="5">
                                            '.$op['data'][0]['patient_address'].'
                                        </td>

                                    

                                    </tr>

                                    <tr class="border">
                                        <td class="">
                                            Contact telephone /email
                                        </td>
                                        <td colspan="2">
                                            '.$op['data'][0]['patient_phone'].'
                                        </td>

                                        <td class="">
                                            /
                                        </td>
                                        <td colspan="2">
                                            '.$op['data'][0]['patient_email'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="">
                                            G.P./Doctor:
                                        </td>
                                        <td colspan="5">
                                            '.$op['data'][0]['g_p_doctor'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td class="">
                                            Contact No (ideally cell phone) + country code
                                        </td>
                                        <td >
                                            '.$op['data'][0]['patient_phone'].'
                                        </td>

                                        <td class="">
                                            Company
                                        </td>
                                        <td >
                                            '.$op['data'][0]['company_name'].'
                                        </td>

                                        <td class="">
                                            Occupation
                                        </td>
                                        <td >
                                            '.$op['data'][0]['occupation'].'
                                        </td>
                                    </tr>

                                </tbody>
                            </table>
                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td colspan=2 class="" style="text-align:center;">
                                            MEDICAL HISTORY
                                        </td>
                                        
                                    </tr>

                                    <tr class="border">
                                        <td  class="">
                                            Past Medical History:
                                            '.$op['data'][0]['past_medical_history'].'
                                        </td>
                                        <td width="20%">
                                            
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  class="">
                                            Past Surgical History:
                                            '.$op['data'][0]['past_surgical_history'].'
                                        </td>
                                        <td >
                                            
                                        </td>
                                    </tr>



                                    <tr class="border">
                                        <td  class="" width="80%">
                                            Do you suffer from any allergies?
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no.'</span> No

                                        </td>
                                        
                                    </tr>

                                    <tr class="border">
                                        <td  class="">
                                            If yes please give details:
                                            '.$op['data'][0]['allergies'].'
                                        </td>
                                        <td >
                                            
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td  colspan=4>
                                            Please give details of <i><b>all</b></i> surgical procedures & long-term or recurring medical conditions (e.g.Diabetes/Epilepsy):
                                            <br>
                                            '.$op['data'][0]['surgical_procedure'].'
                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td  colspan=3>
                                            Are you taking any medication(s) prescribed by a doctor?
                                        </td>
                                        <td>
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes1.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no1.'</span> No
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  colspan=4>
                                            Please list all medication:
                                            '.$op['data'][0]['list_medicine'].'
                                        </td>

                                    </tr>

                                    <tr class="border">
                                        <td >
                                            Do you smoke?
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes2.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no2.'</span> No
                                        </td>
                                        <td >
                                            Number per week:
                                        </td>
                                        <td >
                                            '.$op['data'][0]['somke_per_week'].'
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td >
                                            Do you drink alcohol?
                                        </td>
                                        <td>
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes3.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no3.'</span> No
                                        </td>
                                        <td >
                                            Units per week:
                                        </td>
                                        <td >
                                            '.$op['data'][0]['unit_per_week'].'
                                        </td>
                                    </tr>


                                </tbody>
                            </table>
                             <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>

                                    <tr class="border">
                                        <td  width="85%">
                                            Do you usually cough when you first get up or during the day?
                                        </td>
                                        <td >
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes4.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no4.'</span> No
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                            Have you noticed a wheeze in your chest in the past 3 years?
                                        </td>
                                        <td >
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes5.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no5.'</span> No
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                           Do you experience shortness of breath?
                                        </td>
                                        <td >
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes6.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no6.'</span> No
                                        </td>
                                    </tr>

                                    
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>

                                    <tr class="border">
                                        <td  width="85%">
                                            Do you suffer from hypertension (high blood pressure)?
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes7.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no7.'</span> No
                                           
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                            Have you ever suffered from, or do you currently suffer from, chest pain or discomfort?
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes8.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no8.'</span> No
                                           
                                        </td>
                                    </tr>
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td  width="85%">
                                           Have you noticed any unintentional change in your weight recently (more than 5kg up or down)?
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes9.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no9.'</span> No
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                           Have you noticed a change in your bowel movements/habits that have persisted for more than 6 weeks (e.g. tendency for constipation or diarrhoea) or had dark or blood stained stools?
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes10.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no10.'</span> No
                                           
                                        </td>
                                    </tr>

                                    
                                </tbody>
                            </table>
                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>

                                    <tr class="border">
                                        <td  width="85%">
                                            Have you ever had neck pain or pain in your back that has kept you off work or caused you to be assigned alternative duties?
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes11.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no11.'</span> No
                                           
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                           Have you ever had a shoulder, arm or hand injury that has kept you off work?
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes12.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no12.'</span> No
                                           
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                           Have you ever had problems with any other joints which resulted in time off work or caused you to be assigned alternative duties?
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes13.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no13.'</span> No
                                           
                                        </td>
                                    </tr>

                                    
                                </tbody>
                            </table>

                            <br>
                            
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>

                                    <tr class="border">
                                        <td  width="85%">
                                            Have you ever been diagnosed with a disease or disorder of the nervous system?
                                        </td>
                                        <td >
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes14.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no14.'</span> No
                                            
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                            Have you ever suffered blackouts ( fainting) or seizures (fits)?
                                        </td>
                                        <td >
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes15.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no15.'</span> No
                                            
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                           Have you ever suffered episodes of numbness or weakness?
                                        </td>
                                        <td >
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes16.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no16.'</span> No
                                            
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                           Have you ever been diagnosed with a psychiatric illness (including anxiety or depression)?
                                        </td>
                                        <td >
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes17.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no17.'</span> No
                                            
                                        </td>
                                    </tr>

                                    
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>

                                    <tr class="border">
                                        <td  width="85%">
                                            Have you noticed any changes in your hearing in the past three years?
                                        </td>
                                        <td >
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes18.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no18.'</span> No
                                            
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                            Have you had any skin problems?
                                        </td>
                                        <td >
                                           <span style="font-size:14px; font-family: DejaVuSans;">'.$yes19.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no19.'</span> No
                                            
                                        </td>
                                    </tr>
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td   colspan=2>
                                           If Yes, what was the nature of the problem?
                                            <br>
                                            <br>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes20.'</span> Skin cancers
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes21.'</span> Dermatitis
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes22.'</span> Eczema
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes23.'</span> Boils or fungal infections
                                           
                                            <br>
                                            <br>
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  >
                                            <br>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes24.'</span> Other (describe/diagnosis)
                                           
                                            <br>
                                        </td>
                                        <td >
                                           '.$op['data'][0]['skin_other_describe'].'
                                        </td>
                                    </tr>

                                    
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td  width="85%">
                                            Do you suffer from any other health complaint not mentioned above?
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes25.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no25.'</span> No
                                           
                                        </td>
                                    </tr>

                                    <tr class="border" style="height:80px;">
                                        <td  >
                                           If yes please give details:
                                           <br>
                                           '.$op['data'][0]['health_problem'].'
                                        </td>
                                        <td >
                                           
                                        </td>
                                    </tr>

                                    
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td  colspan=2>
                                            <b>Employee’s Declaration</b>
                                        </td>
                                        
                                    </tr>
                                    <tr class="border">
                                        <td  colspan=2>
                                            <br>
                                            I certify to the best of my knowledge that the above information is true. I understand that there may be significant employment implications if I have intentionally given false information
                                            <br>
                                            <br>
                                        
                                        </td>
                                        
                                    </tr>

                                    <tr class="border">
                                        <td  >
                                           Signature:
                                           <br>
                                           <br>
                                           <br>
                                        </td>
                                        <td >
                                           Date:
                                           <br>
                                           <br>
                                           <br>
                                        </td>
                                    </tr>

                                    
                                </tbody>
                            </table>


                            <div class="break-page"></div>
                            
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; border-right:1px solid #9d9b9b; border-top:1px solid #9d9b9b;" >
                                <tbody>
                                    <tr class="border">
                                        <td  style="text-align:center;">
                                            <b>SECTION 2:</b>
                                            <br>
                                            <br>
                                            <b>To be Completed by Examining Medical Officer</b>
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td  width="15%">
                                            HEIGHT (cm)
                                        </td>
                                        <td width="15%">
                                            '.$op['data'][0]['height'].'
                                        </td>

                                        <td  width="15%">
                                            WEIGHT (kg)
                                        </td>
                                        <td width="15%">
                                            '.$op['data'][0]['weight'].'
                                        </td>

                                        <td  width="10%">
                                            BMI
                                        </td>
                                        <td width="10%">
                                            '.$op['data'][0]['bmi'].'
                                        </td>

                                        <td  width="10%">
                                            RBS
                                        </td>
                                        <td width="10%">
                                            '.$op['data'][0]['rbs'].'
                                        </td>

                                        <td  width="10%">
                                            SPO2
                                        </td>
                                        <td width="10%">
                                            '.$op['data'][0]['spo2'].'
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td >
                                            Pulse
                                        </td>
                                        <td style="text-align:center;">
                                            '.$op['data'][0]['pulse'].' Per min
                                            <br>
                                            <br>
                                            Regular ?
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes26.'</span> Yes
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no26.'</span> No
                                            
                                        </td>

                                        <td >
                                            Blood Pressure
                                        </td>
                                        <td>
                                            '.$op['data'][0]['blood_presure_high'].' / '.$op['data'][0]['blood_presure_low'].' mmHg
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>
                            
                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border" style="height:70px;">
                                        <td style="height:70px;">
                                            <b>Cardiovascular System:</b> Medical Examiners Comments:
                                            <br>
                                            '.$op['data'][0]['cardiovascular'].'
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border" style="height:60px;">
                                        <td style="height:60px;">
                                            <b>Respiratory:</b> Medical Examiners Comments:
                                            <br>
                                            '.$op['data'][0]['respiratory'].'
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>
                            

                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border" style="height:70px;">
                                        <td style="height:70px;">
                                            <b>Abdominal Examination:</b> Medical Examiners Comments:
                                            <br>
                                            '.$op['data'][0]['abdominal_examination'].'
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>
                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border" style="height:70px;">
                                        <td style="height:70px;">
                                            <b>Central Nervous System:</b> Medical Examiners Comments:
                                            <br>
                                            '.$op['data'][0]['central_nervous_system'].'
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>
                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>

                                    <tr class="border">
                                        <td  width="85%">
                                            Musculoskeletal System <br>
                                            [[If abnormal express as percentage of full range]]
                                        </td>
                                        <td >
                                            Normal
                                        </td>
                                        <td>
                                            Abnormal
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                            Range of neck movements: Flexion, extension, lateral movement and rotation
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes27.'</span>
                                            
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no27.'</span>
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                            Range of shoulder movements: Rt & Lt. Flexion, extension, abduction, internal and external rotation
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes28.'</span>
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no28.'</span>
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                            Range of elbow movements: Rt & Lt. Flexion, extension, pronation and supination
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes29.'</span>
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no29.'</span>
                                        </td>
                                    </tr>
                                    <tr class="border">
                                        <td  width="85%">
                                            Range of wrist movements: Rt & Lt. Flexion & extension
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes30.'</span>
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no30.'</span>
                                        </td>
                                    </tr>
                                    <tr class="border">
                                        <td  width="85%">
                                            Hand grips: Rt & Lt.
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes31.'</span>
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no31.'</span>
                                        </td>
                                    </tr>
                                    <tr class="border">
                                        <td  width="85%">
                                            Upper limb power of resisted flexion and extension: Rt & Lt.
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes32.'</span>
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no32.'</span>
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                            Range of back movements: Flexion, extension, lateral movement and rotation
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes33.'</span>
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no33.'</span>
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                           Squat & rise:
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes34.'</span>
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no34.'</span>
                                        </td>
                                    </tr>

                                    <tr class="border">
                                        <td  width="85%">
                                           Power of dorsiflexion in each foot: (e.g. ability to sustain standing on each foot independently for 10 seconds)
                                        </td>
                                        <td >
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes35.'</span>
                                        </td>
                                        <td>
                                            <span style="font-size:14px; font-family: DejaVuSans;">'.$no35.'</span>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                            <br>
                                At the date of this examination the worker:-
                            <br>
                            <br>
                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes36.'</span>
                            1. Is capable of undertaking all work activities as indicated in the risk assessment information for the proposed position
                            <br>
                            <br>
                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes37.'</span>
                            2. Is capable of most work activities but has a medical condition for which some accommodation may be appropriate in the following areas: -
                            <br>
                                <ul>
                                    <li>'.$op['data'][0]['is_capable_2_comment'].'</li>
                                    
                                </ul>
                            <br>
                            <br>
                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes38.'</span>
                            3. Is capable of most work activities but has a medical condition which results in the following restrictions: -
                            <br>
                                <ul>
                                    <li>'.$op['data'][0]['is_capable_3_comment'].'</li>
                                    
                                </ul>
                            <br>
                            <br>
                            <span style="font-size:14px; font-family: DejaVuSans;">'.$yes39.'</span>
                            4. Currently has a medical condition for which any work activity is inappropriate
                            <br>
                            <br>
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td width="25%">
                                            Patient Bedsite:
                                        </td>
                                        <td width="25%">
                                            <br>
                                                '.$patient_bedsite.'
                                            <br>
                                        </td>
                                        <td width="25%">
                                            Patient Certificate:
                                        </td>
                                        <td width="25%">
                                            <br>
                                                '.$patient_certificate.'
                                                
                                            <br>
                                        </td>
                                        
                                    </tr>

                                    <tr class="border">
                                        <td width="25%">
                                            Spirometer:
                                        </td>
                                        <td width="25%">
                                            <br>
                                            '.$spirometer.'
                                                
                                            <br>
                                        </td>
                                        <td width="25%">
                                            Audiometer:
                                        </td>
                                        <td width="25%">
                                            <br>
                                                '.$audiometer.'
                                                
                                            <br>
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>
                            <br>

                            Recommendations for review, additional assessment or ongoing health surveillance:
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td style="height:100px;">
                                            <br>
                                            '.$op['data'][0]['recommendations_for_review'].'
                                            <br>
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>

                            <br>

                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; " >
                                <tbody>
                                    <tr class="border">
                                        <td  colspan=2>
                                            Examining Medical Officer / OHA Signature: '.$op['data'][0]['examining_medical_officer'].'
                                            <br>
                                            <br>
                                            <br>
                                            <div class="row">
                                                <div class="col-sm-6" style="float:left">
                                                    Print Name: '.$op['data'][0]['print_name'].'
                                                </div>

                                                <div class="col-sm-6" style="float:right">
                                                    Date: '.$op['data'][0]['print_date'].'
                                                </div>
                                            </div>
                                        </td>
                                        
                                    </tr>
                                    
                                </tbody>
                            </table>

                            
                        </center>

                         ';

            $mpdf->WriteHTML("$tr");

            $file_path = "../patient-file/$id/checkup_$id.pdf";

            $mpdf->Output($file_path, 'F');


            
        } else {
            $op['is_success'] = false;
            $op['data']       = $db->error;
            echo json_encode($op);

            exit;
        }







        // +++++++++++++++++++++++++++++++++++++++

        // Merege PDF File after Create Checkup File

        $res = $db->query("SELECT   
                                    patient_bedsite,
                                    patient_certificate,
                                    spirometer,
                                    audiometer

                                FROM patient_checkup 
                                WHERE is_deleted = 0 AND patient_checkup_id=$id");
        $files = [];
        
        if ($res) {
            while ($row = $res->fetch_assoc()) {
                // $files[] = "../".$row['patient_bedsite'];
                // $files[] = "../".$row['patient_certificate'];
                // $files[] = "../".$row['spirometer'];
                // $files[] = "../".$row['audiometer'];

                $path0 = "../patient-file/$id/checkup_$id.pdf";
                $path1 = "../".$row['patient_bedsite'];
                $path2 = "../".$row['patient_certificate'];
                $path3 = "../".$row['spirometer'];
                $path4 = "../".$row['audiometer'];
    
                // Validate path before adding
                if (!empty($path0) && is_string($path0)) {
                    $files[] = $path0;
                }

                // Validate path before adding
                if (!empty($path1) && is_string($path1)) {
                    $files[] = $path1;
                }

                if (!empty($path2) && is_string($path2)) {
                    $files[] = $path2;
                }

                if (!empty($path3) && is_string($path3)) {
                    $files[] = $path3;
                }

                if (!empty($path4) && is_string($path4)) {
                    $files[] = $path4;
                }
            }
           
        }

        if (empty($files)) {
            $op['is_success'] = false;
            $op['data'] = 'No File to be merge';
            echo json_encode($op);
            exit;
        }

        try {
            $mpdf = new Mpdf([
                'mode' => 'utf-8',
                'tempDir' => __DIR__ . '/tmp', // Recommended for large files
                'setAutoTopMargin' => 'pad'
            ]);
            
            // $mpdf->SetImportUse(); // Enable PDF import

            foreach ($files as $file) {
                // 1. Check if path exists
                if (!file_exists($file)) {
                    error_log("File not found: $file");
                    continue;
                }
                
                // 2. Check if it's a directory
                if (is_dir($file)) {
                    error_log("Path is a directory, not file: $file");
                    continue;
                }
                
                // 3. Verify it's a PDF file
                if (strtolower(pathinfo($file, PATHINFO_EXTENSION)) !== 'pdf') {
                    error_log("Not a PDF file: $file");
                    continue;
                }

                // 4. Try to get page count
                try {
                    $pageCount = $mpdf->SetSourceFile($file);
                } catch (\Exception $e) {
                    error_log("Invalid PDF: $file - " . $e->getMessage());
                    continue;
                }
                
                if ($pageCount < 1) {
                    error_log("Empty PDF: $file");
                    continue;
                }
                
                for ($pageNo = 1; $pageNo <= $pageCount; $pageNo++) {
                    try {
                        $templateId = $mpdf->ImportPage($pageNo);
                        $size = $mpdf->getTemplateSize($templateId);
                        
                        if (!$size || empty($size['width']) || empty($size['height'])) {
                            $width = 210;  // Default A4 width (mm)
                            $height = 297; // Default A4 height (mm)
                        } else {
                            $width = $size['width'];
                            $height = $size['height'];
                        }
                        
                        $orientation = ($width > $height) ? 'L' : 'P';
                        
                        $mpdf->AddPage(
                            $orientation,
                            '',
                            0,
                            '',
                            '',
                            10, 10, 10, 10, // margins
                            9, 9,           // header/footer
                            [$width, $height]
                        );
                        
                        $mpdf->UseTemplate($templateId);
                    } catch (\Exception $e) {
                        error_log("Error processing page $pageNo in $file: " . $e->getMessage());
                    }
                }
            }
            
            if ($mpdf->page === 0) {
                die("No valid PDF pages were processed");
            }
            
            // Output merged PDF
            $file_path = "merge_document.pdf";
            $mpdf->Output($file_path, 'I'); // Force download
            
        } catch (\Exception $e) {
            die("PDF Merge Error: " . $e->getMessage());
        }
    }

    


} else {
    header("Location:../");
    exit;
}






?>

