
var table ;
var STOCK_LIST, FORM_LIST, ROUTE_LIST;

function edit_items(itemid){
  

    $("#edit_form")[0].reset();

    $("#edited_id").val(itemid);
 

    $.ajax({
      url: "models/crul_invoice.php",
      type:"POST",
      dataType : "JSON",
      data:{   "type":"get_edit",
                "edited_id":itemid,
                
            } ,
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {


        if(res.is_success == true){

            $("#edit_invoice_year").val(res.data[0].invoice_year);
            $("#edit_invoice_date").val(res.data[0].invoice_date);
            $("#edit_invoice_type").val(res.data[0].invoice_type);
            $("#edit_invoice_total_price").val(res.data[0].invoice_total_price);
            $("#edit_invoice_total_discount").val(res.data[0].invoice_total_discount);
            $("#edit_percentage_discount").val(res.data[0].percentage_discount);
            $("#edit_general_discount").val(res.data[0].general_discount);
            $("#edit_discount_type").val(res.data[0].discount_type);
            $("#edit_paid_amount").val(res.data[0].paid_amount);
            $("#edit_sell_note").val(res.data[0].sell_note);
            $("#edit_person_name").val(res.data[0].person_name);

            $("#edit_gender").val(res.data[0].gender);
            $("#edit_dob").val(res.data[0].patient_date_of_birth);
            $("#edit_blood_group").val(res.data[0].blood_group);
            $("#edit_allergies").val(res.data[0].allergies);
            $("#edit_company_name").val(res.data[0].company_name);
            $("#edit_occupation").val(res.data[0].occupation);



            var data = {
                id: res.data[0].patient_id_fk,
                text: res.data[0].patient_full_name
            };

            if ($('#edit_patient_id_fk').find("option[value='" + data.id + "']").length) {
                $('#edit_patient_id_fk').val(data.id).trigger('change');
            } else { 
                var newOption = new Option(data.text, data.id, true, true);
                $('#edit_patient_id_fk').append(newOption).trigger('change');
            } 




            var $tr =``;
            var l=0;
            for (var i = 0; i < res.data.length; i++) {

                if (res.data[i].sell_detail_id > 0) {
                    l++;
                    var data = {
                            id: res.data[i].product_id_fk,
                            text: res.data[i].product_name
                        };

                    var stock_text = STOCK_LIST;

                    let result = stock_text.replace('value="'+res.data[i].stock_id_fk+'"', 'selected="selected" value="'+res.data[i].stock_id_fk+'"');

                    $tr+=`<tr class="clone_row">
                                <td>${l}</td>
                                <td>
                                    <select class="form-control" name="edit_product_id_fk[]" id="edit_product_id_fk[]" data-width="100%" data-live-search="true">
                                        <option value="${res.data[i].product_id_fk}">${res.data[i].product_name}</option>
                                    </select>

                                    <input type="hidden" id="edit_cost_price[]" name="edit_cost_price[]" value="${res.data[i].cost_price}" >
                                    <input type="hidden" id="edit_product_unit_id_fk[]" name="edit_product_unit_id_fk[]" value="${res.data[i].product_unit_id_fk}" >
                                    <input type="hidden" id="edit_unit_scale[]" name="edit_unit_scale[]" value="${res.data[i].unit_scale}" >
                                    <input type="hidden" id="edit_product_type_id_fk[]" name="edit_product_type_id_fk[]" value="${res.data[i].product_type_id_fk}" >
                                    <input type="hidden" id="edit_sell_detail_id[]" name="edit_sell_detail_id[]" value="${res.data[i].sell_detail_id}" >

                                </td>

                                <td>
                                    <input type="number" step="1" class="form-control" placeholder="Quantity" id="edit_sell_quantity[]" name="edit_sell_quantity[]" value="${res.data[i].sell_quantity}" required>
                                </td>

                                <td>
                                    <input type="number" step="1" class="form-control" placeholder="Unit Price" id="edit_sell_price[]" name="edit_sell_price[]" value="${res.data[i].sell_price}" required>
                                </td>

                                <td>
                                    <input type="number" step="1" class="form-control" placeholder="Discount" id="edit_discount[]" name="edit_discount[]" value="${res.data[i].discount}" >
                                </td>

                                <td>
                                    <input type="text" class="form-control" placeholder="Note" id="edit_sell_detail_note[]" name="edit_sell_detail_note[]" value="${res.data[i].sell_detail_note}" >
                                </td>

                                <td>
                                    <select class="form-control bootstrap-select" name="edit_stock_id_fk[]" id="edit_stock_id_fk[]" data-width="100%" data-live-search="true" required>
                                        ${result}
                                    </select>
                                </td>

                                <td>
                                    <input type="number" step="0.01" class="form-control" placeholder="Total" id="edit_total_row[]" name="edit_total_row[]" value="0" readonly>
                                </td>
                                
                                <td>
                                    <span class="btn btn-success btn-xs clone_btn">
                                        <i class="icon-add"></i>
                                    </span>
                                    <span class="btn btn-danger btn-xs remove_tr">
                                        <i class="icon-subtract"></i>
                                    </span>
                                </td>
                                                                
                                                                                            
                            </tr>`;
                }

            }

            if ($tr==``) {
                $tr=`<tr class="clone_row">
                                    <td>1</td>
                                    <td>
                                        <select class="form-control" name="edit_product_id_fk[]" id="edit_product_id_fk[]" data-width="100%" data-live-search="true">
                                        </select>

                                        <input type="hidden" id="edit_cost_price[]" name="edit_cost_price[]" value="0" >
                                        <input type="hidden" id="edit_product_unit_id_fk[]" name="edit_product_unit_id_fk[]" value="0" >
                                        <input type="hidden" id="edit_unit_scale[]" name="edit_unit_scale[]" value="0" >
                                        <input type="hidden" id="edit_product_type_id_fk[]" name="edit_product_type_id_fk[]" value="0" >
                                        <input type="hidden" id="edit_sell_detail_id[]" name="edit_sell_detail_id[]" value="0" >

                                    </td>

                                    <td>
                                        <input type="number" step="1" class="form-control" placeholder="Quantity" id="edit_sell_quantity[]" name="edit_sell_quantity[]"  required>
                                    </td>

                                    <td>
                                        <input type="number" step="1" class="form-control" placeholder="Unit Price" id="edit_sell_price[]" name="edit_sell_price[]"  required>
                                    </td>

                                    <td>
                                        <input type="number" step="1" class="form-control" placeholder="Discount" id="edit_discount[]" name="edit_discount[]"  >
                                    </td>

                                    <td>
                                        <input type="text" class="form-control" placeholder="Note" id="edit_sell_detail_note[]" name="edit_sell_detail_note[]"  >
                                    </td>

                                    <td>
                                        <select class="form-control bootstrap-select" name="edit_stock_id_fk[]" id="edit_stock_id_fk[]" data-width="100%" data-live-search="true" required>
                                            ${result}
                                        </select>
                                    </td>

                                    <td>
                                        <input type="number" step="0.01" class="form-control" placeholder="Total" id="edit_total_row[]" name="edit_total_row[]" value="0" readonly>
                                    </td>
                                    
                                    <td>
                                        <span class="btn btn-success btn-xs clone_btn">
                                            <i class="icon-add"></i>
                                        </span>
                                        <span class="btn btn-danger btn-xs remove_tr">
                                            <i class="icon-subtract"></i>
                                        </span>
                                    </td>
                                    
                                </tr>`;
            }

            
            $("#edit_sell").html($tr);
                     
            init_select2('edit_product_id_fk');
            $('.bootstrap-select').selectpicker('refresh')

            calc_totals('edit_');
            
            $('#edit_form_cont').modal('toggle');      

        }else{

          swal({
                  title: i18n.t("Error"),
                  text: i18n.t(res.data),
                  confirmButtonColor: "#2196F3",
                  type: "error"
              });

        }
        
      }
    });


}


function view(itemid){
  

    $("#edit_form")[0].reset();

    $("#edited_id").val(itemid);
 

    $.ajax({
      url: "models/crul_invoice.php",
      type:"POST",
      dataType : "JSON",
      data:{   "type":"get_edit",
                "edited_id":itemid,
                
            } ,
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {


        if(res.is_success == true){


            var $lab =``;
            var $rad =``;
            var $trt =``;
            var l=0;
            var r=0;
            var t=0;
            
            for (var i = 0; i < res.data.length; i++) {

                if (res.data[i].sell_id > 0) {
                    t++;

                    if (res.data[i].discount_type==1) {
                        var discount = res.data[i].discount /100;
                        var row         = (res.data[i].sell_quantity * res.data[i].sell_price) - ((res.data[i].sell_quantity * res.data[i].sell_price) * discount);
                    }else{
                        var row         = res.data[i].sell_quantity * res.data[i].sell_price - res.data[i].discount;
                    }

                    $trt+=`<tr class="clone_row">
                                    <td>${t}</td>
                                    <td>
                                        ${res.data[i].product_name}
                                    </td>
                                    <td>
                                        ${res.data[i].sell_quantity}
                                    </td>
                                    <td>
                                       ${res.data[i].sell_price}
                                    </td>
                                    <td>
                                        ${res.data[i].discount} ${res.data[i].discount_type==1?' % ' :''}
                                    </td>
                                    <td>
                                        ${res.data[i].sell_detail_note}
                                    </td>

                                    <td>
                                        ${res.data[i].created_at}
                                    </td>
                                    
                                    <td>
                                        ${currency(row)}
                                    </td>
                                    
                                </tr>`;
                
                }
            }


            var $tr = `<div class="table-responsive1">
                            <table id="header_table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    <tr >
                                        <td width=40%>
                                            <span style="font-size: 30px;">
                                                Invoice
                                            </span>
                                        </td>
                                        <td rowspan=2 width=20% style="text-align:end !important;"><img style="width:100px;" src="${COMPANY_LOGO}"></td>
                                    </tr>
                                    <tr >
                                        <td colspan=2>${COMPANY_NAME}</td>
                                    </tr>

                                    <tr >
                                        <td colspan=2>${COMPANY_ADDRESS}</td>
                                    </tr>
                                    
                                </tbody>
                            </table>
                            <br>
                            <table id="patient_table_id" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; text-align:left;" >
                                <tbody>

                                    <tr >
                                        <td colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Patient Name: </span>
                                        
                                            ${res.data[0].patient_full_name}                                            
                                        </td>

                                        <td colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Invoice Number: </span>
                                        
                                            ${res.data[0].invoice_number}                                            
                                        </td>
                                    </tr>

                                    <tr >
                                        <td colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Patient Address: </span>
                                        
                                            ${res.data[0].patient_address}
                                        </td>

                                        <td colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Invoice Date: </span>
                                        
                                            ${res.data[0].invoice_date}
                                        </td>


                                    </tr>

                                    <tr class="border">
                                        <td  colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Patient Phone: </span>
                                        
                                            ${res.data[0].patient_phone}
                                        </td>

                                        <td >
                                           <span style="font-size: 14px;font-weight: bolder;"> Company: </span>
                                        
                                            ${res.data[0].company_name}
                                        </td>

                                        <td >
                                            Patient ID
                                        </td>
                                        <td >
                                            ${res.data[0].patient_id_fk}
                                        </td>

                                    

                                    </tr>

                                </tbody>
                            </table>
                            <br>
                            
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    
                                    <tr class="border bg-primary">
                                        <td>#</td>
                                        <td style="font-size: 14px;font-weight: bolder;" width="25%">Product/Service</td>
                                        <td style="font-size: 14px;font-weight: bolder;">Quantity</td>
                                        <td style="font-size: 14px;font-weight: bolder;">Unit Price</td>
                                        <td style="font-size: 14px;font-weight: bolder;">Discount</td>
                                        <td style="font-size: 14px;font-weight: bolder;">Note</td>
                                        <td style="font-size: 14px;font-weight: bolder;">DateTime</td>
                                        <td style="font-size: 14px;font-weight: bolder;">Total</td>
                                    </tr>
                                    
                                    ${$trt}
                                    <tr >
                                        <td>Notes</td>
                                        <td colspan=7>${res.data[0].sell_note}</td>
                                    </tr> 
                                    </tbody>
                            </table>
                            <br>
                            
                            <table id="footer_table"  border=0 cellpadding=0 cellspacing=0 style="width:100%; font-size:16px;">
                                <tbody>
                                    <tr >
                                        <td colspan=6 ><span style="float:right">Total Discount</span></td>
                                        <td span style="text-align:center;">${currency(res.data[0].invoice_total_discount)}</td>
                                    </tr>

                                    <tr >
                                        <td colspan=6 ><span style="float:right">Total Paid</span></td>
                                        <td span style="text-align:center;">${currency(res.data[0].total_paid)}</td>
                                    </tr>

                                    <tr >
                                        <td colspan=6 ><span style="float:right">Grand Total Invoice</span></td>
                                        <td span style="text-align:center;">${currency(res.data[0].invoice_total_price)}</td>
                                    </tr>

                                    <tr >
                                        <td colspan=5 ><span style="float:right"></span></td>
                                        <td span style="text-align:center; border-bottom:1px solid black;"></td>
                                        <td span style="text-align:center; border-bottom:1px solid black;"></td>
                                        
                                    </tr>

                                    <tr >
                                        <td colspan=6 ><span style="float:right">Total Remained</span></td>
                                        <td span style="text-align:center;">${currency(res.data[0].invoice_total_price - res.data[0].total_paid)} 
                                        <br>
                                        (${DEFAULT_CURRENCY=='ar_IQ'?tafqeet((res.data[0].invoice_total_price - res.data[0].total_paid)) +" دينار عراقي":toWords(`${parseInt((res.data[0].invoice_total_price - res.data[0].total_paid))}`) +" USD Dollar"} )
                                        </td>
                                    </tr>

                                    
                                             
                                </tbody>
                            </table>

                            <br>    
                            <table id="footer_first" cellpadding=0 cellspacing=0 style="width:99%; ">
                                <tbody>
                                    

                                    <tr >
                                        <td width=20% style="border:0px;">Accountant:</td>
                                        <td style="text-align:left; border:0px;">${res.data[0].created_by}</td>

                                    </tr>
                                    <tr >
                                        <td width=25% style=" border:0px;">Signature and Stamp:</td>
                                        <td style="text-align:end; border:0px;">Page 1 of 1</td>

                                    </tr>
                                </tbody>
                            </table> 
                        </div>

                         `;

            


            
            $("#view-title").html("Patient Invoice");
            $("#view_table").html($tr);
            
            $('#view-modal').modal('toggle');      

        }else{

          swal({
                  title: i18n.t("Error"),
                  text: i18n.t(res.data),
                  confirmButtonColor: "#2196F3",
                  type: "error"
              });

        }
        
      }
    });


}

function view_no_price(itemid){
  

    $("#edit_form")[0].reset();

    $("#edited_id").val(itemid);
 

    $.ajax({
      url: "models/crul_invoice.php",
      type:"POST",
      dataType : "JSON",
      data:{   "type":"get_edit",
                "edited_id":itemid,
                
            } ,
      complete:function(){
        
      },
      beforeSend:function(){
        
      },
      success: function(res) {


        if(res.is_success == true){


            var $lab =``;
            var $rad =``;
            var $trt =``;
            var l=0;
            var r=0;
            var t=0;
            
            for (var i = 0; i < res.data.length; i++) {

                if (res.data[i].sell_id > 0) {
                    t++;


                    $trt+=`<tr class="clone_row">
                                    <td>${t}</td>
                                    <td>
                                        ${res.data[i].product_name}
                                    </td>
                                    
                                    <td>
                                        ${res.data[i].sell_detail_note}
                                    </td>

                                    <td>
                                        ${res.data[i].created_at}
                                    </td>
                                    
                                    
                                </tr>`;
                
                }
            }


            var $tr = `<div class="table-responsive1">
                            <table id="header_table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    <tr >
                                        <td width=40%>
                                            <span style="font-size: 30px;">
                                                Invoice
                                            </span>
                                        </td>
                                        <td rowspan=2 width=20% style="text-align:end !important;"><img style="width:100px;" src="${COMPANY_LOGO}"></td>
                                    </tr>
                                    <tr >
                                        <td colspan=2>${COMPANY_NAME}</td>
                                    </tr>

                                    <tr >
                                        <td colspan=2>${COMPANY_ADDRESS}</td>
                                    </tr>
                                    
                                </tbody>
                            </table>
                            <br>
                            <table id="patient_table_id" class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; text-align:left;" >
                                <tbody>

                                    <tr >
                                        <td colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Patient Name: </span>
                                        
                                            ${res.data[0].patient_full_name}                                            
                                        </td>

                                        <td colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Invoice Number: </span>
                                        
                                            ${res.data[0].invoice_number}                                            
                                        </td>
                                    </tr>

                                    <tr >
                                        <td colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Patient Address: </span>
                                        
                                            ${res.data[0].patient_address}
                                        </td>

                                        <td colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Invoice Date: </span>
                                        
                                            ${res.data[0].invoice_date}
                                        </td>


                                    </tr>

                                    <tr class="border">
                                        <td  colspan="3">
                                            <span style="font-size: 14px;font-weight: bolder;">Patient Phone: </span>
                                        
                                            ${res.data[0].patient_phone}
                                        </td>

                                        <td >
                                           <span style="font-size: 14px;font-weight: bolder;"> Company: </span>
                                        
                                            ${res.data[0].company_name}
                                        </td>

                                        <td >
                                            Patient ID
                                        </td>
                                        <td >
                                            ${res.data[0].patient_id_fk}
                                        </td>

                                    

                                    </tr>

                                </tbody>
                            </table>
                            <br>
                            
                            <table class="table table-bordered table-lg report-table" border=0 cellpadding=0 cellspacing=0 style="width:100%; ">
                                <tbody>
                                    
                                    <tr class="border bg-primary">
                                        <td width="10%">#</td>
                                        <td style="font-size: 14px;font-weight: bolder;" width="25%">Product/Service</td>
                                        <td  style="font-size: 14px;font-weight: bolder;">Note</td>
                                        <td width="25%" style="font-size: 14px;font-weight: bolder;">DateTime</td>
                                    </tr>
                                    
                                    ${$trt}
                                    <tr >
                                        <td>Notes</td>
                                        <td colspan=4>${res.data[0].sell_note}</td>
                                    </tr> 
                                    </tbody>
                            </table>
                            <br>
                            
                            <table id="footer_table"  border=0 cellpadding=0 cellspacing=0 style="width:100%; font-size:16px;">
                                <tbody>
                                    <tr >
                                        <td colspan=6 ><span style="float:right">Total Discount</span></td>
                                        <td span style="text-align:center;">${currency(res.data[0].invoice_total_discount)}</td>
                                    </tr>
                                    <tr >
                                        <td colspan=6 ><span style="float:right">Total Paid</span></td>
                                        <td span style="text-align:center;">${currency(res.data[0].total_paid)}</td>
                                    </tr>
                                    <tr >
                                        <td colspan=6 ><span style="float:right">Grand Total Invoice</span></td>
                                        <td span style="text-align:center;">${currency(res.data[0].invoice_total_price)}</td>
                                    </tr>
                                    
                                    <tr >
                                        <td colspan=5 ><span style="float:right"></span></td>
                                        <td span style="text-align:center; border-bottom:1px solid black;"></td>
                                        <td span style="text-align:center; border-bottom:1px solid black;"></td>
                                        
                                    </tr>

                                    <tr >
                                        <td colspan=6 ><span style="float:right">Total Remained</span></td>
                                        <td span style="text-align:center;">${currency(res.data[0].invoice_total_price - res.data[0].total_paid)} 
                                        <br>(${DEFAULT_CURRENCY=='ar_IQ'?tafqeet((res.data[0].invoice_total_price - res.data[0].total_paid)) +" دينار عراقي":toWords(`${parseInt((res.data[0].invoice_total_price - res.data[0].total_paid))}`) +" USD Dollar"} )
                                        </td>
                                    </tr>

                                             
                                </tbody>
                            </table>

                            <br>    
                            <table id="footer_first" cellpadding=0 cellspacing=0 style="width:99%; ">
                                <tbody>
                                    

                                    <tr >
                                        <td width=20% style="border:0px;">Accountant:</td>
                                        <td style="text-align:left; border:0px;"></td>

                                    </tr>
                                    <tr >
                                        <td width=25% style=" border:0px;">Signature and Stamp:</td>
                                        <td style="text-align:end; border:0px;">Page 1 of 1</td>

                                    </tr>
                                </tbody>
                            </table> 
                        </div>

                         `;

            


            
            $("#view-title").html("Patient Invoice");
            $("#view_table").html($tr);
            
            $('#view-modal').modal('toggle');      

        }else{

          swal({
                  title: i18n.t("Error"),
                  text: i18n.t(res.data),
                  confirmButtonColor: "#2196F3",
                  type: "error"
              });

        }
        
      }
    });


}



function delete_items(itemid) {
    // bootstrap modal confirmation box
    swal({
        title: i18n.t("Are you Sure!"),
        text: i18n.t("Record Will be Deleted Permenantly!, You Can't Restore it again."),
        type: "warning",
        showCancelButton: true,
        confirmButtonColor: "#EF5350",
        cancelButtonColor: "#EF5350",
        confirmButtonText: i18n.t("Yes delete it"),
        cancelButtonText: i18n.t("Cancel"),
        closeOnConfirm: false,
        closeOnCancel: true
    },
    function(isConfirm){
        if (isConfirm) {
          $.ajax({
            url: "models/crul_invoice.php",
            type:"POST",
            dataType : "JSON",
            data: {"type":"delete","obj_id":itemid} ,
            complete:function(){
             
            },
            beforeSend:function(){
             
            },
            success: function(res) {

              if(res.is_success == true){
                swal({
                        title: i18n.t("Deleted!"),
                        text: i18n.t(res.data),
                        confirmButtonColor: "#66BB6A",
                        type: "success"
                    });
                $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);
              }else{
                swal({
                        title: "Cancelled",
                        text: i18n.t(res.data),
                        confirmButtonColor: "#2196F3",
                        type: "error"
                    });
              }
            }
        });
        }
    }); // /confirm
}


function set_status(itemid,val){
    $("#status_form")[0].reset();
    $("#status_id").val(itemid);
    $("#is_closed").val(val);
    $('#status_form_cont').modal('toggle');
}

function pay_status(itemid,val){
    $("#pay_status_form")[0].reset();
    $("#pay_status_id").val(itemid);
    $("#pay_status").val(val);
    $('#pay_status_form_cont').modal('toggle');
}

function add_payment(itemid,val,inv,pay){
    $("#pay_form")[0].reset();
    $("#sell_id_fk").val(itemid);
    $("#patient_id").val(val);
    var remain = inv - pay;
    remain = remain.toFixed(2)
    $("#invoice_amount").val(remain);
    $("#paid_amount1").attr('max',inv);

    get_patient_account(val)
    $('#pay_form_cont').modal('toggle');
    $('.daterange-single').daterangepicker({ 
        showDropdowns: true,
        timePicker: true,
        singleDatePicker: true,
        startDate: moment(),
        applyClass: 'bg-slate-600',
        locale: {
            format: 'YYYY-MM-DD H:mm'
        }
    });
}



function get_Doctors(){

        $.ajax({
                    url : 'models/crul_user.php',
                    type : 'POST',
                    data : {type:'get'},
                    dataType : 'json',
                    success : function(res) {
                            var attach =`<option value="0">${i18n.t('Select Doctor')}</option>`;
                          
                            for(var i=0 ; i < res.data.length ;i++){
                              
                              attach+=`<option value="${res.data[i].staff_id}">${res.data[i].full_name}</option>`;
                             
                            }


                            $("#staff_id_fk").html(attach);
                            $('#staff_id_fk').selectpicker('refresh');

                            $("#edit_staff_id_fk").html(attach);
                            $('#edit_staff_id_fk').selectpicker('refresh');

                    },
                    complete: function() {
                             //  me.data('requestRunning', false);
                    }

        }); // submit ajax

}

function get_Treat_Form(){

        $.ajax({
                    url : 'models/crul_form.php',
                    type : 'POST',
                    data : {type:'get'},
                    dataType : 'json',
                    success : function(res) {
                            var attach =`<option value="0">${i18n.t('Select Form')}</option>`;
                          
                            for(var i=0 ; i < res.data.length ;i++){
                              
                              attach+=`<option value="${res.data[i].treat_form_id}">${res.data[i].form_name}</option>`;
                             
                            }

                            FORM_LIST = attach;
                            $("#treat_form_id_fk\\[\\]").html(attach);
                            $("#edit_treat_form_id_fk\\[\\]").html(attach);
                            $('#treat_form_id_fk\\[\\]').selectpicker('refresh');
                            $("#edit_treat_form_id_fk\\[\\]").selectpicker('refresh');

                    },
                    complete: function() {
                             //  me.data('requestRunning', false);
                    }

        }); // submit ajax

}

function get_Treat_Route(){

        $.ajax({
                    url : 'models/crul_route.php',
                    type : 'POST',
                    data : {type:'get'},
                    dataType : 'json',
                    success : function(res) {
                            var attach =`<option value="0">${i18n.t('Select Route')}</option>`;
                          
                            for(var i=0 ; i < res.data.length ;i++){
                              
                              attach+=`<option value="${res.data[i].treat_route_id}">${res.data[i].route_name}</option>`;
                             
                            }

                            ROUTE_LIST = attach;

                            $("#treat_route_id_fk\\[\\]").html(attach);
                            $("#edit_treat_route_id_fk\\[\\]").html(attach);
                            $('#treat_route_id_fk\\[\\]').selectpicker('refresh');
                            $("#edit_treat_route_id_fk\\[\\]").selectpicker('refresh');

                    },
                    complete: function() {
                             //  me.data('requestRunning', false);
                    }

        }); // submit ajax

}

function get_Treat_Frequency(){

        $.ajax({
                    url : 'models/crul_frequency.php',
                    type : 'POST',
                    data : {type:'get'},
                    dataType : 'json',
                    success : function(res) {
                            var attach =`<option value="0">${i18n.t('Select Frequency')}</option>`;
                          
                            for(var i=0 ; i < res.data.length ;i++){
                              
                              attach+=`<option value="${res.data[i].treat_frequency_id}">${res.data[i].frequency_name}</option>`;
                             
                            }

                            FREQUENCY_LIST = attach;

                            $("#treat_frequency_id_fk\\[\\]").html(attach);
                            $("#edit_treat_frequency_id_fk\\[\\]").html(attach);
                            $('#treat_frequency_id_fk\\[\\]').selectpicker('refresh');
                            $("#edit_treat_frequency_id_fk\\[\\]").selectpicker('refresh');

                    },
                    complete: function() {
                             //  me.data('requestRunning', false);
                    }

        }); // submit ajax

}

function get_patient_report(id){

        $.ajax({
                    url : 'models/crul_invoice.php',
                    type : 'POST',
                    data : {type:'get',id:id},
                    dataType : 'json',
                    success : function(res) {
                            var attach =``;
                          
                            for(var i=0 ; i < res.data.length ;i++){
                              if (res.data[i].patient_report_id > 0) {
                                attach+=`<a onclick="view_report(${res.data[i].patient_report_id})">${res.data[i].report_reference_number}</a>`;
                              }
                             
                            }


                            $("#past_medical_history").html(attach);
                            $("#gender").val(res.data[0].gender);
                            $("#dob").val(res.data[0].patient_date_of_birth);
                            $("#blood_group").val(res.data[0].blood_group);
                            $("#allergies").val(res.data[0].allergies);
                            $("#company_name").val(res.data[0].company_name);
                            $("#occupation").val(res.data[0].occupation);
                            

                    },
                    complete: function() {
                             //  me.data('requestRunning', false);
                    }

        }); // submit ajax

}

function setText_arr(element,prefix,$tr){
        console.log(prefix)
        var value = $(element).text();
        $tr.find(`#${prefix}\\[\\]`).val(value);
        $tr.find(`#${prefix}\\[\\]`).trigger('change');
        $tr.find(`#searchResult\\[\\]`).empty();

}

function print(id) {

    attach = $(`#${id}`).html();
    var style = `<style>
                    

                    td {
                        text-align:center;
                        border-bottom: 0.5px solid #9d9b9b;
                        height:30px;
                    }

                    #patient_table_id td {
                        text-align:left !important;
                    }

                    #header_table td {
                        border: 0px solid #9d9b9b;
                        text-align:left !important;

                    }

                    #footer_table td {
                        border: 0px solid #9d9b9b;

                    }
                    
                    .bg-primary{
                        background-color:grey;
                    }
                    #footer_first1{
                                                
                                        position:absolute;
                                        top:25.7cm;
                                        width: -webkit-fill-available;

                                  }
                </style>
                <script>

                  setTimeout(function() {
                    window.print()
                  }, 2000)
                  
                </script>`;       
    window.open().document.write(style+attach);
    
    
}

function get_Stock(){

        $.ajax({
                    url : 'models/crul_stock.php',
                    type : 'POST',
                    data : {type:'get'},
                    dataType : 'json',
                    success : function(res) {
                            var attach = `<option value="0">${i18n.t('Select Stock')}</option>`;
                          
                            for(var i=0 ; i < res.data.length ;i++){
                              
                              attach+=`<option value="${res.data[i].stock_id}">${res.data[i].stock_name}</option>`;
                             
                            }

                            STOCK_LIST = attach;
                            $("#stock_id_fk").html(attach);
                            $("#stock_id_fk\\[\\]").html(attach);
                            $("#edit_stock_id_fk").html(attach);
                            $('#stock_id_fk').selectpicker('refresh');
                            $('#stock_id_fk\\[\\]').selectpicker('refresh');
                            $("#edit_stock_id_fk").selectpicker('refresh');
                            $('#stock_id_fk\\[\\]').val(DEFAULT_STOCK_ID).selectpicker('refresh');


                    },
                    complete: function() {
                             //  me.data('requestRunning', false);
                    }

        }); // submit ajax

}

function calc_totals(prefix=''){
    
    var tot_qty     = 0;
    var tot_disc    = 0;
    var tot_sell    = 0;
    var tot_profit  = 0;
    var tot_row     = 0;
    var cnt         = 0;

    var perc =  $("#"+prefix+"discount_type").val();
    var divider = 1;

    perc==1?divider =100:divider=1;
    
    $('#'+prefix+'sell_quantity\\[\\]').each(function(index,data) {
    
        var quantity    = $(this).val();
        var sell_price  = $('#'+prefix+'sell_price\\[\\]').eq(index).val();
        var discount    = $('#'+prefix+'discount\\[\\]').eq(index).val();
        discount        = discount / divider;

        if (perc==1) {
            var row         = (quantity * sell_price) - ((quantity * sell_price) * discount);
            discount        = ((quantity * sell_price) * discount);
        }else{
            var row         = quantity * sell_price - discount;
        }
        
        row         = parseFloat(row).toFixed(2);

        tot_qty     =+tot_qty + +quantity;
        tot_sell    =+tot_sell + +sell_price;
        tot_row     =+tot_row + +row;
        tot_disc    =+tot_disc + +discount;

        $("#"+prefix+"total_row\\[\\]").eq(index).val(row);
    });

    var gen_discount    =  $("#"+prefix+"general_discount").val();
    gen_discount        = gen_discount / divider;

    if (perc==1) {
        gen_discount   = (tot_row * gen_discount);
        tot_row         = tot_row - gen_discount;
    }else{
        tot_row         = tot_row - gen_discount;
    }

    tot_disc    =+tot_disc + +gen_discount;

    var percentage_discount = tot_disc / (+tot_disc + +tot_row) * 100;


    tot_qty     = parseFloat(tot_qty).toFixed(2)
    tot_sell    = parseFloat(tot_sell).toFixed(2)
    tot_row     = parseFloat(tot_row).toFixed(2)
    tot_disc    = parseFloat(tot_disc).toFixed(2)
    percentage_discount    = parseFloat(percentage_discount).toFixed(2)
    $("#"+prefix+"invoice_total_price").val(tot_row);
    $("#"+prefix+"invoice_total_discount").val(tot_disc);
    $("#"+prefix+"percentage_discount").val(percentage_discount);


  

}

function get_Box(){

        $.ajax({
                    url : 'models/crul_box.php',
                    type : 'POST',
                    data : {type:'get'},
                    dataType : 'json',
                    success : function(res) {
                            var attach = ``;
                          
                            for(var i=0 ; i < res.data.length ;i++){
                              
                              attach+=`<option value="${res.data[i].box_id}">${res.data[i].box_name}</option>`;
                             
                            }


                            $("#box_id_fk").html(attach);
                            $("#box_id_fk").val(DEFAULT_BOX_ID).selectpicker('refresh');
                            $("#edit_box_id_fk").html(attach);
                            $("#edit_box_id_fk").selectpicker('refresh');
                           

                    },
                    complete: function() {
                             //  me.data('requestRunning', false);
                    }

        }); // submit ajax

}

$(document).ready(function() {

   
    get_Stock();
    
    get_Box();
    get_Country('cp_')
    get_Company('cp_')
    get_Patient_Group('cp_');

    init_select2('product_id_fk');

    $("#print_btn").on('click', function(e){
        e.preventDefault();
        print('view_table');
    });

    $('body').on('select2:select','#product_id_fk\\[\\]', function (e) {
        var data = e.params.data.data;
        var cost = e.params.data.data.product_cost;
        var sell = e.params.data.data.sell_price;
        var unit = e.params.data.data.product_unit_id_fk;
        var pt = e.params.data.data.product_type_id_fk;
        var us = e.params.data.data.unit_scale;
        var $tr  = $(this).closest('.clone_row');
        
        $tr.find('#sell_price\\[\\]').val(sell)
        $tr.find('#cost_price\\[\\]').val(cost)
        $tr.find('#product_unit_id_fk\\[\\]').val(unit)
        $tr.find('#unit_scale\\[\\]').val(us)
        $tr.find('#product_type_id_fk\\[\\]').val(pt)
        calc_totals();

        console.log(data);
    });

    $('body').on('select2:select','#edit_product_id_fk\\[\\]', function (e) {
        var data = e.params.data.data;
        var cost = e.params.data.data.product_cost;
        var sell = e.params.data.data.sell_price;
        var unit = e.params.data.data.product_unit_id_fk;
        var pt = e.params.data.data.product_type_id_fk;
        var us = e.params.data.data.unit_scale;
        var $tr  = $(this).closest('.clone_row');
        
        $tr.find('#edit_sell_price\\[\\]').val(sell)
        $tr.find('#edit_cost_price\\[\\]').val(cost)
        $tr.find('#edit_product_unit_id_fk\\[\\]').val(unit)
        $tr.find('#edit_unit_scale\\[\\]').val(us)
        $tr.find('#edit_product_type_id_fk\\[\\]').val(pt)
        calc_totals('edit_');
        
        console.log(data);
    });

    

    $("#add_table_lab").on('click','.clone_btn', function(e){
        e.preventDefault()
        var $tr     = $(this).closest('.clone_row');
        var id      = $tr.find('#stock_id_fk\\[\\]').val()
        var nmb      = $tr.find('#nmb\\[\\]').text()
        nmb++;
        var $clone  = $tr.clone();
        $clone.find(':text').val('');
        $clone.find(':input').val('');
        $clone.find("span.select2").remove();
        $clone.find('.bootstrap-select').replaceWith(function() { return $('select', this); });
        $clone.find('#stock_id_fk\\[\\]').val(id);
        $clone.find('#nmb\\[\\]').html(nmb);

        
        $tr.after($clone);
        init_select2('product_id_fk');

    });

    $("#edit_table_lab").on('click','.clone_btn', function(e){
        e.preventDefault()
        var $tr     = $(this).closest('.clone_row');
        var id      = $tr.find('#edit_stock_id_fk\\[\\]').val()

        var $clone  = $tr.clone();
        $clone.find(':text').val('');
        $clone.find(':input').val('');
        $clone.find("span.select2").remove();
        $clone.find('.bootstrap-select').replaceWith(function() { return $('select', this); });
        $clone.find('#stock_id_fk\\[\\]').val(id);
        
        $tr.after($clone);
        init_select2('edit_product_id_fk');

    });

    $("#add_table_lab").on('click','.remove_tr', function(e){
        e.preventDefault()
        $(this).closest('tr').remove();
    });

    $("#edit_table_lab").on('click','.remove_tr', function(e){
        e.preventDefault()
        $(this).closest('tr').remove();
    });

    $("#add_form").on('change',':input', function(e){
        e.preventDefault()
        calc_totals();

    });

    $("#edit_form").on('change',':input', function(e){
        e.preventDefault()
        calc_totals('edit_');

    });

    $("body").on('change','#view_cond', function(e){
        e.preventDefault();
        $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);
        
    })

    $("#patient_id_fk").on('change', function(e){
        e.preventDefault();
        var id = $(this).val();
        get_patient_report(id)        
    })

    $("#submit_add_btn").on('click', function(e){
        e.preventDefault();

        // $(".li-tabs").removeClass('active');
        $("#active-tab").addClass('active');
        $("#bordered-justified-tab1").addClass('active');
        $('#submit_add_btn_triger').trigger('click');

    });

    $("#submit_edit_btn").on('click', function(e){
        e.preventDefault();
        // $(".edit-li-tabs").removeClass('active');
        $("#edit_active-tab").addClass('active');
        $("#edit-bordered-justified-tab1").addClass('active');
        $('#submit_edit_btn_triger').trigger('click');
    });

    $("#submit_status_btn").on('click', function(e){
        e.preventDefault();

        // $(".pass-li-tabs").removeClass('active');
        $("#status_active-tab").addClass('active');
        $("#status-bordered-justified-tab1").addClass('active');
        $('#submit_status_btn_triger').trigger('click');
    });

    $("#submit_pay_status_btn").on('click', function(e){
        e.preventDefault();

        // $(".pass-li-tabs").removeClass('active');
        $("#pay_status_active-tab").addClass('active');
        $("#pay_status-bordered-justified-tab1").addClass('active');
        $('#submit_pay_status_btn_triger').trigger('click');
    });

    $("#submit_pay_btn").on('click', function(e){
        e.preventDefault();

        var pa = $("#paid_amount1").val();
        var ia = $("#invoice_amount").val();
        pa = parseFloat(pa)
        ia = parseFloat(ia)
        if (pa > ia) {
            
            noty({
                    width: 200,
                    text: i18n.t("Paid Amount Greator than Invoice Amount!"),
                    type: 'error',
                    dismissQueue: true,
                    timeout: 2000,
                    layout: 'center',  
                    });
            return null;

        }
        $("#pay_active-tab").addClass('active');
        $("#pay-bordered-justified-tab1").addClass('active');
        // $('#submit_pay_btn_triger').trigger('click');
        $('#pay_form').submit();
    });

    

    $('#add_form').submit(function(event) {
      event.preventDefault();

      

      var fd=new FormData(this);
      
      fd.append("type",'create');

      $("#submit_add_btn").attr('disabled',true);
      $.ajax({
          url: "models/crul_invoice.php",
          type:"POST",
          dataType: "JSON",
          data: fd,
          processData: false,
          contentType: false
      
      })
      .done(function(res) {
         
          if(res.is_success == true){

            $("#add_form")[0].reset();
            $('#tree-container').html('');

            noty({
                  width: 200,
                  text: i18n.t(res.data),
                  type: 'success',
                  dismissQueue: true,
                  timeout: 2000,
                  layout: 'topRight',
                  callback: {
                              onShow: function() {
                                $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);

                              },
                              afterShow: function() {
                               // show_report(res.id,'Print');
                              },
                              onClose: function() {

                                location.reload();
                              },
                              afterClose: function() {},
                              onCloseClick: function() {},
                            },
            });

         
          }else{
              swal({
                  title: i18n.t("Error"),
                  text: i18n.t(res.data),
                  confirmButtonColor: "#66BB6A",
                  type: "warning"
              });
          }

          $("#submit_add_btn").attr('disabled',false);
      })
      .fail(function(err) {
          $("#submit_add_btn").attr('disabled',false);

           swal({
              title: i18n.t("Error"),
              text: (err),
              confirmButtonColor: "#66BB6A",
              type: "error"
          });
          $("#submit_add_btn").attr('disabled',false);
      })
      .always(function() {
          console.log("complete");
          $("#submit_add_btn").attr('disabled',false);

      });
      

    });


    $('#edit_form').submit(function(event) {
          event.preventDefault();
          
          $("#submit_edit_btn").attr('disabled',true);

          var formData = new FormData(this);

          formData.append("type", 'update');     

          $.ajax({
                  url: "models/crul_invoice.php",
                  type:"POST",
                  dataType : "JSON",
                  data: formData,
                  processData: false,
                  contentType: false
                })
                .done(function(res) {

                    $("#submit_edit_btn").attr('disabled',false);

             
                    if(res.is_success == true){

                      $('#edit_form_cont').modal('toggle');
                      $("#edit_form")[0].reset();

                      noty({
                            width: 200,
                            text: i18n.t(res.data),
                            type: 'success',
                            dismissQueue: true,
                            timeout: 2000,
                            layout: 'topRight',
                            callback: {
                                        onShow: function() {

                                        },
                                        afterShow: function() {
                                         // show_report(res.id,'Print');
                                          $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);

                                        },
                                        onClose: function() {

                                          // location.reload();
                                        },
                                        afterClose: function() {},
                                        onCloseClick: function() {},
                                      },
                      });

                   
                    }else{
                        swal({
                            title: i18n.t("Error"),
                            text: i18n.t(res.data),
                            confirmButtonColor: "#66BB6A",
                            type: "warning"
                        });
                    }

                })
                .fail(function(err) {
                    $("#submit_edit_btn").attr('disabled',false);

                    swal({
                        title: i18n.t("Error"),
                        text: (err),
                        confirmButtonColor: "#66BB6A",
                        type: "error"
                    });
                })
                .always(function() {
                    console.log("complete");
                    $("#submit_edit_btn").attr('disabled',false);

                });

                 
        

    });

    $('#status_form').submit(function(event) {
          event.preventDefault();
          
          $("#submit_status_btn").attr('disabled',true);

          var formData = new FormData(this);

          formData.append("type", 'set_status');     

          $.ajax({
                  url: "models/crul_invoice.php",
                  type:"POST",
                  dataType : "JSON",
                  data: formData,
                  processData: false,
                  contentType: false
                })
                .done(function(res) {

                    $("#submit_status_btn").attr('disabled',false);

             
                    if(res.is_success == true){

                      $('#status_form_cont').modal('toggle');
                      $("#status_form")[0].reset();

                      noty({
                            width: 200,
                            text: i18n.t(res.data),
                            type: 'success',
                            dismissQueue: true,
                            timeout: 2000,
                            layout: 'topRight',
                            callback: {
                                        onShow: function() {

                                        },
                                        afterShow: function() {
                                         // show_report(res.id,'Print');
                                          $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);

                                        },
                                        onClose: function() {

                                          // location.reload();
                                        },
                                        afterClose: function() {},
                                        onCloseClick: function() {},
                                      },
                      });

                   
                    }else{
                        swal({
                            title: i18n.t("Error"),
                            text: i18n.t(res.data),
                            confirmButtonColor: "#66BB6A",
                            type: "warning"
                        });
                    }

                })
                .fail(function(err) {
                    $("#submit_status_btn").attr('disabled',false);

                    swal({
                        title: i18n.t("Error"),
                        text: (err),
                        confirmButtonColor: "#66BB6A",
                        type: "error"
                    });
                })
                .always(function() {
                    console.log("complete");
                    $("#submit_status_btn").attr('disabled',false);

                });

                 
        

    });
    
    $('#pay_status_form').submit(function(event) {
          event.preventDefault();
          
          $("#submit_pay_status_btn").attr('disabled',true);

          var formData = new FormData(this);

          formData.append("type", 'set_pay_status');     

          $.ajax({
                  url: "models/crul_invoice.php",
                  type:"POST",
                  dataType : "JSON",
                  data: formData,
                  processData: false,
                  contentType: false
                })
                .done(function(res) {

                    $("#submit_pay_status_btn").attr('disabled',false);

             
                    if(res.is_success == true){

                      $('#pay_status_form_cont').modal('toggle');
                      $("#pay_status_form")[0].reset();

                      noty({
                            width: 200,
                            text: i18n.t(res.data),
                            type: 'success',
                            dismissQueue: true,
                            timeout: 2000,
                            layout: 'topRight',
                            callback: {
                                        onShow: function() {

                                        },
                                        afterShow: function() {
                                         // show_report(res.id,'Print');
                                          $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);

                                        },
                                        onClose: function() {

                                          // location.reload();
                                        },
                                        afterClose: function() {},
                                        onCloseClick: function() {},
                                      },
                      });

                   
                    }else{
                        swal({
                            title: i18n.t("Error"),
                            text: i18n.t(res.data),
                            confirmButtonColor: "#66BB6A",
                            type: "warning"
                        });
                    }

                })
                .fail(function(err) {
                    $("#submit_pay_status_btn").attr('disabled',false);

                    swal({
                        title: i18n.t("Error"),
                        text: (err),
                        confirmButtonColor: "#66BB6A",
                        type: "error"
                    });
                })
                .always(function() {
                    console.log("complete");
                    $("#submit_pay_status_btn").attr('disabled',false);

                });

                 
        

    });
    
    $('#pay_form').submit(function(event) {
          event.preventDefault();
          
          $("#submit_pay_btn").attr('disabled',true);

          var formData  = new FormData(this);
          var id        = $("#patient_id").val();
          var pa        = $("#paid_amount1").val();
          formData.append("patient_id_fk", id);     
          formData.append("paid_amount", pa);     
          formData.append("type", 'create');     

          $.ajax({
                  url: "models/crul_payment.php",
                  type:"POST",
                  dataType : "JSON",
                  data: formData,
                  processData: false,
                  contentType: false
                })
                .done(function(res) {

                    $("#submit_pay_btn").attr('disabled',false);

             
                    if(res.is_success == true){

                      $('#pay_form_cont').modal('toggle');
                      $("#pay_form")[0].reset();

                      noty({
                            width: 200,
                            text: i18n.t(res.data),
                            type: 'success',
                            dismissQueue: true,
                            timeout: 2000,
                            layout: 'topRight',
                            callback: {
                                        onShow: function() {

                                        },
                                        afterShow: function() {
                                         // show_report(res.id,'Print');
                                          $(".datatable-column-search-inputs").DataTable().ajax.reload(null, false);

                                        },
                                        onClose: function() {

                                          // location.reload();
                                        },
                                        afterClose: function() {},
                                        onCloseClick: function() {},
                                      },
                      });

                   
                    }else{
                        swal({
                            title: i18n.t("Error"),
                            text: i18n.t(res.data),
                            confirmButtonColor: "#66BB6A",
                            type: "warning"
                        });
                    }

                })
                .fail(function(err) {
                    $("#submit_pay_btn").attr('disabled',false);

                    swal({
                        title: i18n.t("Error"),
                        text: (err),
                        confirmButtonColor: "#66BB6A",
                        type: "error"
                    });
                })
                .always(function() {
                    console.log("complete");
                    $("#submit_pay_btn").attr('disabled',false);

                });

                 
        

    });
   


});



$(function() {

    $('[name="phone_number"]').formatter({
        pattern: '+{{999}} {{999}} {{999}} {{9999}}'
    });

    $('select[name$="patient_id_fk"]').select2({
        minimumResultsForSearch: -1,
        ajax: {
            url: "models/crul_patient.php",
            dataType: 'json',
            type: 'POST',
            quietMillis: 100,
            data: function (data, page) {
                return {
                    type: 'search',
                    dataType:'',
                    condition: '',
                    q:data.term,
                    page_limit: 8,
                    page: 10
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if (data.length > 0) {
                    var results = [];
                    $.each(data, function (index, item) {
                        //console.log(item)
                        results.push({
                            id: item.patient_id,
                            text: item.patient_full_name,
                            data: item
                        });
                    });
                    return {
                        results:results,
                        pagination: {
                            more: (params.page * 30) < data.length
                          }
                    };
                }
            }
        },
        escapeMarkup: function (markup) {
            return markup; 
        },
        templateResult: function(res){
            if (res.loading) {
                return res.text;
            }
            if(res.data.patient_id==0){
                return `
                    <div class="media">
                        <div class="media-left media-middle">
                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
                                <span class="">${res.data.patient_id}</span>
                            </a>
                        </div>
                        <div class="media-body">
                            <div class="media-heading">
                                <a href="#" class="letter-icon-title">${res.data.patient_full_name}</a>
                            </div>
                        </div>
                    </div>
                `;
            }else{
                return `
                    <div class="media">
                        <div class="media-left media-middle">
                            <a href="#" class="btn bg-pink-400 btn-rounded btn-icon btn-xlg">
                                <span class="">${res.data.patient_id}</span>
                            </a>
                        </div>
                        <div class="media-body">
                            <p>${res.data.patient_full_name}</p>
                        </div>
                    </div>
                `;
            }
        },
        templateSelection: function  (res) {
            console.error(res)
            return res.q || res.text;
        },
        minimumInputLength: 2,
        placeholder: "Search Name, Mobile, Card ID"
    });

    // Bootstrap Select

    $.fn.selectpicker.defaults = {
        iconBase: '',
        tickIcon: 'icon-checkmark3'
    }

    // Basic select
    $('.bootstrap-select').selectpicker();

    // Select all method
    $('#select-all-values').on('click', function() {
        $('.bootstrap-select').selectpicker('selectAll');
    });


    // Deselect all method
    $('#deselect-all-values').on('click', function() {
        $('.bootstrap-select').selectpicker('deselectAll');
    });


    $('.tokenfield-primary').on('tokenfield:initialize', function (e) {
        $(this).parent().find('.token').addClass('bg-primary')
    });

    // Initialize plugin
    $('.tokenfield-primary').tokenfield();

    // Add class when token is created
    $('.tokenfield-primary').on('tokenfield:createdtoken', function (e) {
        $(e.relatedTarget).addClass('bg-primary')
    });

    // End Bootstrap Select

    $('.daterange-single').daterangepicker({ 
        showDropdowns: true,
        timePicker: true,
        singleDatePicker: true,
        startDate: moment(),
        applyClass: 'bg-slate-600',
        locale: {
            format: 'YYYY-MM-DD H:mm'
        }
    });

    // Numeric date
    $("#anytime-month-numeric").AnyTime_picker({
        format: "%z-%m-%d"
        // format: "%z-%m-%d %H:%i"
    });

    
    var t1 = i18n.t('Search')==''?'Search':i18n.t('Search');
    var t2 = i18n.t('Search For')==''?'Search For':i18n.t('Search For');
    var t3 = i18n.t('Show')==''?'Show':i18n.t('Show');
   // Setting datatable defaults
    $.extend( $.fn.dataTable.defaults, {
        autoWidth: false,
        columnDefs: [{ 
            orderable: false,
            width: '100px',
            targets: [ 4 ]
        }],
        dom: '<"datatable-header"fBl><"datatable-scroll"t><"datatable-footer"ip>',
        language: {
            search: '<span>'+ t1 +':</span> _INPUT_',
            searchPlaceholder: t2 +'...',
            lengthMenu: '<span>'+ t3 +':</span> _MENU_',
            paginate: { 'first': 'First', 'last': 'Last', 'next': '&'+Left_Arraw+'arr;', 'previous': '&'+Right_Arraw+'arr;' }
        },
        drawCallback: function () {
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').addClass('dropup');
        },
        preDrawCallback: function() {
            $(this).find('tbody tr').slice(-3).find('.dropdown, .btn-group').removeClass('dropup');
        }
    });

    

    // Individual column searching with text inputs
    $('.datatable-column-search-inputs tfoot td').not(':last-child').each(function () {
        var title = $('.datatable-column-search-inputs thead th').eq($(this).index()).text();
        $(this).html('<input type="text" class="form-control input-sm" placeholder="'+i18n.t('بحث عن')+' '+title+'" />');
    });
    
    

   
    table = $('.datatable-column-search-inputs').DataTable({
        buttons: {            
            buttons: [
                {
                    extend: 'copyHtml5',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: [ 0, ':visible' ]
                    }
                },
                {
                    extend: 'excelHtml5',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'pdfHtml5',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'print',
                    className: 'btn btn-default',
                    exportOptions: {
                        columns: ':visible'
                    }
                },
                {
                    extend: 'colvis',
                    text: '<i class="icon-three-bars"></i> <span class="caret"></span>',
                    className: 'btn bg-blue btn-icon'
                }
                
            ]
        },
        lengthMenu: [
            [  10, 25, 50, 100, -1 ],
            [  '10', '25', '50', '100', 'All' ]
        ],
        "processing": true,
        "serverSide": true,
        "ajax": {
        "url" : "models/crul_invoice.php",
        "data": function(d){
            d.type = "load";
            var view_cond = $("#view_cond").val();

            if (view_cond ==null) {
                d.view_type = 'today';
            }else{
                d.view_type = view_cond;
            }
        }
        },
        drawCallback: function() {
                  $('[data-popup=tooltip]').tooltip();
                  $('[data-popup=popover-custom]').popover({
                    template: '<div class="popover  border-teal-400"><div class="arrow"></div><h3 class="popover-title bg-teal-400"></h3><div class="popover-content"></div></div>'
                  });

                 

            },
        "columnDefs": [
          {
                "targets": 11,
                "data": null,
                "render": function (data,type,row) {

                    var btns = ``;

                    if(IS_VIEW==0){


                        if (check_permission(59,row[16]) && row[12]==0) {
                          btns+= `<li class='text-primary-300'>
                                      <a  class='text-primary-300' onclick="edit_items(${row[0]})" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-pencil7 icon-2x'></i> ${i18n.t('Edit')}
                                      </a>
                                  </li>`;
                        }

                        if (check_permission(61)) {
                          btns+= `<li class='text-info-300'>
                                      <a  class='text-info-300' onclick="view(${row[0]})" data-popup='tooltip' data-original-title='' style="font-size:14px;">
                                          <i class='icon-printer4 icon-2x'></i> ${i18n.t('Display Invoice With Prices')}
                                      </a>
                                  </li>`;
                        }

                        if (check_permission(144)) {
                          btns+= `<li class='text-info-300'>
                                      <a  class='text-pink-300' onclick="view_no_price(${row[0]})" data-popup='tooltip' data-original-title='' style="font-size:13px;">
                                          <i class='icon-printer4 icon-2x'></i> ${i18n.t('Display Invoice Without Prices')}
                                      </a>
                                  </li>`;
                        }


                        

                        if (check_permission(62)) {
                          btns+= `<li class='text-primary-300'>
                                      <a  class='text-primary-300' onclick="set_status(${row[0]},${row[12]})" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-loop icon-2x'></i> ${i18n.t('Invoice Status')}
                                      </a>
                                  </li>`;
                        }

                        if (check_permission(63) && row[11]!=2) {
                          btns+= `<li class='text-warning-300'>
                                      <a  class='text-warning-300' onclick="add_payment(${row[0]},${row[13]},'${row[5]}','${row[6]}')" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-cash4 icon-2x'></i> ${i18n.t('Add Payment')}
                                      </a>
                                  </li>`;
                        }

                        if (check_permission(64)) {
                          btns+= `<li class='text-success-300'>
                                      <a  class='text-success-300' onclick="pay_status(${row[0]},${row[11]})" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-coins icon-2x'></i> ${i18n.t('Payment Status')}
                                      </a>
                                  </li>`;
                        }
                        

                        if (check_permission(60,row[16]) && row[12]==0 && row[14]==0 && row[15]==0) {
                          btns+= `<li class='text-danger-300'>
                                      <a  class='text-danger-300' onclick="delete_items(${row[0]})" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-trash icon-2x'></i> ${i18n.t('Delete')}
                                      </a>
                                  </li>`;
                        }

                        

                        if (check_permission(65)) {
                          btns+= `<li class='text-info-300'>
                                      <a  class='text-info-300' onclick="get_log(${row[0]},'sell')" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          <i class='icon-file-text2 icon-2x'></i> ${i18n.t('Record Log')}
                                      </a>
                                  </li>`;
                        }

                        

                        

                        return  `<ul class='icons-list '>
                                  
                                    

                                     
                                    <li class="dropdown">
                                      <a  class="dropdown-toggle" data-toggle="dropdown" >
                                        <i class="icon-menu9 icon-2x"></i>
                                      </a>

                                      <ul class="dropdown-menu dropdown-menu-right" style="min-width:250px;">

                                        ${btns}                                             

                                      </ul>
                                    </li>
                                  </ul>`;
                    }else{
                      return '';
                    }
                  

                }
          },

          {
             "render": function(data, type, row){

                if (check_permission(61)) {
                    
                    return `<a  class='text-info-300' onclick="view(${row[0]})" data-popup='tooltip' data-original-title='' style="font-size:16px;">
                                          ${data}
                        </a>`
                }else{
                    return data;
                }
             },
             
             "targets": 3
          },

          {
             "render": function(data, type, row){
                    
                return currency(data)
             },
             
             "targets": 5
          },

          {
             "render": function(data, type, row){
                    
                return currency(data)
             },
             
             "targets": 6
          },

          {
             "render": function(data, type, row){
                    
                switch (data){
                    case 'Not Paid':
                        return  `<span class="label label-danger label-block">${(data)} </span> `;
                        break;
                    case 'Partialy Paid':
                        return  `<span class="label label-warning label-block">${(data)} </span> `;
                        break;
                    case 'Paid':
                        return  `<span class="label label-success label-block">${(data)} </span> `;
                        break;
                    case 'Free':
                        return  `<span class="label label-primary label-block">${(data)} </span> `;
                        break;
                    default:
                        return  `<span class="label label-info label-block">${(data)} </span> `;
                        break;

                }
             },
             
             "targets": 8
          },

          {
             "render": function(data, type, row){
                    
                switch (data){
                    case 'Closed':
                        return  `<span class="label label-danger label-block">${(data)} </span> `;
                        break;
                    case 'Open':
                        return  `<span class="label label-success label-block">${(data)} </span> `;
                        break;
                    default:
                        return  `<span class="label label-info label-block">${(data)} </span> `;
                        break;

                }
             },
             
             "targets": 9
          },

         

           
        ],
        "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {


            if(   aData[4] == 0 ){
                $(nRow).children().each(function (index, td) {
                    $(this).addClass('warning-active');
                });
            }
        },
        "order": [[0,'desc']],
        "displayLength": 25,
 

        initComplete: function () {
         
        // $("div.datatable-header").append(`<a  style="margin-left:15px;" class="btn bg-info-400"  id="headerBtn" onclick="add_item()"> <i class="icon-file-pdf position-right"></i> Add Category </a>`);   
        if(IS_VIEW==0){
          
          if (check_permission(58)) {
          
            $("div.datatable-header").append(`<a data-toggle="collapse"
                                      style="margin:0 5px 0 5px;"
                                      data-target="#add-form-cont"
                                      href="javascript:;"
                                      aria-controls="add-form-cont"
                                      aria-expanded="false"
                                      class="btn btn-primary"
                                      id="add_Item_Btn">
                                        <i class="`+CURRENT_BTN_ICON+`"></i> `+i18n.t(CURRENT_BTN)+`
                                    </a>`); 
          } 

          if (check_permission(21)) {
          
            $("div.datatable-header").append(`<div class="form-group has-feedback has-feedback-left col-lg-1 col-md-1 col-sm-1 col-xs-1">
                                                <select class="form-control" name="view_cond" id="view_cond" data-width="100%" data-live-search="true" style="padding-right: 5px !important; padding-left: 5px; !important">
                                                    <option value="all" data-i18n="page.reception.role">All</option>
                                                    <option value="today" selected data-i18n="page.reception.role">Today</option>
                                                    <option value="yesterday" data-i18n="page.reception.role">Yesterday</option>
                                                    <option value="tomorow" data-i18n="page.reception.role">Tomorow</option>
                                                    <option value="next_week" data-i18n="page.reception.role">Next Week</option>
                                                    <option value="last_week" data-i18n="page.reception.role">Last Week</option>
                                                    <option value="next_month" data-i18n="page.reception.role">Next Month</option>
                                                    <option value="last_month" data-i18n="page.reception.role">Last Month</option>
                                                </select>
                                              </div>`); 
          } 

           
        }


            this.api().columns().every( function() {
                var column = this;
                

            });
        }
    });

    
    table.columns().every( function () {
        var that = this;
        $('input', this.footer()).on('keyup change', function () {
            that.search(this.value).draw();
        });
    });


    // Single row selection
    
    $('.datatable-column-search-inputs tbody').on('click', 'tr', function() {
        if ($(this).hasClass('success')) {
            $(this).removeClass('success');
        }
        else {
            table.$('tr.success').removeClass('success');
            $(this).addClass('success');
        }
    });


         // change filter to top
    $('.datatable-column-search-inputs tfoot tr').insertAfter($('.datatable-column-search-inputs thead tr'))


    $('.dataTables_length select').select2({
        minimumResultsForSearch: Infinity,
        width: 'auto'
    });

    // from cookies to save which column user hide or show 
    if (column_visible.length > 0) {
        table.columns(column_visible).visible(false);
    }



});



