<?php
if (!isset($_SESSION)) {
	session_start();
}
if (!isset($_SESSION['is_login'])) {
	header("location: login.php");
?>
	<script>
		window.location = "login.php";
	</script>
<?php
}


date_default_timezone_set($_SESSION['system_time_zone']);

if (isset($_POST['type']) || isset($_GET['type'])) {
	require_once "db_connect.php";


	if (isset($_GET['type']) && ($_GET['type'] == "load")) {

		$cond 					= "";
		$system_staff_id_fk  	= $_SESSION['system_staff_id_fk'];
		$by 					= $_SESSION['user_id'];
		$department_id_fk 		= $_SESSION['department_id_fk'];
		$date_cond 				= '';



		$cond = isset($_GET['id']) ? " AND PR.patient_id_fk=" . $_GET['id'] : " ";



		$table  =  "(SELECT 
							breast_clinic_id,
							main_complaint,
							breast_clinic_reference_number,
							laterality,
							breast_clinic_date,
							DATE(breast_clinic_date) as breast_clinic_date_format,
		                    patient_full_name,
		                    first_name,
		                    second_name,
		                    third_name,
		                    insurance_status,
		                    patient_phone,
							IFNULL(full_name,'') as site_doctor,
							company_name as company,
							patient_id,
							P.city_name,
							PC.created_at


						FROM breast_clinic PC
							
						LEFT JOIN staff S ON (PC.staff_id_fk = S.staff_id)	
						LEFT JOIN patient P ON (PC.patient_id_fk = P.patient_id)	
						LEFT JOIN company C ON (P.company_id_fk = C.company_id)
							
						WHERE PC.is_deleted =0  $cond
						) AS ALLTBL";


		$primaryKey = 'breast_clinic_id';
		$columns =  array(
			array('db' => 'breast_clinic_id', 'dt' => 0),
			array('db' => 'patient_full_name', 'dt' => 1),
			array('db' => 'patient_phone', 'dt' => 2),
			array('db' => 'breast_clinic_reference_number', 'dt' => 3),
			array('db' => 'breast_clinic_date_format',  'dt' => 4),
			array('db' => 'main_complaint',  'dt' => 5),
			array('db' => 'laterality',  'dt' => 6),
			array('db' => 'insurance_status',  'dt' => 7),
			array('db' => 'company',  'dt' => 8),
			array('db' => 'city_name',  'dt' => 9),
			array('db' => 'patient_id',  'dt' => 10),
			array('db' => 'created_at',  'dt' => 11),

		);



		$ords 		= '';
		$fltr 		= '';
		$limit 		= "";


		// SQL server connection information
		$sql_details = array(
			'user' => $mysql_user,
			'pass' => $mysql_password,
			'db'   => $mysql_db,
			'host' => $mysql_server
		);
		require('ssp.php');
		echo json_encode(
			// SSP::complex_optimized( $_GET, $sql_details, $table, $primaryKey, $columns ,$fltr, $ords, $limit )
			SSP::complex($_GET, $sql_details, $table, $primaryKey, $columns, null, '')

		);
		exit;
	}


	if ($_POST['type'] == "get") {

		$op  = array('is_success' => false, 'data' => array());

		$id = $_POST['id'];

		$res = $db->query("SELECT 	patient_report_id,
										report_reference_number,
										report_date,
										patient_full_name,
										gender,
										patient_date_of_birth,
										blood_group,
										allergies,
										occupation,
										company_name
								FROM patient P
								LEFT JOIN patient_report PR  ON (PR.patient_id_fk = P.patient_id AND PR.is_deleted = 0)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	

								WHERE P.is_deleted = 0 AND patient_id = $id");
		if ($res) {
			while ($row = $res->fetch_assoc()) {
				$result['patient_report_id'] 		= $row['patient_report_id'];
				$result['report_reference_number'] 	= $row['report_reference_number'];
				$result['report_date']				= $row['report_date'];
				$result['patient_full_name']		= $row['patient_full_name'];
				$result['gender']					= $row['gender'];
				$result['patient_date_of_birth']	= $row['patient_date_of_birth'];
				$result['blood_group']				= $row['blood_group'];
				$result['allergies']				= $row['allergies'];
				$result['occupation']				= $row['occupation'];
				$result['company_name']				= $row['company_name'];
				array_push($op['data'], $result);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] = 'Error Has Occure';
			echo json_encode($op);
			exit;
		}
	}


	if ($_POST['type'] == "getcheckup") {

		$op  = array('is_success' => false, 'data' => array());

		$id = $_POST['id'];

		$res = $db->query("SELECT 	breast_clinic_id,
										breast_clinic_reference_number,
										breast_clinic_date as report_date,
										patient_full_name,
										gender,
										patient_date_of_birth,
										blood_group,
										P.allergies,
										PC.insurance_status,
										occupation,
										company_name
								FROM patient P
								LEFT JOIN breast_clinic PC  ON (PC.patient_id_fk = P.patient_id AND PC.is_deleted = 0)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	

								WHERE P.is_deleted = 0 AND patient_id = $id
								ORDER By PC.breast_clinic_id desc limit 1");
		if ($res) {
			while ($row = $res->fetch_assoc()) {
				$result['patient_report_id'] 		= $row['breast_clinic_id'];
				$result['report_reference_number'] 	= $row['breast_clinic_reference_number'];
				// $result['past_medical_history'] 	= $row['past_medical_history'];
				// $result['past_surgical_history'] 	= $row['past_surgical_history'];
				$result['report_date']				= $row['report_date'];
				$result['patient_full_name']		= $row['patient_full_name'];
				$result['gender']					= $row['gender'];
				$result['patient_date_of_birth']	= $row['patient_date_of_birth'];
				$result['blood_group']				= $row['blood_group'];
				$result['allergies']				= $row['allergies'];
				$result['occupation']				= $row['occupation'];
				$result['company_name']				= $row['company_name'];
				$result['insurance_status']			= $row['insurance_status'];
				array_push($op['data'], $result);
			}
			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] = 'Error Has Occure';
			echo json_encode($op);
			exit;
		}
	}


	if ($_POST['type'] == "get_edit") {

		$id = $_POST['edited_id'];
		$op  = array('is_success' => false, 'data' => array(), 'lab' => array(), 'radiology' => array(), 'treat' => array(), 'consultation' => array(), 'service' => array(), 'invoice' => array(), 'detail' => array());

		$res = $db->query("SELECT
									breast_clinic_id,
								    breast_clinic_reference_number,
								    breast_clinic_date,
								    main_complaint,
								    duration,
								    laterality,
								    progression,
								    pain,
								    nipple_discharge,
								    skin_changes,
								    systemic_symptoms,
								    systemic_weight_loss,
								    systemic_fever,
								    systemic_fatigue,
								    lump_size,
								    lump_location,
								    lump_mobility,
								    lump_tenderness,
								    discharge_color,
								    discharge_consistency,
								    discharge_side,
								    pain_character,
								    pain_timing,
								    skin_redness,
								    skin_dimpling,
								    skin_ulceration,
								    infections,
								    trauma,
								    previous_surgeries,
								    benign_lumps,
								    mastitis,
								    biopsies_surgery,
								    diabetes,
								    hypertension,
								    thyroid,
								    other_conditions,
								    current_medications,
								    hormonal_therapy,
								    drug_allergies,
								    other_allergies,
								    breast_cancer_relation,
								    breast_cancer_age,
								    ovarian_cancer_relation,
								    ovarian_cancer_age,
								    genetic_syndromes,
								    menarche_age,
								    cycle_regular,
								    last_period,
								    pregnancies,
								    signature_image,
								    signature_text,
								    live_births,
								    breastfeeding_history,
								    hormonal_contraception,
								    menopause_age,
								    insurance_status,
								    PC.patient_id_fk,
								    PC.staff_id_fk,

								    breast_clinic_detail_id,
								    smoking,
								    alcohol,
								    occupation_exposure,
								    physical_activity,
								    general_weight_loss,
								    general_fatigue,
								    breast_lump,
								    breast_pain,
								    breast_discharge,
								    breast_skin_changes,
								    other_symptoms,
								    mammogram_date,
								    mammogram_result,
								    ultra_sound_date,
								    ultra_sound_result,
								    biopsy_date,
								    biopsy_result,
								    inspection_asymmetry,
								    inspection_skin_changes,
								    inspection_nipple_changes,
								    lump_location_rv,
								    lump_size_rv,
								    lump_mobility_rv,
								    lump_tenderness_rv,
								    axillary_nodes,
								    surgical_scars,
								    age_risk,
								    family_history,
								    genetic_factors,
								    hormonal_exposure,
								    previous_benign_disease,
								    patient_concerns_note,
								    breast_clinic_id_fk,

									 	

									 	patient_full_name,
									 	third_name,
									 	second_name,
									 	first_name,
										gender,
										allergies,
										patient_email,
										patient_address,
										patient_phone,

										signature_image,
										
										patient_date_of_birth,
										blood_group,
										occupation,
										company_name,
										IFNULL(full_name,'') as site_doctor,
										P.insurance,
										P.company_id_fk

								FROM breast_clinic PC
								LEFT JOIN breast_clinic_detail PCD ON (PC.breast_clinic_id = PCD.breast_clinic_id_fk)	
								LEFT JOIN patient P ON (PC.patient_id_fk = P.patient_id)	
								LEFT JOIN company C ON (P.company_id_fk = C.company_id)	
								LEFT JOIN staff S ON (PC.staff_id_fk = S.staff_id)	

								WHERE PC.is_deleted = 0 AND PC.breast_clinic_id = $id 

								");

		

		if ($res) {


			while ($row = $res->fetch_assoc()) {

				$result['breast_clinic_id'] = $row['breast_clinic_id'];
				$result['breast_clinic_reference_number'] = $row['breast_clinic_reference_number'];
				$result['breast_clinic_date'] = $row['breast_clinic_date'];
				$result['main_complaint'] = $row['main_complaint'];
				$result['duration'] = $row['duration'];
				$result['laterality'] = $row['laterality'];
				$result['progression'] = $row['progression'];
				$result['pain'] = $row['pain'];
				$result['nipple_discharge'] = $row['nipple_discharge'];
				$result['skin_changes'] = $row['skin_changes'];
				$result['systemic_symptoms'] = $row['systemic_symptoms'];
				$result['systemic_weight_loss'] = $row['systemic_weight_loss'];
				$result['systemic_fever'] = $row['systemic_fever'];
				$result['systemic_fatigue'] = $row['systemic_fatigue'];
				$result['lump_size'] = $row['lump_size'];
				$result['lump_location'] = $row['lump_location'];
				$result['lump_mobility'] = $row['lump_mobility'];
				$result['lump_tenderness'] = $row['lump_tenderness'];
				$result['discharge_color'] = $row['discharge_color'];
				$result['discharge_consistency'] = $row['discharge_consistency'];
				$result['discharge_side'] = $row['discharge_side'];
				$result['pain_character'] = $row['pain_character'];
				$result['pain_timing'] = $row['pain_timing'];
				$result['skin_redness'] = $row['skin_redness'];
				$result['skin_dimpling'] = $row['skin_dimpling'];
				$result['skin_ulceration'] = $row['skin_ulceration'];
				$result['infections'] = $row['infections'];
				$result['trauma'] = $row['trauma'];
				$result['previous_surgeries'] = $row['previous_surgeries'];
				$result['benign_lumps'] = $row['benign_lumps'];
				$result['mastitis'] = $row['mastitis'];
				$result['biopsies_surgery'] = $row['biopsies_surgery'];
				$result['diabetes'] = $row['diabetes'];
				$result['hypertension'] = $row['hypertension'];
				$result['thyroid'] = $row['thyroid'];
				$result['other_conditions'] = $row['other_conditions'];
				$result['current_medications'] = $row['current_medications'];
				$result['hormonal_therapy'] = $row['hormonal_therapy'];
				$result['drug_allergies'] = $row['drug_allergies'];
				$result['other_allergies'] = $row['other_allergies'];
				$result['breast_cancer_relation'] = $row['breast_cancer_relation'];
				$result['breast_cancer_age'] = $row['breast_cancer_age'];
				$result['ovarian_cancer_relation'] = $row['ovarian_cancer_relation'];
				$result['ovarian_cancer_age'] = $row['ovarian_cancer_age'];
				$result['genetic_syndromes'] = $row['genetic_syndromes'];
				$result['menarche_age'] = $row['menarche_age'];
				$result['cycle_regular'] = $row['cycle_regular'];
				$result['last_period'] = $row['last_period'];
				$result['pregnancies'] = $row['pregnancies'];
				$result['signature_image'] = $row['signature_image'];
				$result['signature_text'] = $row['signature_text'];
				$result['live_births'] = $row['live_births'];
				$result['breastfeeding_history'] = $row['breastfeeding_history'];
				$result['hormonal_contraception'] = $row['hormonal_contraception'];
				$result['menopause_age'] = $row['menopause_age'];
				$result['insurance_status'] = $row['insurance_status'];
				$result['patient_id_fk'] = $row['patient_id_fk'];


				$result['breast_clinic_detail_id'] = $row['breast_clinic_detail_id'];
				$result['smoking'] = $row['smoking'];
				$result['alcohol'] = $row['alcohol'];
				$result['occupation_exposure'] = $row['occupation_exposure'];
				$result['physical_activity'] = $row['physical_activity'];
				$result['general_weight_loss'] = $row['general_weight_loss'];
				$result['general_fatigue'] = $row['general_fatigue'];
				$result['breast_lump'] = $row['breast_lump'];
				$result['breast_pain'] = $row['breast_pain'];
				$result['breast_discharge'] = $row['breast_discharge'];
				$result['breast_skin_changes'] = $row['breast_skin_changes'];
				$result['other_symptoms'] = $row['other_symptoms'];
				$result['mammogram_date'] = $row['mammogram_date'];
				$result['mammogram_result'] = $row['mammogram_result'];
				$result['ultra_sound_date'] = $row['ultra_sound_date'];
				$result['ultra_sound_result'] = $row['ultra_sound_result'];
				$result['biopsy_date'] = $row['biopsy_date'];
				$result['biopsy_result'] = $row['biopsy_result'];
				$result['inspection_asymmetry'] = $row['inspection_asymmetry'];
				$result['inspection_skin_changes'] = $row['inspection_skin_changes'];
				$result['inspection_nipple_changes'] = $row['inspection_nipple_changes'];
				$result['lump_location_rv'] = $row['lump_location_rv'];
				$result['lump_size_rv'] = $row['lump_size_rv'];
				$result['lump_mobility_rv'] = $row['lump_mobility_rv'];
				$result['lump_tenderness_rv'] = $row['lump_tenderness_rv'];
				$result['axillary_nodes'] = $row['axillary_nodes'];
				$result['surgical_scars'] = $row['surgical_scars'];
				$result['age_risk'] = $row['age_risk'];
				$result['family_history'] = $row['family_history'];
				$result['genetic_factors'] = $row['genetic_factors'];
				$result['hormonal_exposure'] = $row['hormonal_exposure'];
				$result['previous_benign_disease'] = $row['previous_benign_disease'];
				$result['patient_concerns_note'] = $row['patient_concerns_note'];
				$result['breast_clinic_id_fk'] = $row['breast_clinic_id_fk'];




				$result['patient_id_fk']  			= $row['patient_id_fk'];
				$result['patient_full_name']  		= $row['patient_full_name'];
				$result['first_name']  				= $row['first_name'];
				$result['second_name']  			= $row['second_name'];
				$result['third_name']  				= $row['third_name'];
				$result['gender']  					= $row['gender'];
				$result['patient_date_of_birth']  	= $row['patient_date_of_birth'];


				$result['patient_phone']  			= $row['patient_phone'];
				$result['patient_email']  			= $row['patient_email'];
				$result['patient_address']  		= $row['patient_address'];
				$result['blood_group']  			= $row['blood_group'];
				$result['allergies']  				= $row['allergies'];
				$result['occupation']  				= $row['occupation'];
				$result['company_name']  			= $row['company_name'];
				$result['site_doctor']  			= $row['site_doctor'];
				$result['insurance']  				= $row['insurance'];
				$result['company_id_fk']  			= $row['company_id_fk'];
				$result['insurance_status']  		= $row['insurance_status'];

				array_push($op['data'], $result);
			}
			

			$op['is_success'] = true;
			echo json_encode($op);
			exit;
		} else {
			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			echo json_encode($op);

			exit;
		}
	}




	if ($_POST['type'] == "update") {

		$id 				 	= $_POST['edited_id'];
		$breast_clinic_date					= !empty($_POST["edit_breast_clinic_date"]) ? $_POST["edit_breast_clinic_date"] : date("Y-m-d H:i:s", time());
		$patient_id_fk 	 				= $_POST["edit_patient_id_fk"];
		$main_complaint					= $_POST["edit_main_complaint"];
		$duration						= addslashes($_POST["edit_duration"]);
		$laterality						= addslashes($_POST["edit_laterality"]);
		$progression					= $_POST["edit_progression"];
		$pain 							= isset($_POST["edit_pain"]) ? $_POST["edit_pain"] : 0;
		$nipple_discharge 				= isset($_POST["edit_nipple_discharge"]) ? $_POST["edit_nipple_discharge"] : 0;
		$skin_changes 					= isset($_POST["edit_skin_changes"]) ? $_POST["edit_skin_changes"] : 0;
		$systemic_symptoms 				= isset($_POST["edit_systemic_symptoms"]) ? $_POST["edit_systemic_symptoms"] : 0;
		$systemic_weight_loss 			= isset($_POST["edit_systemic_weight_loss"]) ? $_POST["edit_systemic_weight_loss"] : 0;
		$systemic_fever 				= isset($_POST["edit_systemic_fever"]) ? $_POST["edit_systemic_fever"] : 0;
		$systemic_fatigue 				= isset($_POST["edit_systemic_fatigue"]) ? $_POST["edit_systemic_fatigue"] : 0;
		$lump_size					= $_POST["edit_lump_size"];
		$lump_location					= $_POST["edit_lump_location"];
		$lump_mobility					= $_POST["edit_lump_mobility"];
		$lump_tenderness 			= isset($_POST["edit_lump_tenderness"]) ? $_POST["edit_lump_tenderness"] : 0;
		$discharge_color					= $_POST["edit_discharge_color"];
		$discharge_consistency					= $_POST["edit_discharge_consistency"];
		$discharge_side					= $_POST["edit_discharge_side"];
		$pain_character					= $_POST["edit_pain_character"];
		$pain_timing					= $_POST["edit_pain_timing"];
		$skin_redness 			= isset($_POST["edit_skin_redness"]) ? $_POST["edit_skin_redness"] : 0;
		$skin_dimpling 			= isset($_POST["edit_skin_dimpling"]) ? $_POST["edit_skin_dimpling"] : 0;
		$skin_ulceration 			= isset($_POST["edit_skin_ulceration"]) ? $_POST["edit_skin_ulceration"] : 0;
		$infections 			= isset($_POST["edit_infections"]) ? $_POST["edit_infections"] : 0;
		$trauma 			= isset($_POST["edit_trauma"]) ? $_POST["edit_trauma"] : 0;
		$previous_surgeries 			= isset($_POST["edit_previous_surgeries"]) ? $_POST["edit_previous_surgeries"] : 0;
		$benign_lumps 			= isset($_POST["edit_benign_lumps"]) ? $_POST["edit_benign_lumps"] : 0;
		$mastitis 			= isset($_POST["edit_mastitis"]) ? $_POST["edit_mastitis"] : 0;
		$biopsies_surgery 			= isset($_POST["edit_biopsies_surgery"]) ? $_POST["edit_biopsies_surgery"] : 0;
		$diabetes 			= isset($_POST["edit_diabetes"]) ? $_POST["edit_diabetes"] : 0;
		$hypertension 			= isset($_POST["edit_hypertension"]) ? $_POST["edit_hypertension"] : 0;
		$thyroid 			= isset($_POST["edit_thyroid"]) ? $_POST["edit_thyroid"] : 0;
		$other_conditions					= $_POST["edit_other_conditions"];
		$current_medications					= $_POST["edit_current_medications"];
		$hormonal_therapy					= $_POST["edit_hormonal_therapy"];
		$drug_allergies					= $_POST["edit_drug_allergies"];
		$other_allergies					= $_POST["edit_other_allergies"];
		$breast_cancer_relation					= $_POST["edit_breast_cancer_relation"];
		$breast_cancer_age					= $_POST["edit_breast_cancer_age"];
		$ovarian_cancer_relation					= $_POST["edit_ovarian_cancer_relation"];
		$ovarian_cancer_age				= $_POST["edit_ovarian_cancer_age"];
		$genetic_syndromes				= $_POST["edit_genetic_syndromes"];
		$menarche_age					= $_POST["edit_menarche_age"];
		$cycle_regular 					= isset($_POST["edit_cycle_regular"]) ? $_POST["edit_cycle_regular"] : 0;
		$last_period					= $_POST["edit_last_period"];
		$pregnancies					= $_POST["edit_pregnancies"];
		$live_births					= $_POST["edit_live_births"];
		$breastfeeding_history			= $_POST["edit_breastfeeding_history"];
		$hormonal_contraception			= $_POST["edit_hormonal_contraception"];
		$menopause_age					= $_POST["edit_menopause_age"];
		

		$smoking 						= isset($_POST["edit_smoking"][0]) ? $_POST["edit_smoking"][0] : 0;
		$alcohol 						= isset($_POST["edit_alcohol"][0]) ? $_POST["edit_alcohol"][0] : 0;

		$occupation_exposure			= $_POST["edit_occupation_exposure"];
		$physical_activity				= $_POST["edit_physical_activity"];
		

		$general_weight_loss 			= isset($_POST["edit_general_weight_loss"][0]) ? $_POST["edit_general_weight_loss"][0] : 0;
		$general_fatigue 				= isset($_POST["edit_general_fatigue"][0]) ? $_POST["edit_general_fatigue"][0] : 0;
		$breast_lump 					= isset($_POST["edit_breast_lump"]) ? $_POST["edit_breast_lump"] : '0';
		$breast_pain 					= isset($_POST["edit_breast_pain"]) ? $_POST["edit_breast_pain"] : '0';
		$breast_discharge 				= isset($_POST["edit_breast_discharge"]) ? $_POST["edit_breast_discharge"] : '0';
		$breast_skin_changes 			= isset($_POST["edit_breast_skin_changes"]) ? $_POST["edit_breast_skin_changes"] : '0';
		$other_symptoms					= $_POST["edit_other_symptoms"];
		$mammogram_date					= $_POST["edit_mammogram_date"];
		$mammogram_result				= $_POST["edit_mammogram_result"];
		$ultra_sound_date				= $_POST["edit_ultra_sound_date"];
		$ultra_sound_result				= $_POST["edit_ultra_sound_result"];
		$biopsy_date				= $_POST["edit_biopsy_date"];
		$biopsy_result				= $_POST["edit_biopsy_result"];

		$inspection_asymmetry 		= isset($_POST["edit_inspection_asymmetry"]) ? $_POST["edit_inspection_asymmetry"] : '0';
		$inspection_skin_changes 	= isset($_POST["edit_inspection_skin_changes"]) ? $_POST["edit_inspection_skin_changes"] : '0';
		$inspection_nipple_changes 	= isset($_POST["edit_inspection_nipple_changes"]) ? $_POST["edit_inspection_nipple_changes"] : '0';
		$lump_location_rv				= $_POST["edit_lump_location_rv"];
		$lump_size_rv				= $_POST["edit_lump_size_rv"];
		$lump_mobility_rv				= $_POST["edit_lump_mobility_rv"];
		$lump_tenderness_rv 	= isset($_POST["edit_lump_tenderness_rv"]) ? $_POST["edit_lump_tenderness_rv"] : '0';
		$axillary_nodes				= $_POST["edit_axillary_nodes"];
		$surgical_scars 	= isset($_POST["edit_surgical_scars"]) ? $_POST["edit_surgical_scars"] : '0';
		$age_risk 	= isset($_POST["edit_age_risk"]) ? $_POST["edit_age_risk"] : '0';
		$family_history 	= isset($_POST["edit_family_history"]) ? $_POST["edit_family_history"] : '0';
		$genetic_factors 	= isset($_POST["edit_genetic_factors"]) ? $_POST["edit_genetic_factors"] : '0';
		$hormonal_exposure 	= isset($_POST["edit_hormonal_exposure"]) ? $_POST["edit_hormonal_exposure"] : '0';
		$previous_benign_disease 	= isset($_POST["edit_previous_benign_disease"]) ? $_POST["edit_previous_benign_disease"] : '0';
		$patient_concerns_note				= $_POST["edit_patient_concerns_note"];
		$occupation				= $_POST["edit_occupation"];

		// $edit_signature_text		= isset($_POST["edit_signature_text"]) ? $_POST["edit_signature_text"] : '';

		$op  = array('is_success' => false, 'data' => '');

		$res = $db->query("SELECT * FROM patient WHERE patient_id=$patient_id_fk ");

		$is_insurance = false;

		if (mysqli_num_rows($res) > 0) {
			$row = $res->fetch_assoc();
			$occupation_val 	= $row['occupation'];
		}

		if ($occupation_val == '' && $occupation != '') {
			$res = $db->query("UPDATE patient SET occupation ='$occupation' WHERE patient_id=$patient_id_fk ");
		}



		$reg_date 		= date("Y-m-d H:i:s", time());
		$invoice_year 	= date("Y", time());

		$res = $db->query("SELECT * FROM breast_clinic WHERE breast_clinic_id=$id");

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$lastaction = "Update breast_clinic information";
		$by 		= $_SESSION['user_id'];

		$update_qry = "UPDATE breast_clinic SET 
								breast_clinic_date = '$breast_clinic_date',
								main_complaint = '$main_complaint',
								duration = '$duration',
								laterality = '$laterality',
								progression = '$progression',
								pain = '$pain',
								nipple_discharge = '$nipple_discharge',
								skin_changes = '$skin_changes',
								systemic_symptoms = '$systemic_symptoms',
								systemic_weight_loss = '$systemic_weight_loss',
								systemic_fever = '$systemic_fever',
								systemic_fatigue = '$systemic_fatigue',
								lump_size = '$lump_size',
								lump_location = '$lump_location',
								lump_mobility = '$lump_mobility',
								lump_tenderness = '$lump_tenderness',
								discharge_color = '$discharge_color',
								discharge_consistency = '$discharge_consistency',
								discharge_side = '$discharge_side',
								pain_character = '$pain_character',
								pain_timing = '$pain_timing',
								skin_redness = '$skin_redness',
								skin_dimpling = '$skin_dimpling',
								skin_ulceration = '$skin_ulceration',
								infections = '$infections',
								trauma = '$trauma',
								previous_surgeries = '$previous_surgeries',
								benign_lumps = '$benign_lumps',
								mastitis = '$mastitis',
								biopsies_surgery = '$biopsies_surgery',
								diabetes = '$diabetes',
								hypertension = '$hypertension',
								thyroid = '$thyroid',
								other_conditions = '$other_conditions',
								current_medications = '$current_medications',
								hormonal_therapy = '$hormonal_therapy',
								drug_allergies = '$drug_allergies',
								other_allergies = '$other_allergies',
								breast_cancer_relation = '$breast_cancer_relation',
								breast_cancer_age = '$breast_cancer_age',
								ovarian_cancer_relation = '$ovarian_cancer_relation',
								ovarian_cancer_age = '$ovarian_cancer_age',
								genetic_syndromes = '$genetic_syndromes',
								menarche_age = '$menarche_age',
								cycle_regular = '$cycle_regular',
								last_period = '$last_period',
								pregnancies = '$pregnancies',
								live_births = '$live_births',
								breastfeeding_history = '$breastfeeding_history',
								hormonal_contraception = '$hormonal_contraception',
								menopause_age = '$menopause_age',
								patient_id_fk = '$patient_id_fk',
								staff_id_fk = '$by',

								
								last_action 				='$lastaction',
								updated_at					='$reg_date',
								last_action_by				='$by' 
							WHERE breast_clinic_id 		= $id";


		$res = $db->query($update_qry);
		if ($res) {

			$update_qry = "UPDATE breast_clinic_detail SET 
										smoking = '$smoking',
										alcohol = '$alcohol',
										occupation_exposure = '$occupation_exposure',
										physical_activity = '$physical_activity',
										general_weight_loss = '$general_weight_loss',
										general_fatigue = '$general_fatigue',
										breast_lump = '$breast_lump',
										breast_pain = '$breast_pain',
										breast_discharge = '$breast_discharge',
										breast_skin_changes = '$breast_skin_changes',
										other_symptoms = '$other_symptoms',
										mammogram_date = '$mammogram_date',
										mammogram_result = '$mammogram_result',
										ultra_sound_date = '$ultra_sound_date',
										ultra_sound_result = '$ultra_sound_result',
										biopsy_date = '$biopsy_date',
										biopsy_result = '$biopsy_result',
										inspection_asymmetry = '$inspection_asymmetry',
										inspection_skin_changes = '$inspection_skin_changes',
										inspection_nipple_changes = '$inspection_nipple_changes',
										lump_location_rv = '$lump_location_rv',
										lump_size_rv = '$lump_size_rv',
										lump_mobility_rv = '$lump_mobility_rv',
										lump_tenderness_rv = '$lump_tenderness_rv',
										axillary_nodes = '$axillary_nodes',
										surgical_scars = '$surgical_scars',
										age_risk = '$age_risk',
										family_history = '$family_history',
										genetic_factors = '$genetic_factors',
										hormonal_exposure = '$hormonal_exposure',
										previous_benign_disease = '$previous_benign_disease',
										patient_concerns_note = '$patient_concerns_note',
										patient_id_fk = '$patient_id_fk',

								
								last_action 			='$lastaction',
								updated_at				='$reg_date',
								last_action_by			='$by' 
							WHERE breast_clinic_id_fk	= $id";


			$res = $db->query($update_qry);




			if (!$res) {
				loglog('Fail Add', "breast_clinic", $id, "$db->error", 'breast_clinic.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$db->rollback();
				echo json_encode($op);
				exit;
			}

			

			// $error = ImageUploader('patient_bedsite', 'patient-file', 'breast_clinic', 'patient_bedsite', $id, 'breast_clinic_id', '');
			

			

			$res = $db->query("SELECT * FROM breast_clinic WHERE breast_clinic_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			loglog('Update', "breast_clinic", $id, "Record Successfully Updated", 'breast_clinic.php', $updated_columns_before, $updated_columns);

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	 	  = "Record Successfully Updated";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Update', "breast_clinic", $id, "$db->error", 'breast_clinic.php');

			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			$db->rollback();
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "set_status") {

		$id 				 	= $_POST['status_id'];
		$appointment_status 	= $_POST["appointment_status"];

		$op  = array('is_success' => false, 'data' => '');

		$reg_date 	= date("Y-m-d H:i:s", time());

		$res = $db->query("SELECT * FROM appointment WHERE appointment_id=$id");

		$before_update = $res->fetch_assoc();

		$db->autocommit(FALSE);

		$lastaction = "Update appointment status";
		$by 		= $_SESSION['user_id'];

		$update_qry = "UPDATE appointment SET 
								appointment_status	='$appointment_status',
								
								last_action 		='$lastaction',
								updated_at			='$reg_date',
								last_action_by		='$by' 
							WHERE appointment_id = $id";


		$res = $db->query($update_qry);
		if ($res) {


			$res = $db->query("SELECT * FROM appointment WHERE appointment_id=$id");

			$after_update = $res->fetch_assoc();

			$updated_columns 		= array_diff_assoc($after_update, $before_update);
			$updated_columns_before = array_diff_assoc($before_update, $after_update);

			loglog('Update', "breast_clinic", $id, "Status Successfully Updated", 'breast_clinic.php', $updated_columns_before, $updated_columns);

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	 	  = "Status Successfully Updated";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Update', "breast_clinic", $id, "$db->error", 'breast_clinic.php');

			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  	= "Error: Update Failed";
			echo json_encode($op);
			exit;
		}
	}


	if ($_POST['type'] == "delete") {

		$id 		= ($_POST["obj_id"]);
		$reg_date 	= date("Y-m-d H:i:s", time());
		$lastaction = "Delete Breast Clinic";

		$op  = array('is_success' => false, 'data' => '');

		$by = $_SESSION['user_id'];
		$db->autocommit(FALSE); // to rollback insertion if update fail

		// $res = $db->query("SELECT * FROM sell WHERE is_deleted=0 AND breast_clinic_id_fk=$id AND pay_status > 0 ");

		// if (mysqli_num_rows($res) > 0) {
		// 	loglog('Fail Delete', 'breast_clinic', $id, "Can Not Delete this Patient Checkup there is an invoice connected with it", 'breast_clinic.php');

		// 	$op['is_success'] = false;
		// 	$op['data'] 	  = "Can Not Delete this Report there is an invoice and payment connected with it";
		// 	echo json_encode($op);
		// 	exit;
		// }

		$res = $db->query("UPDATE breast_clinic SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE breast_clinic_id =$id");
		if ($res) {

			$res = $db->query("UPDATE breast_clinic_detail SET 		
		      						is_deleted 		= 1,
		      						deleted_at 		= '$reg_date',
		      						last_action		= '$lastaction',
		      						updated_at		= '$reg_date',
		      						last_action_by	= '$by' 
	      						WHERE breast_clinic_id_fk =$id");



			loglog('Delete', 'breast_clinic', $id, "Record were Successfuly Deleted", 'breast_clinic.php');

			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	  = "Record were Successfuly Deleted";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Delete', 'breast_clinic', $id, "$db-error", 'breast_clinic.php');
			$db->rollback();
			$op['is_success'] = false;
			$op['data'] 	  = "Error: Delete Failed";
			echo json_encode($op);
			exit;
		}
	}

	if ($_POST['type'] == "create") {
		$breast_clinic_date					= !empty($_POST["breast_clinic_date"]) ? $_POST["breast_clinic_date"] : date("Y-m-d H:i:s", time());
		$patient_id_fk 	 				= $_POST["patient_id_fk"];
		$main_complaint					= $_POST["main_complaint"];
		$duration						= addslashes($_POST["duration"]);
		$laterality						= addslashes($_POST["laterality"]);
		$progression					= $_POST["progression"];
		$pain 							= isset($_POST['pain']) ? $_POST['pain'] : 0;
		$nipple_discharge 				= isset($_POST['nipple_discharge']) ? $_POST['nipple_discharge'] : 0;
		$skin_changes 					= isset($_POST['skin_changes']) ? $_POST['skin_changes'] : 0;
		$systemic_symptoms 				= isset($_POST['systemic_symptoms']) ? $_POST['systemic_symptoms'] : 0;
		$systemic_weight_loss 			= isset($_POST['systemic_weight_loss']) ? $_POST['systemic_weight_loss'] : 0;
		$systemic_fever 				= isset($_POST['systemic_fever']) ? $_POST['systemic_fever'] : 0;
		$systemic_fatigue 				= isset($_POST['systemic_fatigue']) ? $_POST['systemic_fatigue'] : 0;
		$lump_size						= $_POST["lump_size"];
		$lump_location					= $_POST["lump_location"];
		$lump_mobility					= $_POST["lump_mobility"];
		$lump_tenderness 				= isset($_POST['lump_tenderness']) ? $_POST['lump_tenderness'] : 0;
		$discharge_color				= $_POST["discharge_color"];
		$discharge_consistency			= $_POST["discharge_consistency"];
		$discharge_side					= $_POST["discharge_side"];
		$pain_character					= $_POST["pain_character"];
		$pain_timing					= $_POST["pain_timing"];
		$skin_redness 					= isset($_POST['skin_redness']) ? $_POST['skin_redness'] : 0;
		$skin_dimpling 					= isset($_POST['skin_dimpling']) ? $_POST['skin_dimpling'] : 0;
		$skin_ulceration 				= isset($_POST['skin_ulceration']) ? $_POST['skin_ulceration'] : 0;
		$infections 					= isset($_POST['infections']) ? $_POST['infections'] : 0;
		$trauma 						= isset($_POST['trauma']) ? $_POST['trauma'] : 0;
		$previous_surgeries 			= isset($_POST['previous_surgeries']) ? $_POST['previous_surgeries'] : 0;
		$benign_lumps 					= isset($_POST['benign_lumps']) ? $_POST['benign_lumps'] : 0;
		$mastitis 						= isset($_POST['mastitis']) ? $_POST['mastitis'] : 0;
		$biopsies_surgery 				= isset($_POST['biopsies_surgery']) ? $_POST['biopsies_surgery'] : 0;
		$diabetes 						= isset($_POST['diabetes']) ? $_POST['diabetes'] : 0;
		$hypertension 					= isset($_POST['hypertension']) ? $_POST['hypertension'] : 0;
		$thyroid 						= isset($_POST['thyroid']) ? $_POST['thyroid'] : 0;
		$other_conditions				= $_POST["other_conditions"];
		$current_medications			= $_POST["current_medications"];
		$hormonal_therapy				= $_POST["hormonal_therapy"];
		$drug_allergies					= $_POST["drug_allergies"];
		$other_allergies				= $_POST["other_allergies"];
		$breast_cancer_relation			= $_POST["breast_cancer_relation"];
		$breast_cancer_age				= $_POST["breast_cancer_age"]==""?0:$_POST["breast_cancer_age"];
		$ovarian_cancer_relation		= $_POST["ovarian_cancer_relation"];
		$ovarian_cancer_age				= $_POST["ovarian_cancer_age"]==""?0:$_POST["ovarian_cancer_age"];
		$genetic_syndromes				= $_POST["genetic_syndromes"];
		$menarche_age					= $_POST["menarche_age"]==""?0:$_POST["menarche_age"];
		$cycle_regular 					= isset($_POST['cycle_regular']) ? $_POST['cycle_regular'] : 0;
		$last_period					= $_POST["last_period"];
		$pregnancies					= $_POST["pregnancies"]==""?0:$_POST["pregnancies"];
		$live_births					= $_POST["live_births"]==""?0:$_POST["live_births"];
		$breastfeeding_history			= $_POST["breastfeeding_history"];
		$hormonal_contraception			= $_POST["hormonal_contraception"];
		$menopause_age					= $_POST["menopause_age"]==""?0:$_POST["menopause_age"];
		

		$smoking 						= isset($_POST['smoking'][0]) ? $_POST['smoking'][0] : 0;
		$alcohol 						= isset($_POST['alcohol'][0]) ? $_POST['alcohol'][0] : 0;

		$occupation_exposure			= $_POST["occupation_exposure"];
		$physical_activity				= $_POST["physical_activity"];
		

		$general_weight_loss 			= isset($_POST['general_weight_loss'][0]) ? $_POST['general_weight_loss'][0] : 0;
		$general_fatigue 				= isset($_POST['general_fatigue'][0]) ? $_POST['general_fatigue'][0] : 0;
		$breast_lump 					= isset($_POST['breast_lump']) ? $_POST['breast_lump'] : '0';
		$breast_pain 					= isset($_POST['breast_pain']) ? $_POST['breast_pain'] : '0';
		$breast_discharge 				= isset($_POST['breast_discharge']) ? $_POST['breast_discharge'] : '0';
		$breast_skin_changes 			= isset($_POST['breast_skin_changes']) ? $_POST['breast_skin_changes'] : '0';
		$other_symptoms					= $_POST["other_symptoms"];
		$mammogram_date					= $_POST["mammogram_date"];
		$mammogram_result				= $_POST["mammogram_result"];
		$ultra_sound_date				= $_POST["ultra_sound_date"];
		$ultra_sound_result				= $_POST["ultra_sound_result"];
		$biopsy_date					= $_POST["biopsy_date"];
		$biopsy_result					= $_POST["biopsy_result"];

		$inspection_asymmetry 			= isset($_POST['inspection_asymmetry']) ? $_POST['inspection_asymmetry'] : '0';
		$inspection_skin_changes 		= isset($_POST['inspection_skin_changes']) ? $_POST['inspection_skin_changes'] : '0';
		$inspection_nipple_changes 		= isset($_POST['inspection_nipple_changes']) ? $_POST['inspection_nipple_changes'] : '0';
		$lump_location_rv				= $_POST["lump_location_rv"];
		$lump_size_rv					= $_POST["lump_size_rv"];
		$lump_mobility_rv				= $_POST["lump_mobility_rv"];
		$lump_tenderness_rv 	= isset($_POST['lump_tenderness_rv']) ? $_POST['lump_tenderness_rv'] : '0';
		$axillary_nodes				= $_POST["axillary_nodes"];
		$surgical_scars 	= isset($_POST['surgical_scars']) ? $_POST['surgical_scars'] : '0';
		$age_risk 	= isset($_POST['age_risk']) ? $_POST['age_risk'] : '0';
		$family_history 	= isset($_POST['family_history']) ? $_POST['family_history'] : '0';
		$genetic_factors 	= isset($_POST['genetic_factors']) ? $_POST['genetic_factors'] : '0';
		$hormonal_exposure 	= isset($_POST['hormonal_exposure']) ? $_POST['hormonal_exposure'] : '0';
		$previous_benign_disease 	= isset($_POST['previous_benign_disease']) ? $_POST['previous_benign_disease'] : '0';
		$patient_concerns_note				= $_POST["patient_concerns_note"];
		$occupation				= $_POST["occupation"];




		$delete 	= 0;
		$reg_date 	= date("Y-m-d H:i:s", time());
		$invoice_year 	= date("Y", time());
		$last_two_digits = substr($invoice_year, -2);
		$lastaction = "Add New Breast Clinic";
		$by 		= $_SESSION['user_id'];

		$db->autocommit(FALSE);

		$res = $db->query("SELECT * FROM patient WHERE patient_id=$patient_id_fk ");

		$is_insurance = false;

		if (mysqli_num_rows($res) > 0) {
			$row = $res->fetch_assoc();
			$occupation_val 	= $row['occupation'];
		}

		if ($occupation_val == '' && $occupation != '') {
			$res = $db->query("UPDATE patient SET occupation ='$occupation' WHERE patient_id=$patient_id_fk ");
		}


		$res = $db->query("SELECT * FROM bill_setting WHERE is_deleted=0 AND table_name='breast_clinic' ");

		if (mysqli_num_rows($res) > 0) {
			$row = $res->fetch_assoc();
			$sequence_number 	= $row['sequence_number'] + 1;
			$prefix 			= $row['prefix'];
			$bill_id 			= $row['bill_id'];

			$res = $db->query("UPDATE bill_setting SET

											sequence_number 	='$sequence_number',
											last_action 		='$lastaction',
											updated_at			='$reg_date',
											last_action_by		='$by'

									WHERE bill_id=$bill_id  ");
		} else {
			$sequence_number 	= 1;
			$prefix 			= '';
		}

		$branch_id_fk = $_SESSION['branch_id_fk'];

		$res = $db->query("SELECT * FROM branch WHERE is_deleted=0 AND branch_id='$branch_id_fk' ");

		if (mysqli_num_rows($res) > 0) {
			$row 		= $res->fetch_assoc();
			// $prefix 	= $row['branch_prefix'];
		}


		$res = $db->query("SELECT * FROM patient WHERE is_deleted=0 AND patient_id='$patient_id_fk' ");

		if (mysqli_num_rows($res) > 0) {
			$row 				= $res->fetch_assoc();
			$insurance_status 	= $row['insurance'];
		}



		$breast_clinic_reference_number = $last_two_digits . '-' . $prefix . '-' . $sequence_number;

		$sql = "INSERT INTO breast_clinic (	
										 	breast_clinic_reference_number,
										 	breast_clinic_date,
										 	main_complaint,
										 	duration,
										 	laterality,
										 	progression,
										 	pain,
											nipple_discharge,
											skin_changes,
										 	systemic_symptoms,
										 	systemic_weight_loss,
										 	systemic_fever,
										 	systemic_fatigue,
										 	lump_size,
										 	lump_location,
										 	lump_mobility,
										 	lump_tenderness,
										 	discharge_color,
										 	discharge_consistency,
										 	discharge_side,
										 	pain_character,
										 	pain_timing,
										 	skin_redness,
										 	skin_dimpling,
										 	skin_ulceration,
										 	infections,
										 	trauma,
										 	previous_surgeries,
										 	benign_lumps,
										 	mastitis,
										 	biopsies_surgery,
										 	diabetes,
										 	hypertension,
										 	thyroid,
										 	other_conditions,
										 	current_medications,
										 	hormonal_therapy,
										 	drug_allergies,
										 	other_allergies,
										 	breast_cancer_relation,
										 	breast_cancer_age,
										 	ovarian_cancer_relation,
										 	ovarian_cancer_age,
										 	genetic_syndromes,
										 	menarche_age,
										 	cycle_regular,
										 	last_period,
										 	pregnancies,
										 	live_births,
										 	breastfeeding_history,
										 	hormonal_contraception,
										 	menopause_age,
										 	insurance_status,
										 	patient_id_fk,
										 	staff_id_fk,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by)
									VALUES( 
											'$breast_clinic_reference_number',
											'$breast_clinic_date',
											'$main_complaint',
											'$duration',
											'$laterality',
											'$progression',
											'$pain',
											'$nipple_discharge',
											'$skin_changes',
											'$systemic_symptoms',
											'$systemic_weight_loss',
											'$systemic_fever',
											'$systemic_fatigue',
											'$lump_size',
											'$lump_location',
											'$lump_mobility',
											'$lump_tenderness',
											'$discharge_color',
											'$discharge_consistency',
											'$discharge_side',
											'$pain_character',
											'$pain_timing',
											'$skin_redness',
											'$skin_dimpling',
											'$skin_ulceration',
											'$infections',
											'$trauma',
											'$previous_surgeries',
											'$benign_lumps',
											'$mastitis',
											'$biopsies_surgery',
											'$diabetes',
											'$hypertension',
											'$thyroid',
											'$other_conditions',
											'$current_medications',
											'$hormonal_therapy',
											'$drug_allergies',
											'$other_allergies',
											'$breast_cancer_relation',
											'$breast_cancer_age',
											'$ovarian_cancer_relation',
											'$ovarian_cancer_age',
											'$genetic_syndromes',
											'$menarche_age',
											'$cycle_regular',
											'$last_period',
											'$pregnancies',
											'$live_births',
											'$breastfeeding_history',
											'$hormonal_contraception',
											'$menopause_age',
											'$insurance_status',
											'$patient_id_fk',
											'$by',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by')";

		$res = $db->query($sql);
		if ($res) {

			$id 		= 	$db->insert_id;

			$sql2 = "INSERT INTO breast_clinic_detail (	
										 	breast_clinic_id_fk,
										 	smoking,
										 	alcohol,
										 	occupation_exposure,
										 	physical_activity,
										 	general_weight_loss,
										 	general_fatigue,
										 	breast_lump,
										 	breast_pain,
										 	breast_discharge,
										 	breast_skin_changes,
										 	other_symptoms,
										 	mammogram_date,
										 	mammogram_result,
										 	ultra_sound_date,
										 	ultra_sound_result,
										 	biopsy_date,
										 	biopsy_result,
										 	inspection_asymmetry,
										 	inspection_skin_changes,
										 	inspection_nipple_changes,
										 	lump_location_rv,
										 	lump_size_rv,
										 	lump_mobility_rv,
										 	lump_tenderness_rv,
										 	axillary_nodes,
										 	surgical_scars,
										 	age_risk,
										 	family_history,
										 	genetic_factors,
										 	hormonal_exposure,
										 	previous_benign_disease,
										 	patient_concerns_note,
										 	patient_id_fk,
										 	
											created_by,
											created_at,
										    updated_at,
											last_action,
											last_action_by)
									VALUES( 
											'$id',
											'$smoking',
											'$alcohol',
											'$occupation_exposure',
											'$physical_activity',
											'$general_weight_loss',
											'$general_fatigue',
											'$breast_lump',
											'$breast_pain',
											'$breast_discharge',
											'$breast_skin_changes',
											'$other_symptoms',
											'$mammogram_date',
											'$mammogram_result',
											'$ultra_sound_date',
											'$ultra_sound_result',
											'$biopsy_date',
											'$biopsy_result',
											'$inspection_asymmetry',
											'$inspection_skin_changes',
											'$inspection_nipple_changes',
											'$lump_location_rv',
											'$lump_size_rv',
											'$lump_mobility_rv',
											'$lump_tenderness_rv',
											'$axillary_nodes',
											'$surgical_scars',
											'$age_risk',
											'$family_history',
											'$genetic_factors',
											'$hormonal_exposure',
											'$previous_benign_disease',
											'$patient_concerns_note',
											'$patient_id_fk',
											
											'$by',
											'$reg_date',
											'$reg_date',
											'$lastaction',
											'$by')";

			$res = $db->query($sql2);

			if (!$res) {
				loglog('Fail Add', "breast_clinic", $id, "$db->error", 'breast_clinic.php');
				$op['is_success'] = false;
				$op['data'] 	  = $db->error;
				$op['sql2'] 	  = $sql2;
				$op['sql1'] 	  = $sql;
				$db->rollback();
				echo json_encode($op);
				exit;
			}

			

			// $error = ImageUploader('patient_bedsite', 'patient-file', 'breast_clinic', 'patient_bedsite', $id, 'breast_clinic_id', '');
			



			$db->commit();
			$op['is_success'] = true;
			$op['data'] 	  = "Added Successfully";
			echo json_encode($op);
			exit;
		} else {
			loglog('Fail Add', 'breast_clinic', 0, "Failed Add Patient Checkup ($breast_clinic_reference_number) Error:($db->error)", 'breast_clinic.php');

			$op['is_success'] = false;
			$op['data'] 	  = $db->error;
			$op['sql1'] 	  = $sql;

			$db->rollback();
			echo json_encode($op);

			exit;
		}
	}
} else {
	header("Location:../");
	exit;
}
?>